/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.Writer;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.exception.UnsupportedChemObjectException;
import org.openscience.cdk.io.DefaultChemObjectWriter;

public class CrystClustWriter
extends DefaultChemObjectWriter {
    private Writer output;

    public CrystClustWriter(Writer out) {
        this.output = out;
    }

    public String getFormatName() {
        return "CrystClust";
    }

    public void write(ChemObject object) throws UnsupportedChemObjectException {
        if (object instanceof Crystal) {
            this.write((Crystal)object);
        } else if (object instanceof ChemSequence) {
            this.write((ChemSequence)object);
        } else {
            throw new UnsupportedChemObjectException("This object type is not supported.");
        }
    }

    public ChemObject highestSupportedChemObject() {
        return new ChemSequence();
    }

    public void close() throws IOException {
        this.output.close();
    }

    private void write(ChemSequence cs) {
        int count = cs.getChemModelCount();
        for (int i = 0; i < count; ++i) {
            this.write("frame: " + (i + 1) + "\n");
            this.write(cs.getChemModel(i).getCrystal());
        }
    }

    private void write(Crystal crystal) {
        String sg = crystal.getSpaceGroup();
        if ("P 2_1 2_1 2_1".equals(sg)) {
            this.write("P 21 21 21 (1)\n");
        } else {
            this.write("P 1 (1)\n");
        }
        double[] a = crystal.getA();
        for (int i = 0; i <= 2; ++i) {
            this.write(new Double(a[i]).toString());
            this.write("\n");
        }
        double[] b = crystal.getB();
        for (int i = 0; i <= 2; ++i) {
            this.write(new Double(b[i]).toString());
            this.write("\n");
        }
        double[] c = crystal.getC();
        for (int i = 0; i <= 2; ++i) {
            this.write(new Double(c[i]).toString());
            this.write("\n");
        }
        int noatoms = crystal.getAtomCount();
        this.write(new Integer(noatoms).toString());
        this.write("\n");
        if (sg.equals("P1")) {
            this.write("1\n");
        } else {
            this.write("1\n");
        }
        for (int i = 0; i < noatoms; ++i) {
            Atom atom = crystal.getAtomAt(i);
            this.write(atom.getSymbol());
            this.write(":");
            this.write(new Double(atom.getCharge()).toString() + "\n");
            this.write(new Double(atom.getX3d()).toString() + "\n");
            this.write(new Double(atom.getY3d()).toString() + "\n");
            this.write(new Double(atom.getZ3d()).toString() + "\n");
        }
    }

    private void write(String s) {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            System.err.println("CMLWriter IOException while printing \"" + s + "\":\n" + e.toString());
        }
    }
}

