/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.DummyReader;
import org.openscience.cdk.io.SMILESReader;
import org.openscience.cdk.io.XYZReader;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.LoggingTool;

public class ReaderFactory {
    private int headerLength;
    private LoggingTool logger = new LoggingTool(this);
    private static Vector readers = null;

    public ReaderFactory() {
        this(65536);
    }

    public ReaderFactory(int headerLength) {
        this.headerLength = headerLength;
        this.loadReaders();
    }

    public void registerReader(ChemObjectReader reader) {
        readers.addElement(reader);
    }

    private void loadReaders() {
        if (readers == null) {
            this.logger.debug("Starting loading Readers...");
            String[] readerNames = new String[]{"org.openscience.cdk.io.ABINITReader", "org.openscience.cdk.io.Aces2Reader", "org.openscience.cdk.io.ADFReader", "org.openscience.cdk.io.CACheReader", "org.openscience.cdk.io.ChemicalRSSReader", "org.openscience.cdk.io.CIFReader", "org.openscience.cdk.io.CMLReader", "org.openscience.cdk.io.CrystClustReader", "org.openscience.cdk.io.DaltonReader", "org.openscience.cdk.io.GamessReader", "org.openscience.cdk.io.Gaussian03Reader", "org.openscience.cdk.io.Gaussian98Reader", "org.openscience.cdk.io.Gaussian95Reader", "org.openscience.cdk.io.Gaussian94Reader", "org.openscience.cdk.io.Gaussian92Reader", "org.openscience.cdk.io.Gaussian90Reader", "org.openscience.cdk.io.GhemicalMMReader", "org.openscience.cdk.io.HINReader", "org.openscience.cdk.io.IChIReader", "org.openscience.cdk.io.INChIReader", "org.openscience.cdk.io.JaguarReader", "org.openscience.cdk.io.MACiEReader", "org.openscience.cdk.io.MDLReader", "org.openscience.cdk.io.MDLRXNV3000Reader", "org.openscience.cdk.io.MDLRXNReader", "org.openscience.cdk.io.MDLV3000Reader", "org.openscience.cdk.io.Mol2Reader", "org.openscience.cdk.io.MOPAC7Reader", "org.openscience.cdk.io.MOPAC97Reader", "org.openscience.cdk.io.PDBReader", "org.openscience.cdk.io.PMPReader", "org.openscience.cdk.io.ShelXReader", "org.openscience.cdk.io.VASPReader", "org.openscience.cdk.io.ZMatrixReader"};
            readers = new Vector();
            for (int i = 0; i < readerNames.length; ++i) {
                try {
                    ChemObjectReader coReader = (ChemObjectReader)this.getClass().getClassLoader().loadClass(readerNames[i]).newInstance();
                    readers.addElement(coReader);
                    continue;
                }
                catch (ClassNotFoundException exception) {
                    this.logger.error((Object)"Could not find this ChemObjectReader: ", readerNames[i]);
                    this.logger.debug(exception);
                    continue;
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Could not load this ChemObjectReader: ", readerNames[i]);
                    this.logger.debug(exception);
                }
            }
            this.logger.info((Object)"Number of loaded formats used in detection: ", readers.size());
        }
    }

    public String guessFormat(Reader input) throws IOException {
        ChemObjectReader reader = this.createReader(input);
        if (reader != null) {
            return reader.getClass().getName();
        }
        return "Format undetermined";
    }

    public String guessFormat(InputStream input) throws IOException {
        ChemObjectReader reader = this.createReader(input);
        if (reader != null) {
            return reader.getClass().getName();
        }
        return "Format undetermined";
    }

    public ChemObjectReader createReader(InputStream input) throws IOException {
        BufferedInputStream bistream;
        FilterInputStream istreamToRead = bistream = new BufferedInputStream(input, 8192);
        bistream.mark(5);
        int countRead = 0;
        try {
            byte[] abMagic = new byte[4];
            countRead = bistream.read(abMagic, 0, 4);
            bistream.reset();
            if (countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117) {
                istreamToRead = new GZIPInputStream(bistream);
            }
        }
        catch (IOException exception) {
            this.logger.error(exception.getMessage());
            this.logger.debug(exception);
        }
        return this.createReader(new InputStreamReader(istreamToRead));
    }

    public ChemObjectReader createReader(Reader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        int bufferSize = this.headerLength;
        BufferedReader originalBuffer = new BufferedReader(input, bufferSize);
        char[] header = new char[bufferSize];
        if (!originalBuffer.markSupported()) {
            this.logger.error("Mark not supported");
            throw new IllegalArgumentException("input must support mark");
        }
        originalBuffer.mark(bufferSize);
        originalBuffer.read(header, 0, bufferSize);
        originalBuffer.reset();
        BufferedReader buffer = new BufferedReader(new CharArrayReader(header));
        String line = buffer.readLine();
        int lineNumber = 1;
        boolean formatDetected = false;
        while (buffer.ready() && line != null && !formatDetected) {
            this.logger.debug((Object)(lineNumber + ": "), line);
            for (int i = 0; i < readers.size() && !formatDetected; ++i) {
                ChemObjectReader coReader = (ChemObjectReader)readers.elementAt(i);
                if (!coReader.matches(lineNumber, line)) continue;
                formatDetected = true;
                try {
                    ChemObjectReader returnReader = (ChemObjectReader)coReader.getClass().newInstance();
                    this.logger.info((Object)"Detected format: ", returnReader.getFormatName());
                    if (!(returnReader instanceof DummyReader)) {
                        returnReader.setReader(originalBuffer);
                        this.logger.debug("Input Reader set in ChemObjectReader");
                    } else {
                        this.logger.warn("Have not set the Reader, because a DummyReader will throw an exception");
                    }
                    return returnReader;
                }
                catch (Exception exception) {
                    this.logger.error((Object)"Could not create this ChemObjectReader: ", coReader.getClass().getName());
                    this.logger.debug(exception);
                }
            }
            line = buffer.readLine();
            ++lineNumber;
        }
        if (formatDetected) {
            this.logger.warn("Format was detected but it could not instantiate a Reader for that format");
            return null;
        }
        this.logger.warn("Now comes the tricky and more difficult ones....");
        buffer = new BufferedReader(new CharArrayReader(header));
        line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                new Integer(tokenizer.nextToken());
                return new XYZReader(originalBuffer);
            }
            if (tokenCount == 2) {
                new Integer(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return new XYZReader(originalBuffer);
                }
            }
        }
        catch (NumberFormatException exception) {
            this.logger.info("No, it's not a XYZ file");
        }
        try {
            SmilesParser sp = new SmilesParser();
            Molecule m = sp.parseSmiles(line);
            return new SMILESReader(originalBuffer);
        }
        catch (Exception ise) {
            this.logger.info("No, it's not a SMILES file");
            this.logger.warn("File format undetermined");
            return null;
        }
    }
}

