/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import freeware.PrintfFormat;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.tools.MFAnalyser;

public class ShelXWriter
extends DefaultChemObjectWriter {
    private Writer output;

    public ShelXWriter(Writer out) {
        this.output = out;
    }

    public String getFormatName() {
        return "ShelX";
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void write(ChemObject object) throws CDKException {
        if (!(object instanceof Crystal)) {
            throw new CDKException("Only Crystal objects can be read.");
        }
        this.write((Crystal)object);
    }

    public ChemObject highestSupportedChemObject() {
        return new Crystal();
    }

    private void write(Crystal crystal) {
        this.write("TITLE Produced with CDK (http://cdk.sf.net/)\n");
        double[] a = crystal.getA();
        double[] b = crystal.getB();
        double[] c = crystal.getC();
        double alength = this.calcLengthAxis(a);
        double blength = this.calcLengthAxis(b);
        double clength = this.calcLengthAxis(c);
        double alpha = this.calcAxesAngle(b, c);
        double beta = this.calcAxesAngle(a, c);
        double gamma = this.calcAxesAngle(a, b);
        PrintfFormat format = new PrintfFormat("%7.5lf");
        this.write("CELL " + format.sprintf(1.54184) + "   ");
        format = new PrintfFormat("%8.5lf");
        this.write(format.sprintf(alength) + "  ");
        this.write(format.sprintf(blength) + "  ");
        this.write(format.sprintf(clength) + " ");
        format = new PrintfFormat("%8.4lf");
        this.write(format.sprintf(alpha) + " ");
        this.write(format.sprintf(beta) + " ");
        this.write(format.sprintf(gamma) + "\n");
        format = new PrintfFormat("%1.5lf");
        this.write("ZERR " + format.sprintf((double)crystal.getZ()) + "    0.01000  0.01000   0.01000   0.0100   0.0100   0.0100\n");
        String spaceGroup = crystal.getSpaceGroup();
        if ("P1".equals(spaceGroup)) {
            this.write("LATT  -1\n");
        } else if ("P 2_1 2_1 2_1".equals(spaceGroup)) {
            this.write("LATT  -1\n");
            this.write("SYMM  1/2+X   , 1/2-Y   ,    -Z\n");
            this.write("SYMM     -X   , 1/2+Y   , 1/2-Z\n");
            this.write("SYMM  1/2-X   ,    -Y   , 1/2+Z\n");
        }
        MFAnalyser mfa = new MFAnalyser(crystal);
        String elemNames = "";
        String elemCounts = "";
        Vector asortedElements = mfa.getElements();
        Enumeration elements = asortedElements.elements();
        while (elements.hasMoreElements()) {
            String symbol = (String)elements.nextElement();
            elemNames = elemNames + symbol + "    ".substring(symbol.length());
            String countS = new Integer(mfa.getAtomCount(symbol)).toString();
            elemCounts = elemCounts + countS + "    ".substring(countS.length());
        }
        this.write("SFAC  " + elemNames + "\n");
        this.write("UNIT  " + elemCounts + "\n");
        format = new PrintfFormat("%7.5lf");
        for (int i = 0; i < crystal.getAtomCount(); ++i) {
            Atom atom = crystal.getAtomAt(i);
            double[] reals = new double[]{atom.getX3d(), atom.getY3d(), atom.getZ3d()};
            double[] fracs = this.realToFractional(reals, a, b, c);
            String symbol = atom.getSymbol();
            String output = symbol + (i + 1);
            this.write(output);
            for (int j = 1; j < 5 - output.length(); ++j) {
                this.write(" ");
            }
            this.write("     ");
            String elemID = new Integer(asortedElements.indexOf(symbol) + 1).toString();
            this.write(elemID);
            this.write("    ".substring(elemID.length()));
            this.write(format.sprintf(fracs[0]) + "   ");
            this.write(format.sprintf(fracs[1]) + "   ");
            this.write(format.sprintf(fracs[2]) + "    11.00000    0.05000\n");
        }
        this.write("END\n");
    }

    private void write(String s) {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            System.err.println("CMLWriter IOException while printing \"" + s + "\":\n" + e.toString());
        }
    }

    private double[] fractionalToReal(double[] fracs, double[] a, double[] b, double[] c) {
        double[] reals = new double[]{a[0] * fracs[0] + b[0] * fracs[0] + c[0] * fracs[0], a[1] * fracs[1] + b[1] * fracs[1] + c[1] * fracs[1], a[2] * fracs[2] + b[2] * fracs[2] + c[2] * fracs[2]};
        return reals;
    }

    private double[] realToFractional(double[] reals, double[] a, double[] b, double[] c) {
        double[] fracs = new double[3];
        double[][] invaxis = new double[3][3];
        double det = a[0] * b[1] * c[2] - a[0] * b[2] * c[1] - a[1] * b[0] * c[2] + a[1] * b[2] * c[0] + a[2] * b[0] * c[1] - a[2] * b[1] * c[0];
        invaxis[0][0] = (b[1] * c[2] - b[2] * c[1]) / det;
        invaxis[0][1] = (b[2] * c[0] - b[0] * c[2]) / det;
        invaxis[0][2] = (b[0] * c[1] - b[1] * c[0]) / det;
        invaxis[1][0] = (a[2] * c[1] - a[1] * c[2]) / det;
        invaxis[1][1] = (a[0] * c[2] - a[2] * c[0]) / det;
        invaxis[1][2] = (a[1] * c[0] - a[0] * c[1]) / det;
        invaxis[2][0] = (a[1] * b[2] - a[2] * b[1]) / det;
        invaxis[2][1] = (a[2] * b[0] - a[0] * b[2]) / det;
        invaxis[2][2] = (a[0] * b[1] - a[1] * b[0]) / det;
        fracs[0] = invaxis[0][0] * reals[0] + invaxis[0][1] * reals[1] + invaxis[0][2] * reals[2];
        fracs[1] = invaxis[1][0] * reals[0] + invaxis[1][1] * reals[1] + invaxis[1][2] * reals[2];
        fracs[2] = invaxis[2][0] * reals[0] + invaxis[2][1] * reals[1] + invaxis[2][2] * reals[2];
        return fracs;
    }

    private double calcLengthAxis(double[] a) {
        return Math.pow(Math.pow(a[0], 2.0) + Math.pow(a[1], 2.0) + Math.pow(a[2], 2.0), 0.5);
    }

    private double calcAxesAngle(double[] a, double[] b) {
        return 57.29577951308232 * Math.acos((a[0] * b[0] + a[1] * b[1] + a[2] * b[2]) / (this.calcLengthAxis(a) * this.calcLengthAxis(b)));
    }
}

