/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ModuleInterface;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;

public class JMOLANIMATIONConvention
extends CMLCoreModule {
    private final int UNKNOWN = -1;
    private final int ENERGY = 1;
    private int current;
    private String frame_energy;
    private String units;
    private LoggingTool logger = new LoggingTool(this);

    public JMOLANIMATIONConvention(CDOInterface cdo) {
        super(cdo);
        this.current = -1;
    }

    public JMOLANIMATIONConvention(ModuleInterface conv) {
        super(conv);
    }

    public CDOInterface returnCDO() {
        return this.cdo;
    }

    public void startDocument() {
        super.startDocument();
    }

    public void endDocument() {
        super.endDocument();
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        String name = local;
        if (name.equals("list")) {
            this.logger.debug("Oke, JMOLANIMATION seems to be kicked in :)");
            this.cdo.startObject("Animation");
            super.startElement(xpath, uri, local, raw, atts);
        } else if (name.equals("molecule")) {
            this.cdo.startObject("Frame");
            this.logger.debug("New frame being parsed.");
            super.startElement(xpath, uri, local, raw, atts);
        } else if (name.equals("float")) {
            boolean isEnergy = false;
            this.logger.debug("FLOAT found!");
            for (int i = 0; i < atts.getLength(); ++i) {
                this.logger.debug(" att: ", atts.getQName(i), " -> ", atts.getValue(i));
                if (atts.getQName(i).equals("title") && atts.getValue(i).equals("FRAME_ENERGY")) {
                    isEnergy = true;
                    continue;
                }
                if (!atts.getQName(i).equals("units")) continue;
                this.units = atts.getValue(i);
            }
            if (isEnergy) {
                this.current = 1;
            } else {
                super.startElement(xpath, uri, local, raw, atts);
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    public void endElement(CMLStack xpath, String uri, String local, String raw) {
        String name = local;
        if (this.current == 1) {
            this.cdo.setObjectProperty("Frame", "energy", this.frame_energy);
            this.current = -1;
            this.frame_energy = "";
            this.units = "";
        } else if (name.equals("list")) {
            super.endElement(xpath, uri, local, raw);
            this.cdo.endObject("Animation");
        } else if (name.equals("molecule")) {
            super.endElement(xpath, uri, local, raw);
            this.cdo.endObject("Frame");
        } else {
            super.endElement(xpath, uri, local, raw);
        }
    }

    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        if (this.current == 1) {
            this.frame_energy = new String(ch, start, length);
        } else {
            super.characterData(xpath, ch, start, length);
        }
    }
}

