/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.isotopes;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.isotopes.IsotopeHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IsotopeReader {
    private XMLReader parser;
    private Reader input;
    private LoggingTool logger;

    public IsotopeReader(Reader input) {
        this.init();
        this.input = input;
    }

    private void init() {
        this.logger = new LoggingTool(this);
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                this.logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Throwable e) {
                this.logger.warn("Could not instantiate JAXP/SAX XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                this.logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Aelfred2 XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                this.logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                this.logger.warn("Could not instantiate Xerces XML reader!");
                this.logger.debug(e);
            }
        }
        if (!success) {
            this.logger.error("Could not instantiate any XML parser!");
        }
    }

    public Vector readIsotopes() {
        Vector isotopes = null;
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.logger.info("Deactivated validation");
        }
        catch (SAXException e) {
            this.logger.warn("Cannot deactivate validation.");
        }
        IsotopeHandler handler = new IsotopeHandler();
        this.parser.setContentHandler(handler);
        try {
            this.parser.parse(new InputSource(this.input));
            isotopes = handler.getIsotopes();
        }
        catch (IOException e) {
            this.logger.error("IOException: " + e.toString());
        }
        catch (SAXException saxe) {
            this.logger.error("SAXException: " + saxe.getClass().getName());
            this.logger.error(saxe.toString());
        }
        return isotopes;
    }
}

