/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openscience.jmol.ui.JmolPopup;
import org.openscience.jmol.viewer.JmolViewer;

public class JmolPopupSwing
extends JmolPopup {
    JPopupMenu swingPopup = new JPopupMenu("Jmol");
    CheckboxMenuItemListener cmil = new CheckboxMenuItemListener();
    JMenu elementComputedMenu;

    public JmolPopupSwing(JmolViewer viewer) {
        super(viewer);
        this.build(this.swingPopup);
    }

    public void show(int x, int y) {
        Enumeration keys = this.htCheckbox.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)this.htCheckbox.get(key);
            boolean b = this.viewer.getBooleanProperty(key);
            jcbmi.setState(b);
        }
        this.swingPopup.show(this.jmolComponent, x, y);
    }

    void addToMenu(Object menu, JComponent item) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(item);
        } else if (menu instanceof JMenu) {
            ((JMenu)menu).add(item);
        } else {
            System.out.println("cannot add object to menu:" + menu);
        }
    }

    void addMenuSeparator() {
        this.swingPopup.addSeparator();
    }

    void addMenuSeparator(Object menu) {
        if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).addSeparator();
        } else {
            ((JMenu)menu).addSeparator();
        }
    }

    void addMenuItem(String entry) {
        this.swingPopup.add(new JMenuItem(entry));
    }

    void addMenuItem(Object menu, String entry, String script) {
        JMenuItem jmi = new JMenuItem(entry);
        jmi.addActionListener(this.mil);
        jmi.setActionCommand(script);
        this.addToMenu(menu, jmi);
    }

    void addCheckboxMenuItem(Object menu, String entry, String basename) {
        JCheckBoxMenuItem jcmi = new JCheckBoxMenuItem(entry);
        jcmi.addItemListener(this.cmil);
        jcmi.setActionCommand(basename);
        this.addToMenu(menu, jcmi);
        this.rememberCheckbox(basename, jcmi);
    }

    void addMenuSubMenu(Object menu, Object subMenu) {
        this.addToMenu(menu, (JMenu)subMenu);
    }

    Object newMenu(String menuName) {
        return new JMenu(menuName);
    }

    Object newComputedMenu(String key, String word) {
        if ("elementComputedMenu".equals(key)) {
            this.elementComputedMenu = new JMenu(word);
            return this.elementComputedMenu;
        }
        return new JMenu("unrecognized ComputedMenu:" + key);
    }

    void removeAll(Object menu) {
        ((JMenu)menu).removeAll();
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JCheckBoxMenuItem jcmi = (JCheckBoxMenuItem)e.getSource();
            JmolPopupSwing.this.viewer.setBooleanProperty(jcmi.getActionCommand(), jcmi.getState());
        }
    }
}

