/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import org.openscience.jmol.viewer.datamodel.AminoPolymer;
import org.openscience.jmol.viewer.datamodel.Helix;
import org.openscience.jmol.viewer.datamodel.Measurement;
import org.openscience.jmol.viewer.datamodel.Monomer;
import org.openscience.jmol.viewer.datamodel.Polymer;
import org.openscience.jmol.viewer.datamodel.ProteinStructure;
import org.openscience.jmol.viewer.datamodel.Sheet;
import org.openscience.jmol.viewer.datamodel.Turn;

public class AlphaPolymer
extends Polymer {
    static final byte CODE_NADA = 0;
    static final byte CODE_RIGHT_HELIX = 1;
    static final byte CODE_BETA_SHEET = 2;
    static final byte CODE_LEFT_HELIX = 3;
    static final byte CODE_LEFT_TURN = 4;
    static final byte CODE_RIGHT_TURN = 5;
    static final byte TAG_NADA = 0;
    static final byte TAG_TURN = 1;
    static final byte TAG_SHEET = 2;
    static final byte TAG_HELIX = 3;

    AlphaPolymer(Monomer[] monomers) {
        super(monomers);
    }

    void addSecondaryStructure(byte type, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
        int indexEnd;
        int indexStart = this.getIndex(startChainID, startSeqcode);
        if (indexStart == -1 || (indexEnd = this.getIndex(endChainID, endSeqcode)) == -1) {
            return;
        }
        this.addSecondaryStructure(type, indexStart, indexEnd);
    }

    void addSecondaryStructure(byte type, int indexStart, int indexEnd) {
        int structureCount = indexEnd - indexStart + 1;
        if (structureCount < 1) {
            System.out.println("structure definition error\n indexStart:" + indexStart + " indexEnd:" + indexEnd);
            return;
        }
        ProteinStructure proteinstructure = null;
        switch (type) {
            case 3: {
                proteinstructure = new Helix(this, indexStart, structureCount);
                break;
            }
            case 2: {
                if (!(this instanceof AminoPolymer)) break;
                proteinstructure = new Sheet((AminoPolymer)this, indexStart, structureCount);
                break;
            }
            case 1: {
                proteinstructure = new Turn(this, indexStart, structureCount);
                break;
            }
            default: {
                System.out.println("unrecognized secondary structure type");
                return;
            }
        }
        for (int i = indexStart; i <= indexEnd; ++i) {
            this.monomers[i].setStructure(proteinstructure);
        }
    }

    boolean isProtein() {
        return true;
    }

    void calcHydrogenBonds() {
    }

    void calculateStructures() {
        if (this.count < 4) {
            return;
        }
        float[] angles = this.calculateAnglesInDegrees();
        byte[] codes = this.calculateCodes(angles);
        this.checkBetaSheetAlphaHelixOverlap(codes, angles);
        byte[] tags = this.calculateRunsFourOrMore(codes);
        this.extendRuns(tags);
        this.searchForTurns(codes, angles, tags);
        this.addStructuresFromTags(tags);
    }

    float[] calculateAnglesInDegrees() {
        float[] angles = new float[this.count];
        int i = this.count - 1;
        while (--i >= 2) {
            angles[i] = Measurement.computeTorsion(this.monomers[i - 2].getLeadAtomPoint(), this.monomers[i - 1].getLeadAtomPoint(), this.monomers[i].getLeadAtomPoint(), this.monomers[i + 1].getLeadAtomPoint());
        }
        return angles;
    }

    byte[] calculateCodes(float[] angles) {
        byte[] codes = new byte[this.count];
        int i = this.count - 1;
        while (--i >= 2) {
            float degrees = angles[i];
            codes[i] = degrees >= 10.0f && degrees < 120.0f ? 1 : (degrees >= 120.0f || degrees < -90.0f ? 2 : (degrees >= -90.0f && degrees < 0.0f ? 3 : 0));
        }
        return codes;
    }

    void checkBetaSheetAlphaHelixOverlap(byte[] codes, float[] angles) {
        int i = this.count - 2;
        while (--i >= 2) {
            if (codes[i] != 2 || !(angles[i] <= 140.0f) || codes[i - 2] != 1 || codes[i - 1] != 1 || codes[i + 1] != 1 || codes[i + 2] != 1) continue;
            codes[i] = 1;
        }
    }

    byte[] calculateRunsFourOrMore(byte[] codes) {
        byte[] tags = new byte[this.count];
        int tag = 0;
        byte code = 0;
        int runLength = 0;
        for (int i = 0; i < this.count; ++i) {
            if (codes[i] == code && code != 0 && code != 2) {
                if (++runLength == 4) {
                    tag = code == 2 ? 2 : 3;
                    int j = 4;
                    while (--j >= 0) {
                        tags[i - j] = tag;
                    }
                    continue;
                }
                if (runLength <= 4) continue;
                tags[i] = tag;
                continue;
            }
            runLength = 1;
            code = codes[i];
        }
        return tags;
    }

    void extendRuns(byte[] tags) {
        for (int i = 1; i < this.count - 4; ++i) {
            if (tags[i] != 0 || tags[i + 1] == 0) continue;
            tags[i] = tags[i + 1];
        }
        tags[0] = tags[1];
        tags[this.count - 1] = tags[this.count - 2];
    }

    void searchForTurns(byte[] codes, float[] angles, byte[] tags) {
        int i = this.count - 1;
        while (--i >= 2) {
            codes[i] = 0;
            if (tags[i] != 0) continue;
            float angle = angles[i];
            if (angle >= -90.0f && angle < 0.0f) {
                codes[i] = 4;
                continue;
            }
            if (!(angle >= 0.0f) || !(angle < 90.0f)) continue;
            codes[i] = 5;
        }
        i = this.count - 1;
        while (--i >= 0) {
            if (codes[i] == 0 || codes[i + 1] != codes[i] || tags[i] != 0) continue;
            tags[i] = 1;
        }
    }

    void addStructuresFromTags(byte[] tags) {
        int i = 0;
        while (i < this.count) {
            int iMax;
            byte tag = tags[i];
            if (tag == 0) {
                ++i;
                continue;
            }
            for (iMax = i + 1; iMax < this.count && tags[iMax] == tag; ++iMax) {
            }
            this.addSecondaryStructure(tag, i, iMax - 1);
            i = iMax;
        }
    }
}

