/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import org.openscience.jmol.viewer.datamodel.Bspt;

public final class Bspf {
    int dimMax;
    Bspt[] bspts;
    Bspt.SphereIterator[] sphereIterators;

    Bspf(int dimMax) {
        this.dimMax = dimMax;
        this.bspts = new Bspt[0];
        this.sphereIterators = new Bspt.SphereIterator[0];
    }

    int getBsptCount() {
        return this.bspts.length;
    }

    void addTuple(int bsptIndex, Bspt.Tuple tuple) {
        Bspt bspt;
        if (bsptIndex >= this.bspts.length) {
            Bspt[] t = new Bspt[bsptIndex + 1];
            System.arraycopy(this.bspts, 0, t, 0, this.bspts.length);
            this.bspts = t;
        }
        if ((bspt = this.bspts[bsptIndex]) == null) {
            bspt = this.bspts[bsptIndex] = new Bspt(this.dimMax);
        }
        bspt.addTuple(tuple);
    }

    Bspt.SphereIterator getSphereIterator(int bsptIndex) {
        if (bsptIndex >= this.sphereIterators.length) {
            Bspt.SphereIterator[] t = new Bspt.SphereIterator[bsptIndex + 1];
            System.arraycopy(this.sphereIterators, 0, t, 0, this.sphereIterators.length);
            this.sphereIterators = t;
        }
        if (this.sphereIterators[bsptIndex] == null && this.bspts[bsptIndex] != null) {
            this.sphereIterators[bsptIndex] = this.bspts[bsptIndex].allocateSphereIterator();
        }
        return this.sphereIterators[bsptIndex];
    }
}

