/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.awt.FontMetrics;
import org.jmol.g3d.Font3D;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Hover;
import org.openscience.jmol.viewer.datamodel.ShapeRenderer;

class HoverRenderer
extends ShapeRenderer {
    HoverRenderer() {
    }

    void render() {
        Hover hover = (Hover)this.shape;
        if (hover.atomIndex == -1 || hover.labelFormat == null) {
            return;
        }
        Atom atom = this.frame.getAtomAt(hover.atomIndex);
        String msg = atom.formatLabel(hover.labelFormat);
        Font3D font3d = hover.font3d;
        FontMetrics fontMetrics = font3d.fontMetrics;
        int ascent = fontMetrics.getAscent();
        int descent = fontMetrics.getDescent();
        int msgHeight = ascent + descent;
        int msgWidth = fontMetrics.stringWidth(msg);
        short colixBackground = hover.colixBackground;
        short colixForeground = hover.colixForeground;
        int width = msgWidth + 8;
        int height = msgHeight + 8;
        int x = atom.getScreenX() + 4;
        int y = atom.getScreenY() - height - 4;
        int msgX = x + 4;
        int msgYBaseline = y + 4 + ascent;
        if (colixBackground != 0) {
            this.g3d.fillRect(colixBackground, x, y, 1, width, height);
            this.g3d.drawRect(colixForeground, x + 1, y + 1, 1, width - 2, height - 2);
        }
        this.g3d.drawString(msg, font3d, colixForeground, (short)0, msgX, msgYBaseline, 0);
    }
}

