/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.datamodel;

import java.util.BitSet;
import org.jmol.g3d.Font3D;
import org.openscience.jmol.viewer.Util;
import org.openscience.jmol.viewer.datamodel.Atom;
import org.openscience.jmol.viewer.datamodel.Shape;

public class Labels
extends Shape {
    String[] strings;
    short[] colixes;
    short[] bgcolixes;
    byte[] fids;
    short[] offsets;
    Font3D defaultFont3D;

    void initShape() {
        this.defaultFont3D = this.g3d.getFont3D("SansSerif", "Plain", 13);
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Atom atom;
        int i;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = this.g3d.getColix(value);
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                atom = atoms[i];
                if (this.colixes == null || i >= this.colixes.length) {
                    if (colix == 0) continue;
                    this.colixes = Util.ensureLength(this.colixes, i + 1);
                }
                this.colixes[i] = colix;
            }
        }
        if ("bgcolor" == propertyName) {
            short bgcolix = this.g3d.getColix(value);
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                atom = atoms[i];
                if (this.bgcolixes == null || i >= this.bgcolixes.length) {
                    if (bgcolix == 0) continue;
                    this.bgcolixes = Util.ensureLength(this.bgcolixes, i + 1);
                }
                this.bgcolixes[i] = bgcolix;
            }
        }
        if ("label" == propertyName) {
            String strLabel = (String)value;
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                atom = atoms[i];
                String label = atom.formatLabel(strLabel);
                if (this.strings == null || i >= this.strings.length) {
                    if (label == null) continue;
                    this.strings = Util.ensureLength(this.strings, i + 1);
                }
                this.strings[i] = label;
            }
            return;
        }
        if ("fontsize" == propertyName) {
            int fontsize = (Integer)value;
            if (fontsize == 13) {
                this.fids = null;
                return;
            }
            byte fid = this.g3d.getFontFid(fontsize);
            this.fids = Util.ensureLength(this.fids, this.frame.atomCount);
            int i2 = this.frame.atomCount;
            while (--i2 >= 0) {
                this.fids[i2] = fid;
            }
            return;
        }
        if ("font" == propertyName) {
            byte fid = ((Font3D)value).fid;
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                if (this.fids == null || i >= this.fids.length) {
                    if (fid == this.defaultFont3D.fid) continue;
                    this.fids = Util.ensureLength(this.fids, i + 1);
                }
                this.fids[i] = fid;
            }
            return;
        }
        if ("offset" == propertyName) {
            int offset = (Integer)value;
            if (offset == 0) {
                offset = Short.MIN_VALUE;
            } else if (offset == 1028) {
                offset = 0;
            }
            i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                if (this.offsets == null || i >= this.offsets.length) {
                    if (offset == 0) continue;
                    this.offsets = Util.ensureLength(this.offsets, i + 1);
                }
                this.offsets[i] = (short)offset;
            }
            return;
        }
    }
}

