/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.managers;

import java.awt.Image;
import java.awt.Rectangle;
import org.jmol.g3d.Graphics3D;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.FrameRenderer;

public class RepaintManager {
    JmolViewer viewer;
    public FrameRenderer frameRenderer;
    public int displayModelIndex = 0;
    public int animationDirection = 1;
    int currentDirection = 1;
    public int animationFps = 10;
    public int animationReplayMode = 0;
    public float firstFrameDelay;
    public float lastFrameDelay;
    int firstFrameDelayMs;
    int lastFrameDelayMs;
    public boolean wireframeRotating = false;
    public boolean inMotion = false;
    public int holdRepaint = 0;
    public boolean repaintPending;
    final Rectangle rectOversample = new Rectangle();
    boolean tOversample;
    public boolean animationOn = false;
    AnimationThread animationThread;

    public RepaintManager(JmolViewer viewer) {
        this.viewer = viewer;
        this.frameRenderer = new FrameRenderer(viewer);
    }

    public boolean setDisplayModelIndex(int modelIndex) {
        Frame frame = this.viewer.getFrame();
        this.displayModelIndex = modelIndex < 0 || modelIndex >= frame.getModelCount() ? -1 : modelIndex;
        this.displayModelIndex = modelIndex;
        this.viewer.notifyFrameChanged(modelIndex);
        return true;
    }

    public void setAnimationDirection(int animationDirection) {
        if (animationDirection == 1 || animationDirection == -1) {
            this.animationDirection = this.currentDirection = animationDirection;
        } else {
            System.out.println("invalid animationDirection:" + animationDirection);
        }
    }

    public void setAnimationFps(int animationFps) {
        if (animationFps >= 1 && animationFps <= 50) {
            this.animationFps = animationFps;
        } else {
            System.out.println("invalid animationFps:" + animationFps);
        }
    }

    public void setAnimationReplayMode(int animationReplayMode, float firstFrameDelay, float lastFrameDelay) {
        System.out.println("animationReplayMode=" + animationReplayMode);
        this.firstFrameDelay = firstFrameDelay > 0.0f ? firstFrameDelay : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = lastFrameDelay > 0.0f ? lastFrameDelay : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        if (animationReplayMode >= 0 && animationReplayMode <= 2) {
            this.animationReplayMode = animationReplayMode;
        } else {
            System.out.println("invalid animationReplayMode:" + animationReplayMode);
        }
    }

    public boolean setAnimationRelative(int direction) {
        if (this.displayModelIndex < 0) {
            return false;
        }
        int modelIndexNext = this.displayModelIndex + direction * this.currentDirection;
        int modelCount = this.viewer.getModelCount();
        if (modelIndexNext == modelCount) {
            switch (this.animationReplayMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    modelIndexNext = 0;
                    break;
                }
                case 2: {
                    this.currentDirection = -1;
                    modelIndexNext = modelCount - 2;
                }
            }
        } else if (modelIndexNext < 0) {
            switch (this.animationReplayMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    modelIndexNext = modelCount - 1;
                    break;
                }
                case 2: {
                    this.currentDirection = 1;
                    modelIndexNext = 1;
                }
            }
        }
        this.setDisplayModelIndex(modelIndexNext);
        return true;
    }

    public boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    public boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    public void setWireframeRotating(boolean wireframeRotating) {
        this.wireframeRotating = wireframeRotating;
    }

    public void setInMotion(boolean inMotion) {
        if (this.inMotion != inMotion && this.viewer.getWireframeRotation()) {
            this.setWireframeRotating(inMotion);
            if (!inMotion) {
                this.refresh();
            }
        }
        this.inMotion = inMotion;
    }

    public Image takeSnapshot() {
        return null;
    }

    public void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    public void popHoldRepaint() {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            this.repaintPending = true;
            this.viewer.awtComponent.repaint();
        }
    }

    public void forceRefresh() {
        this.repaintPending = true;
        this.viewer.awtComponent.repaint();
    }

    public void refresh() {
        if (this.repaintPending) {
            return;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.viewer.awtComponent.repaint();
        }
    }

    public synchronized void requestRepaintAndWait() {
        this.viewer.awtComponent.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void notifyRepainted() {
        this.repaintPending = false;
        this.notify();
    }

    public void setOversample(boolean tOversample) {
        this.tOversample = tOversample;
    }

    public void render(Graphics3D g3d, Rectangle rectClip, Frame frame, int displayModelID) {
        this.frameRenderer.render(g3d, rectClip, frame, displayModelID);
        this.viewer.checkCameraDistance();
        Rectangle band = this.viewer.getRubberBandSelection();
        if (band != null) {
            g3d.drawRect(this.viewer.getColixRubberband(), band.x, band.y, 0, band.width, band.height);
        }
    }

    public void clearAnimation() {
        this.setAnimationOn(false);
        this.setDisplayModelIndex(0);
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(0, 0.0f, 0.0f);
    }

    public void setAnimationOn(boolean animationOn) {
        if (!animationOn || !this.viewer.haveFrame()) {
            if (this.animationThread != null) {
                this.animationThread.interrupt();
                this.animationThread = null;
            }
            this.animationOn = false;
            return;
        }
        int modelCount = this.viewer.getModelCount();
        if (modelCount <= 1) {
            this.animationOn = false;
            return;
        }
        this.currentDirection = this.animationDirection;
        this.setDisplayModelIndex(this.animationDirection == 1 ? 0 : modelCount - 1);
        if (this.animationThread == null) {
            this.animationThread = new AnimationThread(modelCount);
            this.animationThread.start();
        }
        this.animationOn = true;
    }

    class AnimationThread
    extends Thread
    implements Runnable {
        final int modelCount;
        final int lastModelIndex;

        AnimationThread(int modelCount) {
            this.modelCount = modelCount;
            this.lastModelIndex = modelCount - 1;
        }

        public void run() {
            long timeBegin = System.currentTimeMillis();
            int targetTime = 0;
            RepaintManager.this.requestRepaintAndWait();
            try {
                int sleepTime = targetTime - (int)(System.currentTimeMillis() - timeBegin);
                if (sleepTime > 0) {
                    Thread.sleep(sleepTime);
                }
                while (!this.isInterrupted()) {
                    if (RepaintManager.this.displayModelIndex == 0 && (sleepTime = (targetTime += RepaintManager.this.firstFrameDelayMs) - (int)(System.currentTimeMillis() - timeBegin)) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    if (RepaintManager.this.displayModelIndex == this.lastModelIndex && (sleepTime = (targetTime += RepaintManager.this.lastFrameDelayMs) - (int)(System.currentTimeMillis() - timeBegin)) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    if (!RepaintManager.this.setAnimationNext()) {
                        RepaintManager.this.setAnimationOn(false);
                        return;
                    }
                    sleepTime = (targetTime += 1000 / RepaintManager.this.animationFps) - (int)(System.currentTimeMillis() - timeBegin);
                    if (sleepTime < 0) continue;
                    RepaintManager.this.refresh();
                    sleepTime = targetTime - (int)(System.currentTimeMillis() - timeBegin);
                    if (sleepTime <= 0) continue;
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException ie) {
                System.out.println("animation interrupted!");
            }
        }
    }
}

