/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.managers;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.openscience.jmol.viewer.JmolViewer;

public class TransformManager {
    JmolViewer viewer;
    public final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    public int xTranslation;
    public int yTranslation;
    final AxisAngle4f axisangleT = new AxisAngle4f();
    final Vector3f vectorT = new Vector3f();
    public boolean zoomEnabled = true;
    public int zoomPercent = 100;
    public int zoomPercentSetting = 100;
    public boolean slabEnabled = false;
    public int modeSlab;
    public int slabPercentSetting = 100;
    public int depthPercentSetting = 0;
    private int slabValue;
    private int depthValue;
    public boolean perspectiveDepth = true;
    public float cameraDepth = 3.0f;
    int cameraDistance = 1000;
    float cameraDistanceFloat = 1000.0f;
    boolean tOversample;
    public int width;
    public int height;
    public int width1;
    public int height1;
    public int width4;
    public int height4;
    public int minScreenDimension;
    public float scalePixelsPerAngstrom;
    public float scaleDefaultPixelsPerAngstrom;
    public final Matrix4f matrixTransform = new Matrix4f();
    private final Point3f point3fVibrationTemp = new Point3f();
    private final Point3f point3fScreenTemp = new Point3f();
    private final Point3i point3iScreenTemp = new Point3i();
    private final Matrix4f matrixTemp = new Matrix4f();
    private final Vector3f vectorTemp = new Vector3f();
    public boolean axesOrientationRasmol = false;
    public boolean increaseRotationRadius;
    int minimumZ;
    boolean vibrationOn;
    public float vibrationPeriod;
    int vibrationPeriodMs;
    float vibrationAmplitude;
    public float vibrationRadians;
    public float vectorScale = 1.0f;
    public float vibrationScale = 1.0f;
    public int spinX;
    public int spinY = 30;
    public int spinZ;
    public int spinFps = 30;
    static final float twoPI = (float)Math.PI * 2;
    public boolean spinOn;
    SpinThread spinThread;
    VibrationThread vibrationThread;

    public TransformManager(JmolViewer viewer) {
        this.viewer = viewer;
    }

    public void homePosition() {
        this.matrixRotate.setIdentity();
        this.setZoomEnabled(true);
        this.zoomToPercent(100);
        this.scaleFitToScreen();
    }

    public void rotateXYBy(int xDelta, int yDelta) {
        this.rotateXRadians((float)yDelta * ((float)Math.PI / 180));
        this.rotateYRadians((float)xDelta * ((float)Math.PI / 180));
    }

    public void rotateZBy(int zDelta) {
        this.rotateZRadians((float)Math.PI * (float)zDelta / 180.0f);
    }

    public void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    public void rotateToX(float angleRadians) {
        this.matrixRotate.rotX(angleRadians);
    }

    public void rotateToY(float angleRadians) {
        this.matrixRotate.rotY(angleRadians);
    }

    public void rotateToZ(float angleRadians) {
        this.matrixRotate.rotZ(angleRadians);
    }

    public synchronized void rotateXRadians(float angleRadians) {
        this.matrixTemp3.rotX(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    public synchronized void rotateYRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotY(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    public synchronized void rotateZRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotZ(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    public void rotateZRadiansScript(float angleRadians) {
        this.matrixTemp3.rotZ(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    public void rotate(AxisAngle4f axisAngle) {
        this.matrixTemp3.setIdentity();
        this.matrixTemp3.set(axisAngle);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    public void rotateAxisAngle(float x, float y, float z, float degrees) {
        this.axisangleT.set(x, y, z, degrees * ((float)Math.PI / 180));
        this.rotate(this.axisangleT);
    }

    public void rotateTo(float x, float y, float z, float degrees) {
        if ((double)degrees < 0.01 && (double)degrees > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.axisangleT.set(x, y, z, degrees * ((float)Math.PI / 180));
            this.matrixRotate.set(this.axisangleT);
        }
    }

    public void rotateTo(AxisAngle4f axisAngle) {
        if ((double)axisAngle.angle < 0.01 && (double)axisAngle.angle > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.matrixRotate.set(axisAngle);
        }
    }

    public void translateXYBy(int xDelta, int yDelta) {
        this.xTranslation += xDelta;
        this.yTranslation += yDelta;
    }

    public void translateToXPercent(int percent) {
        this.xTranslation = this.width / 2 + this.width * percent / 100;
    }

    public void translateToYPercent(int percent) {
        this.yTranslation = this.height / 2 + this.height * percent / 100;
    }

    public void translateToZPercent(int percent) {
    }

    public int getTranslationXPercent() {
        return (this.xTranslation - this.width / 2) * 100 / this.width;
    }

    public int getTranslationYPercent() {
        return (this.yTranslation - this.height / 2) * 100 / this.height;
    }

    public int getTranslationZPercent() {
        return 0;
    }

    public String getOrientationText() {
        return this.getMoveToText() + "\nOR\n" + this.getRotateZyzText();
    }

    String getMoveToText() {
        this.axisangleT.set(this.matrixRotate);
        float degrees = this.axisangleT.angle * 57.29578f;
        StringBuffer sb = new StringBuffer();
        sb.append("moveTo 1");
        if (degrees < 0.01f) {
            sb.append(" 0 0 0 0");
        } else {
            this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
            this.vectorT.normalize();
            TransformManager.truncate0(sb, this.vectorT.x);
            TransformManager.truncate0(sb, this.vectorT.y);
            TransformManager.truncate0(sb, this.vectorT.z);
            TransformManager.truncate1(sb, degrees);
        }
        int zoom = this.getZoomPercent();
        int tX = this.getTranslationXPercent();
        int tY = this.getTranslationYPercent();
        if (zoom != 100 || tX != 0 || tY != 0) {
            sb.append(" ");
            sb.append(zoom);
        }
        if (tX != 0 || tY != 0) {
            sb.append(" ");
            sb.append(tX);
            sb.append(" ");
            sb.append(tY);
        }
        return "" + sb;
    }

    String getRotateZyzText() {
        int tY;
        int tX;
        float rZ2;
        float rZ1;
        StringBuffer sb = new StringBuffer();
        float m22 = this.matrixRotate.m22;
        float rY = (float)Math.acos(m22) * 57.29578f;
        if (m22 > 0.999f || m22 < -0.999f) {
            rZ1 = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29578f;
            rZ2 = 0.0f;
        } else {
            rZ1 = (float)Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29578f;
            rZ2 = (float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29578f;
        }
        sb.append("reset");
        if (rZ1 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ1);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate1(sb, rY);
        }
        if (rZ2 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ2);
        }
        sb.append(";");
        int zoom = this.getZoomPercent();
        if (zoom != 100) {
            sb.append(" zoom ");
            sb.append(zoom);
            sb.append(";");
        }
        if ((tX = this.getTranslationXPercent()) != 0) {
            sb.append(" translate x ");
            sb.append(tX);
            sb.append(";");
        }
        if ((tY = this.getTranslationYPercent()) != 0) {
            sb.append(" translate y ");
            sb.append(tY);
            sb.append(";");
        }
        return "" + sb;
    }

    static void truncate0(StringBuffer sb, float val) {
        sb.append(" ");
        sb.append(Math.round(val));
    }

    static void truncate1(StringBuffer sb, float val) {
        sb.append(" ");
        sb.append((float)Math.round(val * 10.0f) / 10.0f);
    }

    public void getAxisAngle(AxisAngle4f axisAngle) {
        axisAngle.set(this.matrixRotate);
    }

    public String getTransformText() {
        return "matrixRotate=\n" + this.matrixRotate;
    }

    public void setRotation(Matrix3f matrixRotation) {
        this.matrixRotate.set(matrixRotation);
    }

    public void getRotation(Matrix3f matrixRotation) {
        matrixRotation.set(this.matrixRotate);
    }

    public void zoomBy(int pixels) {
        if (pixels > 20) {
            pixels = 20;
        } else if (pixels < -20) {
            pixels = -20;
        }
        int deltaPercent = pixels * this.zoomPercentSetting / 50;
        if (deltaPercent == 0) {
            deltaPercent = pixels > 0 ? 1 : (deltaPercent < 0 ? -1 : 0);
        }
        int percent = deltaPercent + this.zoomPercentSetting;
        this.zoomToPercent(percent);
    }

    public int getZoomPercent() {
        return this.zoomPercent;
    }

    public int getZoomPercentSetting() {
        return this.zoomPercentSetting;
    }

    public void zoomToPercent(int percentZoom) {
        this.zoomPercentSetting = percentZoom;
        this.calcZoom();
    }

    public void zoomByPercent(int percentZoom) {
        int delta = percentZoom * this.zoomPercentSetting / 100;
        if (delta == 0) {
            delta = percentZoom < 0 ? -1 : 1;
        }
        this.zoomPercentSetting += delta;
        this.calcZoom();
    }

    private void calcZoom() {
        if (this.zoomPercentSetting < 5) {
            this.zoomPercentSetting = 5;
        }
        if (this.zoomPercentSetting > 2000) {
            this.zoomPercentSetting = 2000;
        }
        this.zoomPercent = this.zoomEnabled ? this.zoomPercentSetting : 100;
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom * (float)this.zoomPercent / 100.0f;
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        if (this.zoomEnabled != zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
            this.calcZoom();
        }
    }

    public void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom = 72.0f / angstromsPerInch;
    }

    public boolean getSlabEnabled() {
        return this.slabEnabled;
    }

    public int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    public void slabBy(int pixels) {
        int percent = pixels * this.slabPercentSetting / this.minScreenDimension;
        if (percent == 0) {
            percent = pixels < 0 ? -1 : 1;
        }
        this.slabPercentSetting += percent;
    }

    public void slabToPercent(int percentSlab) {
        this.slabPercentSetting = percentSlab < 0 ? 0 : (percentSlab > 100 ? 100 : percentSlab);
    }

    public void slabByPercent(int percentSlab) {
        int delta = percentSlab * this.slabPercentSetting / 100;
        if (delta == 0) {
            delta = percentSlab < 0 ? -1 : 1;
        }
        this.slabPercentSetting += delta;
    }

    public void setSlabEnabled(boolean slabEnabled) {
        this.slabEnabled = slabEnabled;
    }

    public void depthToPercent(int percentDepth) {
        this.depthPercentSetting = percentDepth < 0 ? 0 : (percentDepth > 100 ? 100 : percentDepth);
    }

    public void setModeSlab(int modeSlab) {
        this.modeSlab = modeSlab;
    }

    public int getModeSlab() {
        return this.modeSlab;
    }

    void calcSlabAndDepthValues() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (this.slabEnabled) {
            int radius = (int)(this.viewer.getRotationRadius() * this.scalePixelsPerAngstrom);
            this.slabValue = (100 - this.slabPercentSetting) * 2 * radius / 100 + this.cameraDistance;
            this.depthValue = (100 - this.depthPercentSetting) * 2 * radius / 100 + this.cameraDistance;
        }
    }

    public void setPerspectiveDepth(boolean perspectiveDepth) {
        this.perspectiveDepth = perspectiveDepth;
        this.scaleFitToScreen();
    }

    public boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    public void setCameraDepth(float depth) {
        this.cameraDepth = depth;
    }

    public float getCameraDepth() {
        return this.cameraDepth;
    }

    public void setScreenDimension(int width, int height) {
        this.width1 = this.width = width;
        this.width4 = width + width;
        this.height1 = this.height = height;
        this.height4 = height + height;
    }

    public void setOversample(boolean tOversample) {
        if (this.tOversample == tOversample) {
            return;
        }
        this.tOversample = tOversample;
        if (tOversample) {
            this.width = this.width4;
            this.height = this.height4;
        } else {
            this.width = this.width1;
            this.height = this.height1;
        }
        this.scaleFitToScreen();
    }

    public void scaleFitToScreen() {
        if (this.width == 0 || this.height == 0 || !this.viewer.haveFrame()) {
            return;
        }
        this.xTranslation = this.width / 2;
        this.yTranslation = this.height / 2;
        this.minScreenDimension = this.width;
        if (this.height < this.minScreenDimension) {
            this.minScreenDimension = this.height;
        }
        if (this.minScreenDimension > 2) {
            this.minScreenDimension -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = (float)(this.minScreenDimension / 2) / this.viewer.getRotationRadius();
        if (this.perspectiveDepth) {
            this.cameraDistance = (int)(this.cameraDepth * (float)this.minScreenDimension);
            this.cameraDistanceFloat = this.cameraDistance;
            float scaleFactor = (float)(this.cameraDistance + this.minScreenDimension / 2) / this.cameraDistanceFloat;
            scaleFactor = (float)((double)scaleFactor + 0.02);
            this.scaleDefaultPixelsPerAngstrom *= scaleFactor;
        }
        this.calcZoom();
    }

    public float scaleToScreen(int z, float sizeAngstroms) {
        float pixelSize = sizeAngstroms * this.scalePixelsPerAngstrom;
        if (this.perspectiveDepth) {
            pixelSize = pixelSize * (float)this.cameraDistance / (float)z;
        }
        return pixelSize;
    }

    public float scaleToPerspective(int z, float sizeAngstroms) {
        return this.perspectiveDepth ? sizeAngstroms * (float)this.cameraDistance / (float)z : sizeAngstroms;
    }

    public short scaleToScreen(int z, int milliAngstroms) {
        if (milliAngstroms == 0) {
            return 0;
        }
        int pixelSize = (int)((float)milliAngstroms * this.scalePixelsPerAngstrom / 1000.0f);
        if (this.perspectiveDepth) {
            pixelSize = pixelSize * this.cameraDistance / z;
        }
        if (pixelSize == 0) {
            return 1;
        }
        return (short)pixelSize;
    }

    public void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.axesOrientationRasmol = axesOrientationRasmol;
    }

    public void calcTransformMatrices() {
        this.calcTransformMatrix();
        this.calcSlabAndDepthValues();
        this.viewer.setSlabAndDepthValues(this.slabValue, this.depthValue);
        this.increaseRotationRadius = false;
        this.minimumZ = Integer.MAX_VALUE;
    }

    public float getRotationRadiusIncrease() {
        System.out.println("TransformManager.getRotationRadiusIncrease()");
        System.out.println("minimumZ=" + this.minimumZ);
        int backupDistance = this.cameraDistance - this.minimumZ + 1;
        float angstromsIncrease = (float)backupDistance / this.scalePixelsPerAngstrom;
        System.out.println("angstromsIncrease=" + angstromsIncrease);
        return angstromsIncrease;
    }

    private void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set(this.viewer.getRotationCenter());
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.vectorTemp.x = 0.0f;
        this.vectorTemp.y = 0.0f;
        this.vectorTemp.z = this.viewer.getRotationRadius() + this.cameraDistanceFloat / this.scalePixelsPerAngstrom;
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        if (this.axesOrientationRasmol) {
            this.matrixTransform.add(this.matrixTemp);
        } else {
            this.matrixTransform.sub(this.matrixTemp);
        }
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        if (!this.axesOrientationRasmol) {
            this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        }
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
    }

    public Matrix4f getUnscaledTransformMatrix() {
        Matrix4f unscaled = new Matrix4f();
        unscaled.setIdentity();
        this.vectorTemp.set(this.viewer.getRotationCenter());
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        unscaled.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        unscaled.mul(this.matrixTemp, unscaled);
        return unscaled;
    }

    public void transformPoints(int count, Point3f[] angstroms, Point3i[] screens) {
        int i = count;
        while (--i >= 0) {
            screens[i].set(this.transformPoint(angstroms[i]));
        }
    }

    public void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms));
    }

    public Point3i transformPoint(Point3f pointAngstroms) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        int z = (int)this.point3fScreenTemp.z;
        if (z < this.cameraDistance) {
            System.out.println("need to back up the camera");
            System.out.println("point3fScreenTemp.z=" + this.point3fScreenTemp.z + " -> z=" + z);
            this.increaseRotationRadius = true;
            if (z < this.minimumZ) {
                this.minimumZ = z;
            }
            if (z <= 0) {
                System.out.println("WARNING! DANGER! z <= 0! transformPoint() point=" + pointAngstroms + "  ->  " + this.point3fScreenTemp);
                z = 1;
            }
        }
        this.point3iScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / (float)z;
            this.point3fScreenTemp.x *= perspectiveFactor;
            this.point3fScreenTemp.y *= perspectiveFactor;
        }
        this.point3iScreenTemp.x = (int)(this.point3fScreenTemp.x + (float)this.xTranslation);
        this.point3iScreenTemp.y = (int)(this.point3fScreenTemp.y + (float)this.yTranslation);
        return this.point3iScreenTemp;
    }

    public void transformPoint(Point3f pointAngstroms, Point3f screen) {
        this.matrixTransform.transform(pointAngstroms, screen);
        float z = screen.z;
        if (z < (float)this.cameraDistance) {
            System.out.println("need to back up the camera");
            this.increaseRotationRadius = true;
            if (z < (float)this.minimumZ) {
                this.minimumZ = (int)z;
            }
            if (z <= 0.0f) {
                System.out.println("WARNING! DANGER! z <= 0! transformPoint()");
                z = 1.0f;
            }
        }
        screen.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / z;
            screen.x = screen.x * perspectiveFactor + (float)this.xTranslation;
            screen.y = screen.y * perspectiveFactor + (float)this.yTranslation;
        } else {
            screen.x += (float)this.xTranslation;
            screen.y += (float)this.yTranslation;
        }
    }

    public Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        if (!this.vibrationOn || vibrationVector == null) {
            this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        } else {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, vibrationVector, pointAngstroms);
            this.matrixTransform.transform(this.point3fVibrationTemp, this.point3fScreenTemp);
        }
        int z = (int)this.point3fScreenTemp.z;
        if (z < this.cameraDistance) {
            System.out.println("need to back up the camera");
            this.increaseRotationRadius = true;
            if (z < this.minimumZ) {
                this.minimumZ = z;
            }
            if (z <= 0) {
                System.out.println("WARNING! DANGER! z <= 0! transformPoint()");
                z = 1;
            }
        }
        this.point3iScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / (float)z;
            this.point3fScreenTemp.x *= perspectiveFactor;
            this.point3fScreenTemp.y *= perspectiveFactor;
        }
        this.point3iScreenTemp.x = (int)(this.point3fScreenTemp.x + (float)this.xTranslation);
        this.point3iScreenTemp.y = (int)(this.point3fScreenTemp.y + (float)this.yTranslation);
        return this.point3iScreenTemp;
    }

    public void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms, vibrationVector));
    }

    public void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.matrixTransform.transform(vectorAngstroms, vectorTransformed);
    }

    public void setVibrationPeriod(float period) {
        if (period <= 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
            this.clearVibration();
        } else {
            this.vibrationPeriod = period;
            this.vibrationPeriodMs = (int)(period * 1000.0f);
            this.setVibrationOn(true);
        }
    }

    public void setVibrationT(float t) {
        this.vibrationRadians = t * ((float)Math.PI * 2);
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    public void setVectorScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vectorScale = scale;
        }
    }

    public void setVibrationScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vibrationScale = scale;
        }
    }

    public void setSpinX(int value) {
        this.spinX = value;
    }

    public void setSpinY(int value) {
        this.spinY = value;
    }

    public void setSpinZ(int value) {
        this.spinZ = value;
    }

    public void setSpinFps(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 50) {
            value = 50;
        }
        this.spinFps = value;
    }

    public void setSpinOn(boolean spinOn) {
        if (spinOn) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread();
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
        this.spinOn = spinOn;
    }

    public void clearVibration() {
        this.setVibrationOn(false);
    }

    private void setVibrationOn(boolean vibrationOn) {
        if (!vibrationOn || !this.viewer.haveFrame()) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
        }

        public void run() {
            long startTime;
            long lastRepaintTime = startTime = System.currentTimeMillis();
            try {
                do {
                    long currentTime;
                    int elapsed;
                    int sleepTime;
                    if ((sleepTime = 33 - (elapsed = (int)((currentTime = System.currentTimeMillis()) - lastRepaintTime))) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    lastRepaintTime = currentTime = System.currentTimeMillis();
                    elapsed = (int)(currentTime - startTime);
                    float t = (float)(elapsed % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(t);
                    TransformManager.this.viewer.refresh();
                } while (!this.isInterrupted());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    class SpinThread
    extends Thread
    implements Runnable {
        SpinThread() {
        }

        public void run() {
            int myFps = TransformManager.this.spinFps;
            int i = 0;
            long timeBegin = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int currentTime;
                int targetTime;
                int sleepTime;
                if (myFps != TransformManager.this.spinFps) {
                    myFps = TransformManager.this.spinFps;
                    i = 0;
                    timeBegin = System.currentTimeMillis();
                }
                boolean refreshNeeded = false;
                if (TransformManager.this.spinX != 0) {
                    TransformManager.this.rotateXRadians((float)TransformManager.this.spinX * ((float)Math.PI / 180) / (float)myFps);
                    refreshNeeded = true;
                }
                if (TransformManager.this.spinY != 0) {
                    TransformManager.this.rotateYRadians((float)TransformManager.this.spinY * ((float)Math.PI / 180) / (float)myFps);
                    refreshNeeded = true;
                }
                if (TransformManager.this.spinZ != 0) {
                    TransformManager.this.rotateZRadians((float)TransformManager.this.spinZ * ((float)Math.PI / 180) / (float)myFps);
                    refreshNeeded = true;
                }
                if ((sleepTime = (targetTime = ++i * 1000 / myFps) - (currentTime = (int)(System.currentTimeMillis() - timeBegin))) <= 0) continue;
                if (refreshNeeded) {
                    TransformManager.this.viewer.refresh();
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

