/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerAttributeMap;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.runtime.IStringPoolParticipant;
import org.eclipse.core.runtime.StringPool;

public class MarkerInfo
implements IMarkerSetElement,
Cloneable,
IStringPoolParticipant {
    protected static final long UNDEFINED_ID = -1L;
    protected long id = -1L;
    protected String type = null;
    protected Map attributes = null;
    protected long creationTime = 0L;

    public Object getAttribute(String attributeName) {
        return this.attributes == null ? null : this.attributes.get(attributeName);
    }

    public Map getAttributes() {
        return this.getAttributes(true);
    }

    public Object clone() {
        try {
            MarkerInfo copy = (MarkerInfo)super.clone();
            copy.attributes = this.getAttributes(true);
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object[] getAttributes(String[] attributeNames) {
        Object[] result = new Object[attributeNames.length];
        int i = 0;
        while (i < attributeNames.length) {
            result[i] = this.getAttribute(attributeNames[i]);
            ++i;
        }
        return result;
    }

    public Map getAttributes(boolean makeCopy) {
        if (this.attributes == null) {
            return null;
        }
        return makeCopy ? new MarkerAttributeMap(this.attributes) : this.attributes;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void internalSetAttributes(Map map) {
        this.attributes = (MarkerAttributeMap)map;
    }

    protected static boolean isValidAttributeValue(Object value) {
        return value == null || value instanceof String || value instanceof Integer || value instanceof Boolean;
    }

    public void setAttribute(String attributeName, Object value) {
        Assert.isTrue(MarkerInfo.isValidAttributeValue(value));
        if (this.attributes == null) {
            if (value == null) {
                return;
            }
            this.attributes = new MarkerAttributeMap();
            this.attributes.put(attributeName, value);
        } else if (value == null) {
            this.attributes.remove(attributeName);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(attributeName, value);
        }
    }

    public void setAttributes(String[] attributeNames, Object[] values) {
        Assert.isTrue(attributeNames.length == values.length);
        int i = 0;
        while (i < attributeNames.length) {
            this.setAttribute(attributeNames[i], values[i]);
            ++i;
        }
    }

    public void setAttributes(Map map) {
        this.attributes = map == null ? null : new MarkerAttributeMap(map);
    }

    public void setCreationTime(long value) {
        this.creationTime = value;
    }

    public void setId(long value) {
        this.id = value;
    }

    public void setType(String value) {
        this.type = value;
    }

    public void shareStrings(StringPool set) {
        this.type = set.add(this.type);
        Map map = this.attributes;
        if (map instanceof IStringPoolParticipant) {
            ((IStringPoolParticipant)map).shareStrings(set);
        }
    }
}

