/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferences
extends EclipsePreferences {
    protected boolean isLoading = false;
    private int segmentCount;
    private String qualifier;
    private IProject project;
    private IEclipsePreferences loadLevel;
    private IFile file;
    protected static Set loadedNodes = new HashSet();
    private boolean isWriting;

    public ProjectPreferences() {
        super(null, null);
    }

    private ProjectPreferences(EclipsePreferences parent, String name) {
        super(parent, name);
        String path = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount((String)path);
        if (this.segmentCount < 2) {
            return;
        }
        String projectName = EclipsePreferences.getSegment((String)path, (int)1);
        if (projectName != null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (this.segmentCount > 2) {
            this.qualifier = EclipsePreferences.getSegment((String)path, (int)2);
        }
    }

    protected IPath getLocation() {
        if (this.project == null || this.qualifier == null) {
            return null;
        }
        IPath path = this.project.getLocation();
        return this.computeLocation(path, this.qualifier);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected void loaded() {
        loadedNodes.add(this.absolutePath());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            ProjectPreferences node = this;
            int i = 3;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new ProjectPreferences(nodeParent, nodeName);
    }

    private IFile getFile() {
        if (this.file == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            this.file = ProjectPreferences.getFile(this.project, this.qualifier);
        }
        return this.file;
    }

    static IFile getFile(IProject project, String qualifier) {
        return project.getFile(new Path(".settings").append(qualifier).addFileExtension("prefs"));
    }

    static IFile getFile(IFolder folder, String qualifier) {
        Assert.isLegal(folder.getName().equals(".settings"));
        return folder.getFile(new Path(qualifier).addFileExtension("prefs"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void save() throws BackingStoreException {
        IFile fileInWorkspace = this.getFile();
        if (fileInWorkspace == null) {
            if (!Policy.DEBUG_PREFERENCES) return;
            Policy.debug("Not saving preferences since there is no file for node: " + this.absolutePath());
            return;
        }
        Properties table = this.convertToProperties(new Properties(), "");
        try {
            if (table.isEmpty()) {
                IStatus status;
                if (!fileInWorkspace.exists()) return;
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Deleting preference file: " + fileInWorkspace.getFullPath());
                }
                if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                    throw new CoreException(status);
                }
                try {
                    fileInWorkspace.delete(true, null);
                    return;
                }
                catch (CoreException coreException) {
                    String message = Policy.bind("preferences.deleteException", fileInWorkspace.getFullPath().toString());
                    this.log((IStatus)new Status(2, "org.eclipse.core.resources", 2, message, null));
                }
                return;
            }
            table.put("eclipse.preferences.version", "1");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                try {
                    table.store(output, null);
                }
                catch (IOException e) {
                    String message = Policy.bind("preferences.saveProblems", this.absolutePath());
                    this.log((IStatus)new Status(4, "org.eclipse.core.runtime", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
            }
            catch (Throwable throwable) {
                Object var6_13 = null;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_14 = null;
            }
            try {}
            catch (IOException iOException) {}
            output.close();
            BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(output.toByteArray()));
            if (fileInWorkspace.exists()) {
                IStatus status;
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Setting preference file contents for: " + fileInWorkspace.getFullPath());
                }
                if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                    throw new CoreException(status);
                }
                fileInWorkspace.setContents(input, 2, null);
                return;
            }
            IFolder folder = (IFolder)fileInWorkspace.getParent();
            if (!folder.exists()) {
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Creating parent preference directory: " + folder.getFullPath());
                }
                folder.create(0, true, null);
            }
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Creating preference file: " + fileInWorkspace.getLocation());
            }
            fileInWorkspace.create((InputStream)input, 0, null);
            return;
        }
        catch (CoreException e) {
            String message = Policy.bind("preferences.saveProblems", fileInWorkspace.getFullPath().toString());
            this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws BackingStoreException {
        Properties fromDisk;
        block11: {
            IFile localFile = this.getFile();
            if (localFile == null || !localFile.exists()) {
                if (!Policy.DEBUG_PREFERENCES) return;
                Policy.debug("Unable to determine preference file or file does not exist for node: " + this.absolutePath());
                return;
            }
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from file: " + localFile.getFullPath());
            }
            fromDisk = new Properties();
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(localFile.getContents(true));
                    fromDisk.load(input);
                }
                catch (CoreException e) {
                    String message = Policy.bind("preferences.loadException", localFile.getFullPath().toString());
                    this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
                catch (IOException e) {
                    String message = Policy.bind("preferences.loadException", localFile.getFullPath().toString());
                    this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (input == null) throw throwable;
                try {
                    ((InputStream)input).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_10 = null;
                if (input == null) break block11;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)input).close();
        }
        this.convertFromProperties(fromDisk, true);
    }

    public static void updatePreferences(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        if (!"prefs".equals(path.getFileExtension())) {
            return;
        }
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences node = root.node("project").node(project).node(qualifier);
        String message = null;
        try {
            message = Policy.bind("preferences.syncException", node.absolutePath());
            if (!(node instanceof ProjectPreferences)) {
                return;
            }
            ProjectPreferences projectPrefs = (ProjectPreferences)node;
            if (projectPrefs.isWriting) {
                return;
            }
            projectPrefs.load();
            if ("org.eclipse.core.resources".equals(qualifier)) {
                ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(file.getProject());
            }
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    static void removeNode(Preferences node) throws CoreException {
        String message = Policy.bind("preferences.removeNodeException", node.absolutePath());
        try {
            node.removeNode();
        }
        catch (BackingStoreException e) {
            Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        String path = node.absolutePath();
        Iterator i = loadedNodes.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(path)) continue;
            i.remove();
        }
    }

    static void deleted(IProject project) throws CoreException {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        Preferences projectNode = root.node("project").node(project.getName());
        boolean hasResourcesSettings = ProjectPreferences.getFile(project, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(project);
        }
    }

    static void deleted(IFile file) throws CoreException {
        IPath path = file.getFullPath();
        int count = path.segmentCount();
        if (count != 3) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        String qualifier = path.removeFileExtension().lastSegment();
        Preferences projectNode = root.node("project").node(project);
        try {
            if (!projectNode.nodeExists(qualifier)) {
                return;
            }
        }
        catch (BackingStoreException backingStoreException) {}
        ProjectPreferences.removeNode(projectNode.node(qualifier));
        if (qualifier.equals("org.eclipse.core.resources")) {
            ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(file.getProject());
        }
    }

    static void deleted(IResource resource) throws CoreException {
        switch (resource.getType()) {
            case 1: {
                ProjectPreferences.deleted((IFile)resource);
                return;
            }
            case 2: {
                ProjectPreferences.deleted((IFolder)resource);
                return;
            }
            case 4: {
                ProjectPreferences.deleted((IProject)resource);
                return;
            }
        }
    }

    static void deleted(IFolder folder) throws CoreException {
        IPath path = folder.getFullPath();
        int count = path.segmentCount();
        if (count != 2) {
            return;
        }
        if (!".settings".equals(path.segment(1))) {
            return;
        }
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String project = path.segment(0);
        Preferences projectNode = root.node("project").node(project);
        boolean hasResourcesSettings = ProjectPreferences.getFile(folder, "org.eclipse.core.resources").exists();
        ProjectPreferences.removeNode(projectNode);
        if (hasResourcesSettings) {
            ((Workspace)ResourcesPlugin.getWorkspace()).getCharsetManager().charsetPreferencesChanged(folder.getProject());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws BackingStoreException {
        this.isWriting = true;
        try {
            super.flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.isWriting = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.isWriting = false;
            return;
        }
    }
}

