/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.manipulation;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.Messages;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.filebuffers.manipulation.TextFileBufferOperation;
import org.eclipse.core.internal.filebuffers.Progress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.TextEdit;

public class RemoveTrailingWhitespaceOperation
extends TextFileBufferOperation {
    public RemoveTrailingWhitespaceOperation() {
        super(Messages.getString("RemoveTrailingWhitespaceOperation.name"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MultiTextEditWithProgress computeTextEdit(ITextFileBuffer fileBuffer, IProgressMonitor progressMonitor) throws CoreException {
        MultiTextEditWithProgress multiTextEditWithProgress;
        IDocument document = fileBuffer.getDocument();
        int lineCount = document.getNumberOfLines();
        progressMonitor = Progress.getMonitor(progressMonitor);
        progressMonitor.beginTask(Messages.getString("RemoveTrailingWhitespaceOperation.task.generatingChanges"), lineCount);
        try {
            try {
                MultiTextEditWithProgress multiEdit = new MultiTextEditWithProgress(Messages.getString("RemoveTrailingWhitespaceOperation.task.applyingChanges"));
                int i = 0;
                while (true) {
                    block11: {
                        if (i < lineCount) break block11;
                    }
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IRegion region = document.getLineInformation(i);
                    if (region.getLength() != 0) {
                        int lineStart = region.getOffset();
                        int lineExclusiveEnd = lineStart + region.getLength();
                        int j = lineExclusiveEnd - 1;
                        while (true) {
                            if (j < lineStart || !Character.isWhitespace(document.getChar(j))) {
                                if (++j < lineExclusiveEnd) {
                                    multiEdit.addChild((TextEdit)new DeleteEdit(j, lineExclusiveEnd - j));
                                }
                                progressMonitor.worked(1);
                                break;
                            }
                            --j;
                        }
                    }
                    ++i;
                }
                multiTextEditWithProgress = multiEdit.getChildrenSize() <= 0 ? null : multiEdit;
                Object var11_13 = null;
            }
            catch (BadLocationException x) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 1, "", (Throwable)x));
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return multiTextEditWithProgress;
    }

    protected DocumentRewriteSessionType getDocumentRewriteSessionType() {
        return DocumentRewriteSessionType.SEQUENTIAL;
    }
}

