/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ResizableDialog;
import org.eclipse.compare.internal.StructureCreatorDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class EditionSelectionDialog
extends ResizableDialog {
    private CompareConfiguration fCompareConfiguration;
    private ArrayList fArrayList = new ArrayList();
    private boolean fCompare = true;
    private boolean fTargetIsRight = false;
    private boolean fHideIdentical = true;
    private boolean fAddMode = false;
    private boolean fCompareMode = false;
    private boolean fStructureCompare = false;
    private boolean fMultiSelect = false;
    private HashMap fMemberEditions;
    private HashMap fMemberSelection;
    private List fCurrentEditions;
    private Thread fThread;
    private Pair fTargetPair;
    private ITypedElement fSelectedItem;
    private String fTitleArg;
    private Image fTitleImage;
    private CompareViewerSwitchingPane fContentPane;
    private Button fCommitButton;
    private Table fMemberTable;
    private CompareViewerPane fMemberPane;
    private Tree fEditionTree;
    private CompareViewerPane fEditionPane;
    private Image fDateImage;
    private Image fTimeImage;
    private CompareViewerSwitchingPane fStructuredComparePane;

    public EditionSelectionDialog(Shell parent, ResourceBundle bundle) {
        super(parent, bundle);
    }

    private CompareConfiguration getCompareConfiguration() {
        if (this.fCompareConfiguration == null) {
            this.fCompareConfiguration = new CompareConfiguration();
            this.fCompareConfiguration.setLeftEditable(false);
            this.fCompareConfiguration.setRightEditable(false);
        }
        return this.fCompareConfiguration;
    }

    public void setEditionTitleArgument(String titleArgument) {
        this.fTitleArg = titleArgument;
    }

    public void setEditionTitleImage(Image titleImage) {
        this.fTitleImage = titleImage;
    }

    public ITypedElement selectPreviousEdition(ITypedElement target, ITypedElement[] inputEditions, Object ppath) {
        Assert.isNotNull((Object)target);
        this.fTargetPair = new Pair(null, target);
        int count = inputEditions.length;
        IModificationDate[] editions = new IModificationDate[count];
        int i = 0;
        while (i < count) {
            editions[i] = (IModificationDate)((Object)inputEditions[i]);
            ++i;
        }
        if (count > 1) {
            EditionSelectionDialog.internalSort(editions);
        }
        IStructureCreator structureCreator = null;
        if (ppath != null) {
            String type = target.getType();
            StructureCreatorDescriptor scd = CompareUIPlugin.getDefault().getStructureCreator(type);
            if (scd != null) {
                structureCreator = scd.createStructureCreator();
            }
        }
        if (this.fAddMode) {
            return null;
        }
        if (structureCreator != null) {
            Pair pair = this.createPair(structureCreator, ppath, target);
            if (pair != null) {
                this.fTargetPair = pair;
            } else {
                ppath = null;
            }
        }
        int i2 = 0;
        while (i2 < count) {
            ITypedElement edition = (ITypedElement)((Object)editions[i2]);
            Pair pair = null;
            pair = structureCreator != null && ppath != null ? this.createPair(structureCreator, ppath, edition) : new Pair(null, edition);
            if (pair != null && pair.fHasError) {
                return null;
            }
            if (pair != null && !this.fTargetPair.equals(pair)) {
                return pair.fItem;
            }
            ++i2;
        }
        return null;
    }

    public ITypedElement selectEdition(ITypedElement target, ITypedElement[] inputEditions, Object ppath) {
        Assert.isNotNull((Object)target);
        this.fTargetPair = new Pair(null, target);
        final int count = inputEditions.length;
        final IModificationDate[] editions = new IModificationDate[count];
        int i = 0;
        while (i < count) {
            editions[i] = (IModificationDate)((Object)inputEditions[i]);
            ++i;
        }
        if (count > 1) {
            EditionSelectionDialog.internalSort(editions);
        }
        IStructureCreator structureCreator = null;
        if (ppath != null) {
            String type = target.getType();
            StructureCreatorDescriptor scd = CompareUIPlugin.getDefault().getStructureCreator(type);
            if (scd != null) {
                structureCreator = scd.createStructureCreator();
            }
        }
        if (!this.fAddMode) {
            if (structureCreator != null) {
                Pair pair = this.createPair(structureCreator, ppath, target);
                if (pair != null) {
                    this.fTargetPair = pair;
                } else {
                    ppath = null;
                }
            }
            String targetLabel = this.getTargetLabel(target, this.fTargetPair.getItem());
            if (this.fTargetIsRight) {
                this.getCompareConfiguration().setRightLabel(targetLabel);
            } else {
                this.getCompareConfiguration().setLeftLabel(targetLabel);
            }
            if (structureCreator != null && ppath != null) {
                final IStructureCreator sc = structureCreator;
                final Object path = ppath;
                this.fThread = new Thread(){

                    public void run() {
                        int i = 0;
                        while (i < count) {
                            if (EditionSelectionDialog.this.fEditionTree == null || EditionSelectionDialog.this.fEditionTree.isDisposed()) break;
                            ITypedElement edition = (ITypedElement)((Object)editions[i]);
                            Pair pair = EditionSelectionDialog.this.createPair(sc, path, edition);
                            if (pair != null) {
                                EditionSelectionDialog.this.sendPair(pair);
                            }
                            ++i;
                        }
                        EditionSelectionDialog.this.sendPair(null);
                    }
                };
            } else {
                this.create();
                int i2 = 0;
                while (i2 < count) {
                    this.addMemberEdition(new Pair(null, (ITypedElement)((Object)editions[i2])));
                    ++i2;
                }
            }
        } else {
            Object[] children;
            final Object container = ppath;
            Assert.isNotNull((Object)container);
            if (structureCreator == null) {
                return null;
            }
            final HashSet<Object> current = new HashSet<Object>();
            IStructureComparator sco = structureCreator.locate(container, target);
            if (sco != null && (children = sco.getChildren()) != null) {
                int i3 = 0;
                while (i3 < children.length) {
                    current.add(children[i3]);
                    ++i3;
                }
            }
            final IStructureCreator sc = structureCreator;
            this.fThread = new Thread(){

                public void run() {
                    int i = 0;
                    while (i < count) {
                        Object[] children;
                        if (EditionSelectionDialog.this.fEditionTree == null || EditionSelectionDialog.this.fEditionTree.isDisposed()) break;
                        ITypedElement edition = (ITypedElement)((Object)editions[i]);
                        IStructureComparator sco2 = sc.locate(container, edition);
                        if (sco2 != null && (children = sco2.getChildren()) != null) {
                            int i2 = 0;
                            while (i2 < children.length) {
                                ITypedElement child = (ITypedElement)children[i2];
                                if (!current.contains(child)) {
                                    EditionSelectionDialog.this.sendPair(new Pair(sc, edition, child));
                                }
                                ++i2;
                            }
                        }
                        ++i;
                    }
                    EditionSelectionDialog.this.sendPair(null);
                }
            };
        }
        this.open();
        if (this.getReturnCode() == 0) {
            return this.fSelectedItem;
        }
        return null;
    }

    private Pair createPair(IStructureCreator sc, Object path, ITypedElement input) {
        IStructureComparator scmp = sc.locate(path, input);
        if (scmp == null && sc.getStructure(input) == null) {
            Pair p = new Pair(sc, input);
            p.fHasError = true;
            return p;
        }
        if (scmp instanceof ITypedElement) {
            return new Pair(sc, input, (ITypedElement)((Object)scmp));
        }
        return null;
    }

    public void setHideIdenticalEntries(boolean hide) {
        this.fHideIdentical = hide;
    }

    public void setTargetIsRight(boolean isRight) {
        this.fTargetIsRight = isRight;
    }

    public void setAddMode(boolean addMode) {
        this.fAddMode = addMode;
        this.fMultiSelect = addMode;
    }

    public void setCompareMode(boolean compareMode) {
        this.fCompareMode = compareMode;
        this.fStructureCompare = this.fCompareMode && !this.fAddMode;
    }

    public ITypedElement getTarget() {
        return this.fTargetPair.getItem();
    }

    public ITypedElement[] getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fMemberSelection != null) {
            Iterator iter = this.fArrayList.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object edition = iter.next();
                Object item = this.fMemberSelection.get(edition);
                if (item != null) {
                    result.add(item);
                }
                ++i;
            }
        } else if (this.fSelectedItem != null) {
            result.add(this.fSelectedItem);
        }
        return result.toArray(new ITypedElement[result.size()]);
    }

    protected String getTargetLabel(ITypedElement target, ITypedElement item) {
        String format = null;
        if (target instanceof ResourceNode) {
            format = Utilities.getString(this.fBundle, "workspaceTargetLabel", null);
        }
        if (format == null) {
            format = Utilities.getString(this.fBundle, "targetLabel");
        }
        if (format == null) {
            format = "x{0}";
        }
        return MessageFormat.format(format, target.getName());
    }

    protected String getEditionLabel(ITypedElement selectedEdition, ITypedElement item) {
        String format = null;
        if (selectedEdition instanceof ResourceNode) {
            format = Utilities.getString(this.fBundle, "workspaceEditionLabel", null);
        } else if (selectedEdition instanceof HistoryItem) {
            format = Utilities.getString(this.fBundle, "historyEditionLabel", null);
        }
        if (format == null) {
            format = Utilities.getString(this.fBundle, "editionLabel");
        }
        if (format == null) {
            format = "x{0}";
        }
        String date = "";
        if (selectedEdition instanceof IModificationDate) {
            long modDate = ((IModificationDate)((Object)selectedEdition)).getModificationDate();
            date = DateFormat.getDateTimeInstance().format(new Date(modDate));
        }
        return MessageFormat.format(format, date);
    }

    protected String getShortEditionLabel(ITypedElement edition, ITypedElement item, Date date) {
        String format = null;
        if (edition instanceof ResourceNode) {
            format = Utilities.getString(this.fBundle, "workspaceTreeFormat", null);
        }
        if (format == null) {
            format = Utilities.getString(this.fBundle, "treeFormat", null);
        }
        if (format == null) {
            format = "x{0}";
        }
        String ds = DateFormat.getTimeInstance().format(date);
        return MessageFormat.format(format, ds);
    }

    protected Image getEditionImage(ITypedElement selectedEdition, ITypedElement item) {
        if (selectedEdition instanceof ResourceNode) {
            return selectedEdition.getImage();
        }
        if (selectedEdition instanceof HistoryItem) {
            String iconName;
            ImageDescriptor id;
            if (this.fTimeImage == null && (id = CompareUIPlugin.getImageDescriptor(iconName = Utilities.getString(this.fBundle, "timeIcon", "obj16/resource_obj.gif"))) != null) {
                this.fTimeImage = id.createImage();
            }
            return this.fTimeImage;
        }
        return null;
    }

    protected synchronized Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.getShell().setText(Utilities.getString(this.fBundle, "title"));
        Splitter vsplitter = new Splitter(parent, 512);
        vsplitter.setLayoutData(new GridData(1808));
        vsplitter.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EditionSelectionDialog.this.fCompareConfiguration != null) {
                    EditionSelectionDialog.this.fCompareConfiguration.dispose();
                    EditionSelectionDialog.this.fCompareConfiguration = null;
                }
                if (EditionSelectionDialog.this.fDateImage != null) {
                    EditionSelectionDialog.this.fDateImage.dispose();
                    EditionSelectionDialog.this.fDateImage = null;
                }
                if (EditionSelectionDialog.this.fTimeImage != null) {
                    EditionSelectionDialog.this.fTimeImage.dispose();
                    EditionSelectionDialog.this.fTimeImage = null;
                }
            }
        });
        if (this.fAddMode) {
            Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
            this.fMemberPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
            this.fMemberPane.setText(Utilities.getString(this.fBundle, "memberPaneTitle"));
            int flags = 768;
            if (this.fMultiSelect) {
                flags |= 0x20;
            }
            this.fMemberTable = new Table((Composite)this.fMemberPane, flags);
            this.fMemberTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32 && e.item instanceof TableItem) {
                        TableItem ti = (TableItem)e.item;
                        Object data = ti.getData();
                        if (ti.getChecked()) {
                            EditionSelectionDialog.this.fArrayList.add(data);
                        } else {
                            EditionSelectionDialog.this.fArrayList.remove(data);
                        }
                        if (EditionSelectionDialog.this.fCommitButton != null) {
                            EditionSelectionDialog.this.fCommitButton.setEnabled(EditionSelectionDialog.this.fArrayList.size() > 0);
                        }
                        EditionSelectionDialog.this.fMemberTable.setSelection(new TableItem[]{ti});
                    }
                    EditionSelectionDialog.this.handleMemberSelect(e.item);
                }
            });
            this.fMemberPane.setContent((Control)this.fMemberTable);
            this.fMemberTable.setFocus();
            this.fEditionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
        } else {
            if (this.fStructureCompare) {
                Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
                this.fEditionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
                this.fStructuredComparePane = new CompareViewerSwitchingPane((Composite)hsplitter, 0x800800, true){

                    protected Viewer getViewer(Viewer oldViewer, Object input) {
                        if (input instanceof ICompareInput) {
                            return CompareUI.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this, EditionSelectionDialog.this.getCompareConfiguration());
                        }
                        return null;
                    }
                };
                this.fStructuredComparePane.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent e) {
                        EditionSelectionDialog.this.feedInput2(e.getSelection());
                    }
                });
            } else {
                this.fEditionPane = new CompareViewerPane((Composite)vsplitter, 0x800800);
            }
            if (this.fTitleArg == null) {
                this.fTitleArg = this.fTargetPair.getItem().getName();
            }
            String titleFormat = Utilities.getString(this.fBundle, "treeTitleFormat");
            String title = MessageFormat.format(titleFormat, this.fTitleArg);
            this.fEditionPane.setText(title);
            if (this.fTitleImage != null) {
                this.fEditionPane.setImage(this.fTitleImage);
            }
        }
        this.fEditionTree = new Tree((Composite)this.fEditionPane, 768);
        this.fEditionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditionSelectionDialog.this.feedInput(e.item);
            }
        });
        this.fEditionPane.setContent((Control)this.fEditionTree);
        if (this.fThread != null) {
            this.fThread.start();
            this.fThread = null;
        }
        this.fContentPane = new CompareViewerSwitchingPane((Composite)vsplitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer(oldViewer, input, (Composite)this, EditionSelectionDialog.this.getCompareConfiguration());
            }
        };
        vsplitter.setWeights(new int[]{30, 70});
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonLabel = Utilities.getString(this.fBundle, "buttonLabel", IDialogConstants.OK_LABEL);
        if (this.fCompareMode) {
            this.createButton(parent, 1, buttonLabel, false);
        } else {
            this.fCommitButton = this.createButton(parent, 0, buttonLabel, true);
            this.fCommitButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void okPressed() {
        if (!this.fCompareMode) {
            super.okPressed();
        }
    }

    private void sendPair(final Pair pair) {
        if (this.fEditionTree != null && !this.fEditionTree.isDisposed()) {
            Display display = this.fEditionTree.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    EditionSelectionDialog.this.addMemberEdition(pair);
                }
            });
        }
    }

    private static void internalSort(IModificationDate[] keys) {
        Arrays.sort(keys, new Comparator(){

            public int compare(Object o1, Object o2) {
                IModificationDate d1 = (IModificationDate)o1;
                IModificationDate d2 = (IModificationDate)o2;
                long d = d2.getModificationDate() - d1.getModificationDate();
                if (d < 0L) {
                    return -1;
                }
                if (d > 0L) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void addMemberEdition(Pair pair) {
        ITypedElement item;
        ArrayList<Pair> editions;
        if (pair == null) {
            if (this.fMemberTable != null) {
                if (!this.fMemberTable.isDisposed() && this.fMemberTable.getItemCount() == 0) {
                    if (this.fMultiSelect) {
                        this.fMemberTable.dispose();
                        this.fMemberTable = new Table((Composite)this.fMemberPane, 0);
                        this.fMemberPane.setContent((Control)this.fMemberTable);
                    }
                    TableItem ti = new TableItem(this.fMemberTable, 0);
                    ti.setText(Utilities.getString(this.fBundle, "noAdditionalMembersMessage"));
                }
                return;
            }
            if (this.fEditionTree != null && !this.fEditionTree.isDisposed() && this.fEditionTree.getItemCount() == 0) {
                TreeItem ti = new TreeItem(this.fEditionTree, 0);
                ti.setText(Utilities.getString(this.fBundle, "notFoundInLocalHistoryMessage"));
            }
            return;
        }
        if (this.fMemberEditions == null) {
            this.fMemberEditions = new HashMap();
        }
        if (this.fMultiSelect && this.fMemberSelection == null) {
            this.fMemberSelection = new HashMap();
        }
        if ((editions = (ArrayList<Pair>)this.fMemberEditions.get(item = pair.getItem())) == null) {
            editions = new ArrayList<Pair>();
            this.fMemberEditions.put(item, editions);
            if (this.fMemberTable != null && !this.fMemberTable.isDisposed()) {
                ITypedElement te = item;
                String name = te.getName();
                TableItem[] items = this.fMemberTable.getItems();
                int where = items.length;
                int i = 0;
                while (i < where) {
                    String n = items[i].getText();
                    if (n.compareTo(name) > 0) {
                        where = i;
                        break;
                    }
                    ++i;
                }
                TableItem ti = new TableItem(this.fMemberTable, where, 0);
                ti.setImage(te.getImage());
                ti.setText(name);
                ti.setData(editions);
            }
        }
        if (this.fHideIdentical) {
            Pair last = this.fTargetPair;
            int size = editions.size();
            if (size > 0) {
                last = (Pair)editions.get(size - 1);
            }
            if (last != null && last.equals(pair)) {
                return;
            }
        }
        editions.add(pair);
        if (!this.fAddMode || editions == this.fCurrentEditions) {
            this.addEdition(pair);
        }
    }

    private long dayNumber(long date) {
        int ONE_DAY_MS = 86400000;
        Calendar calendar = Calendar.getInstance();
        long localTimeOffset = calendar.get(15) + calendar.get(16);
        return (date + localTimeOffset) / (long)ONE_DAY_MS;
    }

    private void addEdition(Pair pair) {
        Object selected;
        Object selection;
        if (this.fEditionTree == null || this.fEditionTree.isDisposed()) {
            return;
        }
        TreeItem[] days = this.fEditionTree.getItems();
        TreeItem lastDay = null;
        if (days.length > 0) {
            lastDay = days[days.length - 1];
        }
        boolean first = lastDay == null;
        ITypedElement edition = pair.getEdition();
        ITypedElement item = pair.getItem();
        long ldate = ((IModificationDate)((Object)edition)).getModificationDate();
        long day = this.dayNumber(ldate);
        Date date = new Date(ldate);
        if (lastDay == null || day != this.dayNumber(((Date)lastDay.getData()).getTime())) {
            String iconName;
            ImageDescriptor id;
            lastDay = new TreeItem(this.fEditionTree, 0);
            if (this.fDateImage == null && (id = CompareUIPlugin.getImageDescriptor(iconName = Utilities.getString(this.fBundle, "dateIcon", "obj16/day_obj.gif"))) != null) {
                this.fDateImage = id.createImage();
            }
            lastDay.setImage(this.fDateImage);
            String df = DateFormat.getDateInstance().format(date);
            long today = this.dayNumber(System.currentTimeMillis());
            String formatKey = day == today ? "todayFormat" : (day == today - 1L ? "yesterdayFormat" : "dayFormat");
            String pattern = Utilities.getString(this.fBundle, formatKey);
            if (pattern != null) {
                df = MessageFormat.format(pattern, df);
            }
            lastDay.setText(df);
            lastDay.setData((Object)date);
        }
        TreeItem ti = new TreeItem(lastDay, 0);
        ti.setImage(this.getEditionImage(edition, item));
        String s = this.getShortEditionLabel(edition, item, date);
        if (pair.fHasError) {
            String pattern = Utilities.getString(this.fBundle, "parseErrorFormat");
            s = MessageFormat.format(pattern, s);
        }
        ti.setText(s);
        ti.setData((Object)pair);
        Object object = selection = first ? ti : null;
        if (this.fMemberSelection != null && (selected = this.fMemberSelection.get(this.fCurrentEditions)) != null) {
            selection = selected == pair.getItem() ? ti : null;
        }
        if (selection != null) {
            this.fEditionTree.setSelection(new TreeItem[]{selection});
            if (!this.fAddMode) {
                this.fEditionTree.setFocus();
            }
            this.feedInput((Widget)selection);
        }
        if (first) {
            lastDay.setExpanded(true);
        }
    }

    private void handleMemberSelect(Widget w) {
        List editions;
        Object data = w.getData();
        if (data instanceof List && (editions = (List)data) != this.fCurrentEditions) {
            this.fCurrentEditions = editions;
            this.fEditionTree.removeAll();
            String pattern = Utilities.getString(this.fBundle, "treeTitleFormat");
            String title = MessageFormat.format(pattern, ((Item)w).getText());
            this.fEditionPane.setText(title);
            Iterator iter = editions.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!(item instanceof Pair)) continue;
                this.addEdition((Pair)item);
            }
        }
    }

    private void setInput(Object input) {
        if (!this.fCompare && input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            input = this.fTargetIsRight ? ci.getLeft() : ci.getRight();
        }
        this.fContentPane.setInput(input);
        if (this.fStructuredComparePane != null) {
            this.fStructuredComparePane.setInput(input);
        }
    }

    private void feedInput(Widget w) {
        Object input = w.getData();
        boolean isOK = false;
        if (input instanceof Pair) {
            Pair pair = (Pair)input;
            this.fSelectedItem = pair.getItem();
            isOK = !pair.fHasError;
            ITypedElement edition = pair.getEdition();
            String editionLabel = this.getEditionLabel(edition, this.fSelectedItem);
            Image editionImage = this.getEditionImage(edition, this.fSelectedItem);
            if (this.fAddMode) {
                if (this.fMemberSelection != null) {
                    this.fMemberSelection.put(this.fCurrentEditions, this.fSelectedItem);
                }
                this.setInput(this.fSelectedItem);
                this.fContentPane.setText(editionLabel);
                this.fContentPane.setImage(editionImage);
            } else {
                this.getCompareConfiguration();
                if (this.fTargetIsRight) {
                    this.fCompareConfiguration.setLeftLabel(editionLabel);
                    this.fCompareConfiguration.setLeftImage(editionImage);
                    this.setInput(new DiffNode(this.fSelectedItem, this.fTargetPair.getItem()));
                } else {
                    this.fCompareConfiguration.setRightLabel(editionLabel);
                    this.fCompareConfiguration.setRightImage(editionImage);
                    this.setInput(new DiffNode(this.fTargetPair.getItem(), this.fSelectedItem));
                }
            }
        } else {
            this.fSelectedItem = null;
            this.setInput(null);
        }
        if (this.fCommitButton != null) {
            if (this.fMultiSelect) {
                this.fCommitButton.setEnabled(isOK && this.fSelectedItem != null && this.fArrayList.size() > 0);
            } else {
                this.fCommitButton.setEnabled(isOK && this.fSelectedItem != null && this.fTargetPair.getItem() != this.fSelectedItem);
            }
        }
    }

    private void feedInput2(ISelection sel) {
        IStructuredSelection ss;
        if (sel instanceof IStructuredSelection && (ss = (IStructuredSelection)sel).size() == 1) {
            this.fContentPane.setInput(ss.getFirstElement());
        }
    }

    private static class Pair {
        private ITypedElement fEdition;
        private ITypedElement fItem;
        private String fContent;
        private IStructureCreator fStructureCreator;
        private boolean fHasError = false;

        Pair(IStructureCreator structureCreator, ITypedElement edition, ITypedElement item) {
            this.fStructureCreator = structureCreator;
            this.fEdition = edition;
            this.fItem = item;
        }

        Pair(IStructureCreator structureCreator, ITypedElement edition) {
            this(structureCreator, edition, edition);
        }

        ITypedElement getEdition() {
            return this.fEdition;
        }

        ITypedElement getItem() {
            return this.fItem;
        }

        private String getContent() {
            if (this.fContent == null) {
                if (this.fStructureCreator != null) {
                    this.fContent = this.fStructureCreator.getContents(this.fItem, false);
                } else if (this.fItem instanceof IStreamContentAccessor) {
                    IStreamContentAccessor sca = (IStreamContentAccessor)((Object)this.fItem);
                    try {
                        this.fContent = Utilities.readString(sca);
                    }
                    catch (CoreException coreException) {}
                }
                if (this.fContent == null) {
                    this.fContent = "";
                }
            }
            return this.fContent;
        }

        public boolean equals(Object other) {
            if (other != null && other.getClass() == this.getClass() && this.getContent().equals(((Pair)other).getContent())) {
                return true;
            }
            return super.equals(other);
        }
    }
}

