/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class ViewerDescriptor
implements IViewerDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    private IConfigurationElement fConfiguration;
    private IViewerCreator fViewerCreator;
    private Class fViewerClass;

    public ViewerDescriptor(IConfigurationElement config) {
        this.fConfiguration = config;
    }

    public Viewer createViewer(Viewer currentViewer, Composite parent, CompareConfiguration mp) {
        if (currentViewer != null && currentViewer.getClass() == this.fViewerClass) {
            return currentViewer;
        }
        if (this.fViewerCreator == null) {
            try {
                this.fViewerCreator = (IViewerCreator)this.fConfiguration.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {}
        }
        if (this.fViewerCreator != null) {
            Viewer viewer = this.fViewerCreator.createViewer(parent, mp);
            if (viewer != null) {
                this.fViewerClass = viewer.getClass();
            }
            return viewer;
        }
        return null;
    }

    public String getExtension() {
        return this.fConfiguration.getAttribute(EXTENSIONS_ATTRIBUTE);
    }
}

