/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.FacetNotExistException;
import Ice.LocalException;
import Ice.MarshalException;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import IceInternal.BasicStream;
import IceInternal.Connection;
import IceInternal.DispatchStatus;
import IceInternal.IncomingBase;
import IceInternal.Instance;
import IceInternal.ServantManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

public final class Incoming
extends IncomingBase {
    Incoming next;
    private BasicStream _is;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Incoming(Instance instance, Connection connection, ObjectAdapter adapter, boolean response, byte compress) {
        super(instance, connection, adapter, response, compress);
        this._is = new BasicStream(instance);
    }

    public void __destroy() {
        if (this._is != null) {
            this._is.destroy();
            this._is = null;
        }
        super.__destroy();
    }

    public void reset(Instance instance, Connection connection, ObjectAdapter adapter, boolean response, byte compress) {
        if (this._is == null) {
            this._is = new BasicStream(instance);
        } else {
            this._is.reset();
        }
        super.reset(instance, connection, adapter, response, compress);
    }

    public void invoke(ServantManager servantManager) {
        DispatchStatus status;
        this._current.id.__read(this._is);
        String[] facetPath = this._is.readStringSeq();
        if (facetPath.length > 0) {
            if (facetPath.length > 1) {
                throw new MarshalException();
            }
            this._current.facet = facetPath[0];
        } else {
            this._current.facet = "";
        }
        this._current.operation = this._is.readString();
        this._current.mode = OperationMode.convert(this._is.readByte());
        int sz = this._is.readSize();
        while (sz-- > 0) {
            String first = this._is.readString();
            String second = this._is.readString();
            if (this._current.ctx == null) {
                this._current.ctx = new HashMap();
            }
            this._current.ctx.put(first, second);
        }
        this._is.startReadEncaps();
        if (this._response) {
            if (!$assertionsDisabled && this._os.size() != 18) {
                throw new AssertionError();
            }
            this._os.writeByte((byte)0);
            this._os.startWriteEncaps();
        }
        try {
            if (servantManager != null) {
                this._servant = servantManager.findServant(this._current.id, this._current.facet);
                if (this._servant == null && this._current.id.category.length() > 0) {
                    this._locator = servantManager.findServantLocator(this._current.id.category);
                    if (this._locator != null) {
                        this._servant = this._locator.locate(this._current, this._cookie);
                    }
                }
                if (this._servant == null) {
                    this._locator = servantManager.findServantLocator("");
                    if (this._locator != null) {
                        this._servant = this._locator.locate(this._current, this._cookie);
                    }
                }
            }
            status = this._servant == null ? (servantManager != null && servantManager.hasServant(this._current.id) ? DispatchStatus.DispatchFacetNotExist : DispatchStatus.DispatchObjectNotExist) : this._servant.__dispatch(this, this._current);
        }
        catch (RequestFailedException ex) {
            this._is.endReadEncaps();
            if (ex.id == null) {
                ex.id = this._current.id;
            }
            if (ex.facet == null) {
                ex.facet = this._current.facet;
            }
            if (ex.operation == null || ex.operation.length() == 0) {
                ex.operation = this._current.operation;
            }
            if (this._os.instance().properties().getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                if (ex instanceof ObjectNotExistException) {
                    this._os.writeByte((byte)2);
                } else if (ex instanceof FacetNotExistException) {
                    this._os.writeByte((byte)3);
                } else if (ex instanceof OperationNotExistException) {
                    this._os.writeByte((byte)4);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                ex.id.__write(this._os);
                if (ex.facet == null || ex.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    String[] facetPath2 = new String[]{ex.facet};
                    this._os.writeStringSeq(facetPath2);
                }
                this._os.writeString(ex.operation);
            }
            this.__finishInvoke();
            return;
        }
        catch (LocalException ex) {
            this._is.endReadEncaps();
            if (this._os.instance().properties().getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
            }
            this.__finishInvoke();
            return;
        }
        catch (Exception ex) {
            this._is.endReadEncaps();
            if (this._os.instance().properties().getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(ex);
            }
            if (this._response) {
                this._os.endWriteEncaps();
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                this._os.writeString(sw.toString());
            }
            this.__finishInvoke();
            return;
        }
        this._is.endReadEncaps();
        if (status == DispatchStatus.DispatchAsync) {
            return;
        }
        if (this._response) {
            this._os.endWriteEncaps();
            if (status != DispatchStatus.DispatchOK && status != DispatchStatus.DispatchUserException) {
                if (!$assertionsDisabled && status != DispatchStatus.DispatchObjectNotExist && status != DispatchStatus.DispatchFacetNotExist && status != DispatchStatus.DispatchOperationNotExist) {
                    throw new AssertionError();
                }
                this._os.resize(18, false);
                this._os.writeByte((byte)status.value());
                this._current.id.__write(this._os);
                if (this._current.facet == null || this._current.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    String[] facetPath2 = new String[]{this._current.facet};
                    this._os.writeStringSeq(facetPath2);
                }
                this._os.writeString(this._current.operation);
            } else {
                int save = this._os.pos();
                this._os.pos(18);
                this._os.writeByte((byte)status.value());
                this._os.pos(save);
            }
        }
        this.__finishInvoke();
    }

    public BasicStream is() {
        return this._is;
    }

    public BasicStream os() {
        return this._os;
    }

    static {
        $assertionsDisabled = !Incoming.class.desiredAssertionStatus();
    }
}

