/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterI;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connection;
import IceInternal.DefaultsAndOverrides;
import IceInternal.Endpoint;
import IceInternal.EndpointHolder;
import IceInternal.EventHandler;
import IceInternal.Instance;
import IceInternal.ThreadPool;
import IceInternal.Transceiver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.ListIterator;

public class IncomingConnectionFactory
extends EventHandler {
    private static final int StateActive = 0;
    private static final int StateHolding = 1;
    private static final int StateClosed = 2;
    private Acceptor _acceptor;
    private final Transceiver _transceiver;
    private Endpoint _endpoint;
    private final ObjectAdapter _adapter;
    private ThreadPool _serverThreadPool;
    private boolean _registeredWithPool;
    private final boolean _warn;
    private LinkedList _connections = new LinkedList();
    private int _state;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void hold() {
        this.setState(1);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHolding() {
        LinkedList connections;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state < 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            connections = (LinkedList)this._connections.clone();
        }
        ListIterator p = connections.listIterator();
        while (p.hasNext()) {
            Connection connection = (Connection)p.next();
            connection.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        LinkedList connections;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._acceptor != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            connections = this._connections;
            this._connections = new LinkedList();
        }
        ListIterator p = connections.listIterator();
        while (p.hasNext()) {
            Connection connection = (Connection)p.next();
            connection.waitUntilFinished();
        }
    }

    public Endpoint endpoint() {
        return this._endpoint;
    }

    public boolean equivalent(Endpoint endp) {
        if (this._transceiver != null) {
            return endp.equivalent(this._transceiver);
        }
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        return endp.equivalent(this._acceptor);
    }

    public synchronized Connection[] connections() {
        LinkedList<Connection> connections = new LinkedList<Connection>();
        ListIterator p = this._connections.listIterator();
        while (p.hasNext()) {
            Connection connection = (Connection)p.next();
            if (connection.isDestroyed()) continue;
            connections.add(connection);
        }
        Connection[] arr = new Connection[connections.size()];
        connections.toArray(arr);
        return arr;
    }

    public void flushBatchRequests() {
        Connection[] c = this.connections();
        for (int i = 0; i < c.length; ++i) {
            try {
                c[i].flushBatchRequest();
                continue;
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
    }

    public boolean datagram() {
        return this._endpoint.datagram();
    }

    public boolean readable() {
        return false;
    }

    public void read(BasicStream unused) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void message(BasicStream unused, ThreadPool threadPool) {
        Connection connection = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            Transceiver transceiver;
            if (this._state != 0) {
                Thread.yield();
                threadPool.promoteFollower();
                return;
            }
            ListIterator p = this._connections.listIterator();
            while (p.hasNext()) {
                Connection con = (Connection)p.next();
                if (!con.isFinished()) continue;
                p.remove();
            }
            try {
                transceiver = this._acceptor.accept(0);
            }
            catch (TimeoutException ex) {
                threadPool.promoteFollower();
                return;
            }
            catch (LocalException ex2) {
                block17: {
                    if (!this._warn) break block17;
                    this.warning(ex2);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                return;
            }
            finally {
                threadPool.promoteFollower();
            }
            if (!$assertionsDisabled && transceiver == null) {
                throw new AssertionError();
            }
            connection = new Connection(this._instance, transceiver, this._endpoint, this._adapter);
            this._connections.add(connection);
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        try {
            connection.validate();
        }
        catch (LocalException ex) {
            // empty catch block
        }
        connection.activate();
    }

    public synchronized void finished(ThreadPool threadPool) {
        threadPool.promoteFollower();
        if (this._state == 0) {
            this.registerWithPool();
        } else if (this._state == 2) {
            this._acceptor.close();
            this._acceptor = null;
            this.notifyAll();
        }
    }

    public void exception(LocalException ex) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public synchronized String toString() {
        if (this._transceiver != null) {
            return ((Object)this._transceiver).toString();
        }
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        return ((Object)this._acceptor).toString();
    }

    public IncomingConnectionFactory(Instance instance, Endpoint endpoint, ObjectAdapter adapter) {
        super(instance);
        this._endpoint = endpoint;
        this._adapter = adapter;
        this._registeredWithPool = false;
        this._warn = this._instance.properties().getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._state = 1;
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        if (defaultsAndOverrides.overrideTimeout) {
            this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
        }
        try {
            EndpointHolder h = new EndpointHolder();
            h.value = this._endpoint;
            this._transceiver = this._endpoint.serverTransceiver(h);
            if (this._transceiver != null) {
                this._endpoint = h.value;
                Connection connection = new Connection(this._instance, this._transceiver, this._endpoint, this._adapter);
                connection.validate();
                this._connections.add(connection);
            } else {
                h.value = this._endpoint;
                this._acceptor = this._endpoint.acceptor(h);
                this._endpoint = h.value;
                if (!$assertionsDisabled && this._acceptor == null) {
                    throw new AssertionError();
                }
                this._acceptor.listen();
            }
        }
        catch (RuntimeException ex) {
            this._state = 2;
            this._acceptor = null;
            throw ex;
        }
    }

    protected void finalize() throws Throwable {
        if (!$assertionsDisabled && this._state != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._acceptor != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._connections.size() != 0) {
            throw new AssertionError();
        }
        this._stream.destroy();
        super.finalize();
    }

    private void setState(int state) {
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                this.registerWithPool();
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    Connection connection = (Connection)p.next();
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                this.unregisterWithPool();
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    Connection connection = (Connection)p.next();
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._state == 1) {
                    this.registerWithPool();
                }
                this.unregisterWithPool();
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    Connection connection = (Connection)p.next();
                    connection.destroy(0);
                }
                break;
            }
        }
        this._state = state;
        this.notifyAll();
    }

    private void registerWithPool() {
        if (this._acceptor != null && !this._registeredWithPool) {
            ((ObjectAdapterI)this._adapter).getThreadPool()._register(this._acceptor.fd(), this);
            this._registeredWithPool = true;
        }
    }

    private void unregisterWithPool() {
        if (this._acceptor != null && this._registeredWithPool) {
            ((ObjectAdapterI)this._adapter).getThreadPool().unregister(this._acceptor.fd());
            this._registeredWithPool = false;
        }
    }

    private void warning(LocalException ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = "connection exception:\n" + sw.toString() + '\n' + ((Object)this._acceptor).toString();
        this._instance.logger().warning(s);
    }

    static {
        $assertionsDisabled = !IncomingConnectionFactory.class.desiredAssertionStatus();
    }
}

