/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Connection;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public final class Reference {
    public static final int ModeTwoway = 0;
    public static final int ModeOneway = 1;
    public static final int ModeBatchOneway = 2;
    public static final int ModeDatagram = 3;
    public static final int ModeBatchDatagram = 4;
    public static final int ModeLast = 4;
    public final Instance instance;
    public final Identity identity;
    public final Map context;
    public final String facet;
    public final int mode;
    public final boolean secure;
    public final String adapterId;
    public final Endpoint[] endpoints;
    public final RouterInfo routerInfo;
    public final LocatorInfo locatorInfo;
    public final ObjectAdapter reverseAdapter;
    public final boolean collocationOptimization;
    public final int hashValue;
    private static EndpointComparator _comparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object obj) {
        Reference r = (Reference)obj;
        if (r == null) {
            return false;
        }
        if (this == r) {
            return true;
        }
        if (!this.identity.category.equals(r.identity.category)) {
            return false;
        }
        if (!this.identity.name.equals(r.identity.name)) {
            return false;
        }
        if (!((Object)this.context).equals(r.context)) {
            return false;
        }
        if (!this.facet.equals(r.facet)) {
            return false;
        }
        if (this.mode != r.mode) {
            return false;
        }
        if (this.secure != r.secure) {
            return false;
        }
        if (!this.adapterId.equals(r.adapterId)) {
            return false;
        }
        if (!this.compare(this.endpoints, r.endpoints)) {
            return false;
        }
        if (this.routerInfo != r.routerInfo) {
            return false;
        }
        if (this.routerInfo != null && r.routerInfo != null && !this.routerInfo.equals(r.routerInfo)) {
            return false;
        }
        if (this.locatorInfo != r.locatorInfo) {
            return false;
        }
        if (this.locatorInfo != null && r.locatorInfo != null && !this.locatorInfo.equals(r.locatorInfo)) {
            return false;
        }
        if (this.reverseAdapter != r.reverseAdapter) {
            return false;
        }
        return this.collocationOptimization == r.collocationOptimization;
    }

    public void streamWrite(BasicStream s) {
        if (this.facet.length() == 0) {
            s.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{this.facet};
            s.writeStringSeq(facetPath);
        }
        s.writeByte((byte)this.mode);
        s.writeBool(this.secure);
        s.writeSize(this.endpoints.length);
        if (this.endpoints.length > 0) {
            if (!$assertionsDisabled && !this.adapterId.equals("")) {
                throw new AssertionError();
            }
            for (int i = 0; i < this.endpoints.length; ++i) {
                this.endpoints[i].streamWrite(s);
            }
        } else {
            s.writeString(this.adapterId);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        String id = Util.identityToString(this.identity);
        if (StringUtil.findFirstOf(id, " \t\n\r:@") != -1) {
            s.append('\"');
            s.append(id);
            s.append('\"');
        } else {
            s.append(id);
        }
        if (this.facet.length() > 0) {
            s.append(" -f ");
            String fs = StringUtil.escapeString(this.facet, "");
            if (StringUtil.findFirstOf(fs, " \t\n\r:@") != -1) {
                s.append('\"');
                s.append(fs);
                s.append('\"');
            } else {
                s.append(fs);
            }
        }
        switch (this.mode) {
            case 0: {
                s.append(" -t");
                break;
            }
            case 1: {
                s.append(" -o");
                break;
            }
            case 2: {
                s.append(" -O");
                break;
            }
            case 3: {
                s.append(" -d");
                break;
            }
            case 4: {
                s.append(" -D");
            }
        }
        if (this.secure) {
            s.append(" -s");
        }
        if (this.endpoints.length > 0) {
            if (!$assertionsDisabled && !this.adapterId.equals("")) {
                throw new AssertionError();
            }
            for (int i = 0; i < this.endpoints.length; ++i) {
                String endp = ((Object)this.endpoints[i]).toString();
                if (endp == null || endp.length() <= 0) continue;
                s.append(':');
                s.append(endp);
            }
        } else {
            String a = StringUtil.escapeString(this.adapterId, null);
            s.append(" @ ");
            if (StringUtil.findFirstOf(a, " \t\n\r") != -1) {
                s.append('\"');
                s.append(a);
                s.append('\"');
            } else {
                s.append(a);
            }
        }
        return s.toString();
    }

    public Reference changeIdentity(Identity newIdentity) {
        if (newIdentity.equals(this.identity)) {
            return this;
        }
        return this.instance.referenceFactory().create(newIdentity, this.context, this.facet, this.mode, this.secure, this.adapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeContext(Map newContext) {
        if (((Object)newContext).equals(this.context)) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, newContext, this.facet, this.mode, this.secure, this.adapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeFacet(String newFacet) {
        if (this.facet.equals(newFacet)) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, newFacet, this.mode, this.secure, this.adapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeTimeout(int newTimeout) {
        Endpoint[] newEndpoints = new Endpoint[this.endpoints.length];
        for (int i = 0; i < this.endpoints.length; ++i) {
            newEndpoints[i] = this.endpoints[i].timeout(newTimeout);
        }
        RouterInfo newRouterInfo = null;
        if (this.routerInfo != null) {
            try {
                RouterPrx newRouter = RouterPrxHelper.uncheckedCast(this.routerInfo.getRouter().ice_timeout(newTimeout));
                ObjectPrx newClientProxy = this.routerInfo.getClientProxy().ice_timeout(newTimeout);
                newRouterInfo = this.instance.routerManager().get(newRouter);
                newRouterInfo.setClientProxy(newClientProxy);
            }
            catch (NoEndpointException ex) {
                // empty catch block
            }
        }
        LocatorInfo newLocatorInfo = null;
        if (this.locatorInfo != null) {
            LocatorPrx newLocator = LocatorPrxHelper.uncheckedCast(this.locatorInfo.getLocator().ice_timeout(newTimeout));
            newLocatorInfo = this.instance.locatorManager().get(newLocator);
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, this.adapterId, newEndpoints, newRouterInfo, newLocatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeMode(int newMode) {
        if (newMode == this.mode) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, newMode, this.secure, this.adapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeSecure(boolean newSecure) {
        if (newSecure == this.secure) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, newSecure, this.adapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeCompress(boolean newCompress) {
        Endpoint[] newEndpoints = new Endpoint[this.endpoints.length];
        for (int i = 0; i < this.endpoints.length; ++i) {
            newEndpoints[i] = this.endpoints[i].compress(newCompress);
        }
        RouterInfo newRouterInfo = null;
        if (this.routerInfo != null) {
            try {
                RouterPrx newRouter = RouterPrxHelper.uncheckedCast(this.routerInfo.getRouter().ice_compress(newCompress));
                ObjectPrx newClientProxy = this.routerInfo.getClientProxy().ice_compress(newCompress);
                newRouterInfo = this.instance.routerManager().get(newRouter);
                newRouterInfo.setClientProxy(newClientProxy);
            }
            catch (NoEndpointException ex) {
                // empty catch block
            }
        }
        LocatorInfo newLocatorInfo = null;
        if (this.locatorInfo != null) {
            LocatorPrx newLocator = LocatorPrxHelper.uncheckedCast(this.locatorInfo.getLocator().ice_compress(newCompress));
            newLocatorInfo = this.instance.locatorManager().get(newLocator);
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, this.adapterId, newEndpoints, newRouterInfo, newLocatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeAdapterId(String newAdapterId) {
        if (this.adapterId.equals(newAdapterId)) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, newAdapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeEndpoints(Endpoint[] newEndpoints) {
        if (this.compare(newEndpoints, this.endpoints)) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, this.adapterId, newEndpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeRouter(RouterPrx newRouter) {
        RouterInfo newRouterInfo = this.instance.routerManager().get(newRouter);
        if (this.routerInfo == newRouterInfo || this.routerInfo != null && newRouterInfo != null && newRouterInfo.equals(this.routerInfo)) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, this.adapterId, this.endpoints, newRouterInfo, this.locatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeLocator(LocatorPrx newLocator) {
        LocatorInfo newLocatorInfo = this.instance.locatorManager().get(newLocator);
        if (this.locatorInfo == newLocatorInfo || this.locatorInfo != null && newLocatorInfo != null && newLocatorInfo.equals(this.locatorInfo)) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, this.adapterId, this.endpoints, this.routerInfo, newLocatorInfo, this.reverseAdapter, this.collocationOptimization);
    }

    public Reference changeCollocationOptimization(boolean newCollocationOptimization) {
        if (newCollocationOptimization == this.collocationOptimization) {
            return this;
        }
        return this.instance.referenceFactory().create(this.identity, this.context, this.facet, this.mode, this.secure, this.adapterId, this.endpoints, this.routerInfo, this.locatorInfo, this.reverseAdapter, newCollocationOptimization);
    }

    public Reference changeDefault() {
        RouterInfo routerInfo = this.instance.routerManager().get(this.instance.referenceFactory().getDefaultRouter());
        LocatorInfo locatorInfo = this.instance.locatorManager().get(this.instance.referenceFactory().getDefaultLocator());
        return this.instance.referenceFactory().create(this.identity, this.context, "", 0, false, this.adapterId, this.endpoints, routerInfo, locatorInfo, null, true);
    }

    public Connection getConnection() {
        Connection connection;
        if (this.reverseAdapter != null) {
            int j;
            ObjectAdapterI adapter = (ObjectAdapterI)this.reverseAdapter;
            Connection[] connections = adapter.getIncomingConnections();
            Endpoint[] endpoints = new Endpoint[connections.length];
            for (int i = 0; i < connections.length; ++i) {
                endpoints[i] = connections[i].endpoint();
            }
            if ((endpoints = this.filterEndpoints(endpoints)).length == 0) {
                NoEndpointException e = new NoEndpointException();
                e.proxy = this.toString();
                throw e;
            }
            for (j = 0; j < connections.length && !((Object)connections[j].endpoint()).equals(endpoints[0]); ++j) {
            }
            if (!$assertionsDisabled && j >= connections.length) {
                throw new AssertionError();
            }
            connection = connections[j];
        } else {
            while (true) {
                BooleanHolder cached = new BooleanHolder();
                cached.value = false;
                Endpoint[] endpts = null;
                if (this.routerInfo != null) {
                    ObjectPrx proxy = this.routerInfo.getClientProxy();
                    endpts = ((ObjectPrxHelperBase)proxy).__reference().endpoints;
                } else if (this.endpoints.length > 0) {
                    endpts = this.endpoints;
                } else if (this.locatorInfo != null) {
                    endpts = this.locatorInfo.getEndpoints(this, cached);
                }
                Endpoint[] filteredEndpts = null;
                if (endpts != null) {
                    filteredEndpts = this.filterEndpoints(endpts);
                }
                if (filteredEndpts == null || filteredEndpts.length == 0) {
                    NoEndpointException e = new NoEndpointException();
                    e.proxy = this.toString();
                    throw e;
                }
                try {
                    OutgoingConnectionFactory factory = this.instance.outgoingConnectionFactory();
                    connection = factory.create(filteredEndpts);
                    if (!$assertionsDisabled && connection == null) {
                        throw new AssertionError();
                    }
                }
                catch (LocalException ex) {
                    if (this.routerInfo == null && this.endpoints.length == 0) {
                        if (!$assertionsDisabled && this.locatorInfo == null) {
                            throw new AssertionError();
                        }
                        this.locatorInfo.clearCache(this);
                        if (cached.value) {
                            TraceLevels traceLevels = this.instance.traceLevels();
                            Logger logger = this.instance.logger();
                            if (traceLevels.retry < 2) continue;
                            String s = "connection to cached endpoints failed\nremoving endpoints from cache and trying one more time\n" + ex;
                            logger.trace(traceLevels.retryCat, s);
                            continue;
                        }
                    }
                    throw ex;
                }
                break;
            }
            if (this.routerInfo != null) {
                connection.setAdapter(this.routerInfo.getAdapter());
            }
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        return connection;
    }

    public Endpoint[] filterEndpoints(Endpoint[] allEndpoints) {
        Endpoint endpoint;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (int i = 0; i < allEndpoints.length; ++i) {
            if (allEndpoints[i].unknown()) continue;
            endpoints.add(allEndpoints[i]);
        }
        switch (this.mode) {
            case 0: 
            case 1: 
            case 2: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    endpoint = (Endpoint)i.next();
                    if (!endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
            case 3: 
            case 4: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    endpoint = (Endpoint)i.next();
                    if (endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
        }
        Collections.shuffle(endpoints);
        if (this.secure) {
            Iterator i = endpoints.iterator();
            while (i.hasNext()) {
                endpoint = (Endpoint)i.next();
                if (endpoint.secure()) continue;
                i.remove();
            }
        } else {
            Collections.sort(endpoints, _comparator);
        }
        Endpoint[] arr = new Endpoint[endpoints.size()];
        endpoints.toArray(arr);
        return arr;
    }

    Reference(Instance inst, Identity ident, Map ctx, String fac, int md, boolean sec, String adptId, Endpoint[] endpts, RouterInfo rtrInfo, LocatorInfo locInfo, ObjectAdapter rvAdapter, boolean collocationOpt) {
        int i;
        if (!$assertionsDisabled && ident.name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ident.category == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && fac == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && adptId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !adptId.equals("") && endpts.length != 0) {
            throw new AssertionError();
        }
        this.instance = inst;
        this.identity = ident;
        this.context = ctx;
        this.facet = fac;
        this.mode = md;
        this.secure = sec;
        this.adapterId = adptId;
        this.endpoints = endpts;
        this.routerInfo = rtrInfo;
        this.locatorInfo = locInfo;
        this.reverseAdapter = rvAdapter;
        this.collocationOptimization = collocationOpt;
        int h = 0;
        int sz = this.identity.name.length();
        for (i = 0; i < sz; ++i) {
            h = 5 * h + this.identity.name.charAt(i);
        }
        sz = this.identity.category.length();
        for (i = 0; i < sz; ++i) {
            h = 5 * h + this.identity.category.charAt(i);
        }
        h = 5 * h + ((Object)this.context.entrySet()).hashCode();
        sz = this.facet.length();
        for (i = 0; i < sz; ++i) {
            h = 5 * h + this.facet.charAt(i);
        }
        h = 5 * h + this.mode;
        this.hashValue = h = 5 * h + (this.secure ? 1 : 0);
    }

    private boolean compare(Endpoint[] arr1, Endpoint[] arr2) {
        if (arr1 == arr2) {
            return true;
        }
        if (arr1.length == arr2.length) {
            for (int i = 0; i < arr1.length; ++i) {
                if (((Object)arr1[i]).equals(arr2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Reference.class.desiredAssertionStatus();
        _comparator = new EndpointComparator();
    }

    static class EndpointComparator
    implements Comparator {
        EndpointComparator() {
        }

        public int compare(Object l, Object r) {
            Endpoint le = (Endpoint)l;
            Endpoint re = (Endpoint)r;
            boolean ls = le.secure();
            boolean rs = re.secure();
            if (ls && rs || !ls && !rs) {
                return 0;
            }
            if (!ls && rs) {
                return -1;
            }
            return 1;
        }
    }
}

