/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Identity;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ServantLocator;
import Ice.Util;
import IceInternal.Instance;
import IceUtil.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ServantManager {
    private Instance _instance;
    private final String _adapterName;
    private HashMap _servantMapMap = new HashMap();
    private HashMap _locatorMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void addServant(Object servant, Identity ident, String facet) {
        HashMap<String, Object> m;
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (facet == null) {
            facet = "";
        }
        if ((m = (HashMap<String, Object>)this._servantMapMap.get(ident)) == null) {
            m = new HashMap<String, Object>();
            this._servantMapMap.put(ident, m);
        } else if (m.containsKey(facet)) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = Util.identityToString(ident);
            ex.kindOfObject = "servant";
            if (facet.length() > 0) {
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            }
            throw ex;
        }
        m.put(facet, servant);
    }

    public synchronized Object removeServant(Identity ident, String facet) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (facet == null) {
            facet = "";
        }
        HashMap m = (HashMap)this._servantMapMap.get(ident);
        Object obj = null;
        if (m == null || (obj = (Object)m.remove(facet)) == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = Util.identityToString(ident);
            ex.kindOfObject = "servant";
            if (facet.length() > 0) {
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "");
            }
            throw ex;
        }
        if (m.isEmpty()) {
            this._servantMapMap.remove(ident);
        }
        return obj;
    }

    public synchronized Map removeAllFacets(Identity ident) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        HashMap m = (HashMap)this._servantMapMap.get(ident);
        if (m == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = Util.identityToString(ident);
            ex.kindOfObject = "servant";
            throw ex;
        }
        this._servantMapMap.remove(ident);
        return m;
    }

    public synchronized Object findServant(Identity ident, String facet) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (facet == null) {
            facet = "";
        }
        HashMap m = (HashMap)this._servantMapMap.get(ident);
        Object obj = null;
        if (m != null) {
            obj = (Object)m.get(facet);
        }
        return obj;
    }

    public synchronized Map findAllFacets(Identity ident) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        HashMap m = (HashMap)this._servantMapMap.get(ident);
        if (m != null) {
            return new HashMap(m);
        }
        return new HashMap();
    }

    public synchronized boolean hasServant(Identity ident) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        HashMap m = (HashMap)this._servantMapMap.get(ident);
        if (m == null) {
            return false;
        }
        if (!$assertionsDisabled && m.isEmpty()) {
            throw new AssertionError();
        }
        return true;
    }

    public synchronized void addServantLocator(ServantLocator locator, String category) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        ServantLocator l = (ServantLocator)this._locatorMap.get(category);
        if (l != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = StringUtil.escapeString(category, "");
            ex.kindOfObject = "servant locator";
            throw ex;
        }
        this._locatorMap.put(category, locator);
    }

    public synchronized ServantLocator findServantLocator(String category) {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        return (ServantLocator)this._locatorMap.get(category);
    }

    public ServantManager(Instance instance, String adapterName) {
        this._instance = instance;
        this._adapterName = adapterName;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public synchronized void destroy() {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        this._servantMapMap.clear();
        Iterator p = this._locatorMap.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry e = p.next();
            ServantLocator locator = (ServantLocator)e.getValue();
            try {
                locator.deactivate((String)e.getKey());
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "exception during locator deactivation:\nobject adapter: `" + this._adapterName + "'\n" + "locator category: `" + e.getKey() + "'\n" + sw.toString();
                this._instance.logger().error(s);
            }
        }
        this._locatorMap.clear();
        this._instance = null;
    }

    static {
        $assertionsDisabled = !ServantManager.class.desiredAssertionStatus();
    }
}

