/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;

public class ConsoleDocumentAdapter
implements IDocumentAdapter,
IDocumentListener {
    private int consoleWidth = -1;
    private List textChangeListeners;
    private IDocument document;
    private List regions;
    private Pattern pattern = Pattern.compile("^.*$", 8);

    public ConsoleDocumentAdapter(int width) {
        this.textChangeListeners = new ArrayList();
        this.consoleWidth = width;
        this.regions = new ArrayList();
    }

    /*
     * Unable to fully structure code
     */
    private void repairLines(int eventOffset) {
        try {
            docLine = this.document.getLineOfOffset(eventOffset);
            docLineStart = this.document.getLineOffset(docLine);
            textLine = this.getLineAtOffset(docLineStart);
            i = this.regions.size() - 1;
            while (i >= textLine) {
                this.regions.remove(i);
                --i;
            }
            numLinesInDoc = this.document.getNumberOfLines();
            line = null;
            offset = 0;
            i = docLine;
            while (i < numLinesInDoc) {
                block9: {
                    offset = this.document.getLineOffset(i);
                    length = this.document.getLineLength(i);
                    if (length != 0) ** GOTO lbl38
                    this.regions.add(new Region(offset, 0));
                    break block9;
lbl-1000:
                    // 1 sources

                    {
                        trimmedLength = length;
                        lineDelimiter = this.document.getLineDelimiter(i);
                        lineDelimiterLength = 0;
                        if (lineDelimiter != null) {
                            lineDelimiterLength = lineDelimiter.length();
                            trimmedLength -= lineDelimiterLength;
                        }
                        if (this.consoleWidth > 0 && this.consoleWidth < trimmedLength) {
                            this.regions.add(new Region(offset, this.consoleWidth));
                            offset += this.consoleWidth;
                            length -= this.consoleWidth;
                            continue;
                        }
                        this.regions.add(new Region(offset, length));
                        offset += length;
                        length -= length;
lbl38:
                        // 3 sources

                        ** while (length > 0)
                    }
                }
                ++i;
            }
            if (line != null && this.lineEndsWithDelimeter(line)) {
                this.regions.add(new Region(offset, 0));
            }
        }
        catch (BadLocationException v0) {}
        if (this.regions.size() == 0) {
            this.regions.add(new Region(this.document.getLength(), 0));
        }
    }

    private boolean lineEndsWithDelimeter(String line) {
        String[] lld = this.document.getLegalLineDelimiters();
        int i = 0;
        while (i < lld.length) {
            if (line.endsWith(lld[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDocument(IDocument doc) {
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
        this.document = doc;
        if (this.document != null) {
            this.document.addDocumentListener((IDocumentListener)this);
            this.repairLines(0);
        }
    }

    public synchronized void addTextChangeListener(TextChangeListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.textChangeListeners.contains(listener)) {
            this.textChangeListeners.add(listener);
        }
    }

    public synchronized void removeTextChangeListener(TextChangeListener listener) {
        if (this.textChangeListeners != null) {
            Assert.isNotNull((Object)listener);
            this.textChangeListeners.remove(listener);
        }
    }

    public int getCharCount() {
        return this.document.getLength();
    }

    public String getLine(int lineIndex) {
        Region region = (Region)this.regions.get(lineIndex);
        try {
            StringBuffer line = new StringBuffer(this.document.get(region.getOffset(), region.getLength()));
            int index = line.length() - 1;
            while (index > -1 && (line.charAt(index) == '\n' || line.charAt(index) == '\r')) {
                --index;
            }
            return line.substring(0, index + 1);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getLineAtOffset(int offset) {
        if (offset == 0 || this.regions.size() <= 1) {
            return 0;
        }
        if (offset == this.document.getLength()) {
            return this.regions.size() - 1;
        }
        int left = 0;
        int right = this.regions.size() - 1;
        int midIndex = 0;
        Region mid = null;
        while (left <= right) {
            midIndex = (left + right) / 2;
            mid = (Region)this.regions.get(midIndex);
            if (offset < mid.getOffset()) {
                right = midIndex;
                continue;
            }
            if (offset >= mid.getOffset() + mid.getLength()) {
                left = midIndex + 1;
                continue;
            }
            return midIndex;
        }
        return midIndex;
    }

    public int getLineCount() {
        return this.regions.size();
    }

    public String getLineDelimiter() {
        return System.getProperty("line.separator");
    }

    public int getOffsetAtLine(int lineIndex) {
        return ((Region)this.regions.get(lineIndex)).getOffset();
    }

    public String getTextRange(int start, int length) {
        try {
            return this.document.get(start, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        try {
            this.document.replace(start, replaceLength, text);
        }
        catch (BadLocationException badLocationException) {}
    }

    public synchronized void setText(String text) {
        TextChangedEvent changeEvent = new TextChangedEvent((StyledTextContent)this);
        Iterator iter = this.textChangeListeners.iterator();
        while (iter.hasNext()) {
            TextChangeListener element = (TextChangeListener)iter.next();
            element.textSet(changeEvent);
        }
    }

    public synchronized void documentAboutToBeChanged(DocumentEvent event) {
        if (this.document == null) {
            return;
        }
        TextChangingEvent changeEvent = new TextChangingEvent((StyledTextContent)this);
        changeEvent.start = event.fOffset;
        changeEvent.newText = event.fText == null ? "" : event.fText;
        changeEvent.replaceCharCount = event.fLength;
        changeEvent.newCharCount = event.fText == null ? 0 : event.fText.length();
        int first = this.getLineAtOffset(event.fOffset);
        int last = this.getLineAtOffset(event.fOffset + event.fLength);
        changeEvent.replaceLineCount = last - first;
        changeEvent.newLineCount = this.countLines(event.fText);
        Iterator iter = this.textChangeListeners.iterator();
        while (iter.hasNext()) {
            TextChangeListener element = (TextChangeListener)iter.next();
            element.textChanging(changeEvent);
        }
    }

    private int countLines(String string) {
        Matcher matcher = this.pattern.matcher(string);
        int count = 0;
        while (matcher.find()) {
            ++count;
            if (this.consoleWidth <= 0) continue;
            String line = matcher.group();
            count += line.length() / this.consoleWidth;
        }
        if (this.lineEndsWithDelimeter(string)) {
            ++count;
        }
        return count;
    }

    public synchronized void documentChanged(DocumentEvent event) {
        if (this.document == null) {
            return;
        }
        this.repairLines(event.fOffset);
        TextChangedEvent changeEvent = new TextChangedEvent((StyledTextContent)this);
        Iterator iter = this.textChangeListeners.iterator();
        while (iter.hasNext()) {
            TextChangeListener element = (TextChangeListener)iter.next();
            element.textChanged(changeEvent);
        }
    }

    public void setWidth(int width) {
        this.consoleWidth = width;
        this.repairLines(0);
        TextChangedEvent changeEvent = new TextChangedEvent((StyledTextContent)this);
        Iterator iter = this.textChangeListeners.iterator();
        while (iter.hasNext()) {
            TextChangeListener element = (TextChangeListener)iter.next();
            element.textSet(changeEvent);
        }
    }
}

