/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import java.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;

public class RedoAction
extends StackAction {
    public RedoAction(IWorkbenchPart part) {
        super(part);
    }

    public RedoAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
    }

    protected boolean calculateEnabled() {
        return this.getCommandStack().canRedo();
    }

    protected void init() {
        super.init();
        this.setToolTipText(MessageFormat.format(GEFMessages.RedoAction_Tooltip, "").trim());
        this.setText(MessageFormat.format(GEFMessages.RedoAction_Label, "").trim());
        this.setId(ActionFactory.REDO.getId());
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_REDO_DISABLED"));
    }

    protected void refresh() {
        Command redoCmd = this.getCommandStack().getRedoCommand();
        this.setToolTipText(MessageFormat.format(GEFMessages.RedoAction_Tooltip, this.getLabelForCommand(redoCmd)).trim());
        this.setText(MessageFormat.format(GEFMessages.RedoAction_Label, this.getLabelForCommand(redoCmd)).trim());
        super.refresh();
    }

    public void run() {
        this.getCommandStack().redo();
    }
}

