/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Bond;
import MCview.Matrix;
import MCview.PDBChain;
import MCview.PDBfile;
import MCview.Zsort;
import MCview.myAtom;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.util.Vector;

public class rotCanvas
extends Canvas {
    Matrix idmat = new Matrix(3, 3);
    Matrix objmat = new Matrix(3, 3);
    boolean redrawneeded = true;
    int omx = 0;
    int mx = 0;
    int omy = 0;
    int my = 0;
    public PDBfile pdb;
    int bsize;
    Image img;
    Graphics ig;
    Dimension prefsize;
    float[] centre = new float[3];
    float[] width = new float[3];
    float maxwidth;
    float scale;
    String inStr;
    String inType;
    boolean depthcue = true;
    boolean wire = false;
    boolean bymolecule = false;
    boolean zbuffer = true;
    boolean dragging;
    int xstart;
    int xend;
    int ystart;
    int yend;
    int xmid;
    int ymid;
    Font font = new Font("Helvetica", 0, 10);

    public rotCanvas(PDBfile pdb, Dimension d) throws IOException {
        this.pdb = pdb;
        this.prefsize = new Dimension(d);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i != j) {
                    this.idmat.addElement(i, j, 0.0f);
                    this.objmat.addElement(i, j, 0.0f);
                } else {
                    this.idmat.addElement(i, j, 1.0f);
                    this.objmat.addElement(i, j, 1.0f);
                }
                ++j;
            }
            ++i;
        }
        this.addPDBfile();
    }

    public void addPDBfile() {
        this.findCentre();
        this.findWidth();
        this.scale = this.findScale();
        System.out.println("Scale factor = " + this.scale);
    }

    public void deleteBonds() {
        this.scale = 0.0f;
        this.maxwidth = 0.0f;
        this.width[0] = 0.0f;
        this.width[1] = 0.0f;
        this.width[2] = 0.0f;
        this.centre[0] = 0.0f;
        this.centre[1] = 0.0f;
        this.centre[2] = 0.0f;
        int i = 0;
        while (i < this.pdb.chains.size()) {
            ((PDBChain)this.pdb.chains.elementAt((int)i)).bonds = null;
            ++i;
        }
    }

    public void findWidth() {
        float[] max = new float[3];
        float[] min = new float[3];
        max[0] = -1.0E30f;
        max[1] = -1.0E30f;
        max[2] = -1.0E30f;
        min[0] = 1.0E30f;
        min[1] = 1.0E30f;
        min[2] = 1.0E30f;
        int ii = 0;
        while (ii < this.pdb.chains.size()) {
            if (((PDBChain)this.pdb.chains.elementAt((int)ii)).isVisible) {
                Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
                int i = 0;
                while (i < bonds.size()) {
                    Bond tmp = (Bond)bonds.elementAt(i);
                    if (tmp.start[0] >= max[0]) {
                        max[0] = tmp.start[0];
                    }
                    if (tmp.start[1] >= max[1]) {
                        max[1] = tmp.start[1];
                    }
                    if (tmp.start[2] >= max[2]) {
                        max[2] = tmp.start[2];
                    }
                    if (tmp.start[0] <= min[0]) {
                        min[0] = tmp.start[0];
                    }
                    if (tmp.start[1] <= min[1]) {
                        min[1] = tmp.start[1];
                    }
                    if (tmp.start[2] <= min[2]) {
                        min[2] = tmp.start[2];
                    }
                    if (tmp.end[0] >= max[0]) {
                        max[0] = tmp.end[0];
                    }
                    if (tmp.end[1] >= max[1]) {
                        max[1] = tmp.end[1];
                    }
                    if (tmp.end[2] >= max[2]) {
                        max[2] = tmp.end[2];
                    }
                    if (tmp.end[0] <= min[0]) {
                        min[0] = tmp.end[0];
                    }
                    if (tmp.end[1] <= min[1]) {
                        min[1] = tmp.end[1];
                    }
                    if (tmp.end[2] <= min[2]) {
                        min[2] = tmp.end[2];
                    }
                    ++i;
                }
            }
            ++ii;
        }
        System.out.println("xmax " + max[0] + " min " + min[0]);
        System.out.println("ymax " + max[1] + " min " + min[1]);
        System.out.println("zmax " + max[2] + " min " + min[2]);
        this.width[0] = Math.abs(max[0] - min[0]);
        this.width[1] = Math.abs(max[1] - min[1]);
        this.width[2] = Math.abs(max[2] - min[2]);
        this.maxwidth = this.width[0];
        if (this.width[1] > this.width[0]) {
            this.maxwidth = this.width[1];
        }
        if (this.width[2] > this.width[1]) {
            this.maxwidth = this.width[2];
        }
        System.out.println("Maxwidth = " + this.maxwidth);
    }

    public float findScale() {
        int height;
        int width;
        if (this.size().width != 0) {
            width = this.size().width;
            height = this.size().height;
        } else {
            width = this.prefsize.width;
            height = this.prefsize.height;
        }
        int dim = width < height ? width : height;
        return (float)((double)dim / (1.5 * (double)this.maxwidth));
    }

    public void findCentre() {
        float xtot = 0.0f;
        float ytot = 0.0f;
        float ztot = 0.0f;
        int bsize = 0;
        int ii = 0;
        while (ii < this.pdb.chains.size()) {
            if (((PDBChain)this.pdb.chains.elementAt((int)ii)).isVisible) {
                Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
                bsize += bonds.size();
                int i = 0;
                while (i < bonds.size()) {
                    xtot = xtot + ((Bond)bonds.elementAt((int)i)).start[0] + ((Bond)bonds.elementAt((int)i)).end[0];
                    ytot = ytot + ((Bond)bonds.elementAt((int)i)).start[1] + ((Bond)bonds.elementAt((int)i)).end[1];
                    ztot = ztot + ((Bond)bonds.elementAt((int)i)).start[2] + ((Bond)bonds.elementAt((int)i)).end[2];
                    ++i;
                }
            }
            ++ii;
        }
        this.centre[0] = xtot / (2.0f * (float)bsize);
        this.centre[1] = ytot / (2.0f * (float)bsize);
        this.centre[2] = ztot / (2.0f * (float)bsize);
    }

    public void paint(Graphics g) {
        if (this.img == null || this.prefsize.width != this.size().width || this.prefsize.height != this.size().height) {
            this.prefsize.width = this.size().width;
            this.prefsize.height = this.size().height;
            this.scale = this.findScale();
            this.img = this.createImage(this.prefsize.width, this.prefsize.height);
            this.ig = this.img.getGraphics();
            this.redrawneeded = true;
        }
        if (this.redrawneeded) {
            this.drawBackground(this.ig, Color.black);
            this.drawScene(this.ig);
            this.redrawneeded = false;
        } else {
            this.ig = this.img.getGraphics();
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public void drawBackground(Graphics g, Color col) {
        g.setColor(col);
        g.fillRect(0, 0, this.prefsize.width, this.prefsize.height);
    }

    public void drawScene(Graphics g) {
        Vector bonds = new Vector();
        int ii = 0;
        while (ii < this.pdb.chains.size()) {
            if (((PDBChain)this.pdb.chains.elementAt((int)ii)).isVisible) {
                Vector tmp = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
                int i = 0;
                while (i < tmp.size()) {
                    bonds.addElement(tmp.elementAt(i));
                    ++i;
                }
            }
            ++ii;
        }
        if (this.zbuffer) {
            Zsort.Zsort(bonds);
        }
        int i = 0;
        while (i < bonds.size()) {
            Bond tmpBond = (Bond)bonds.elementAt(i);
            this.xstart = (int)((tmpBond.start[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            this.ystart = (int)((tmpBond.start[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            this.xend = (int)((tmpBond.end[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            this.yend = (int)((tmpBond.end[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            this.xmid = (this.xend + this.xstart) / 2;
            this.ymid = (this.yend + this.ystart) / 2;
            if (this.depthcue && !this.bymolecule) {
                if (tmpBond.start[2] < this.centre[2] - this.maxwidth / 6.0f) {
                    g.setColor(tmpBond.startCol.darker().darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                    g.setColor(tmpBond.endCol.darker().darker());
                    this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
                } else if (tmpBond.start[2] < this.centre[2] + this.maxwidth / 6.0f) {
                    g.setColor(tmpBond.startCol.darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                    g.setColor(tmpBond.endCol.darker());
                    this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
                } else {
                    g.setColor(tmpBond.startCol);
                    this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                    g.setColor(tmpBond.endCol);
                    this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
                }
            } else if (this.depthcue && this.bymolecule) {
                if (tmpBond.start[2] < this.centre[2] - this.maxwidth / 6.0f) {
                    g.setColor(Color.green.darker().darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
                } else if (tmpBond.start[2] < this.centre[2] + this.maxwidth / 6.0f) {
                    g.setColor(Color.green.darker());
                    this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
                } else {
                    g.setColor(Color.green);
                    this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
                }
            } else if (!this.depthcue && !this.bymolecule) {
                g.setColor(tmpBond.startCol);
                this.drawLine(g, this.xstart, this.ystart, this.xmid, this.ymid);
                g.setColor(tmpBond.endCol);
                this.drawLine(g, this.xmid, this.ymid, this.xend, this.yend);
            } else {
                this.drawLine(g, this.xstart, this.ystart, this.xend, this.yend);
            }
            ++i;
        }
    }

    public void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (!this.wire) {
            if ((double)((float)Math.abs(y2 - y1) / (float)Math.abs(x2 - x1)) < 0.5) {
                g.drawLine(x1, y1, x2, y2);
                g.drawLine(x1 + 1, y1 + 1, x2 + 1, y2 + 1);
                g.drawLine(x1, y1 - 1, x2, y2 - 1);
            } else {
                g.setColor(g.getColor().brighter());
                g.drawLine(x1, y1, x2, y2);
                g.drawLine(x1 + 1, y1, x2 + 1, y2);
                g.drawLine(x1 - 1, y1, x2 - 1, y2);
            }
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    public Dimension minimumsize() {
        return this.prefsize;
    }

    public Dimension preferredsize() {
        return this.prefsize;
    }

    public boolean keyDown(Event evt, int key) {
        if (key == 1004) {
            this.scale = (float)((double)this.scale * 1.1);
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 1005) {
            this.scale = (float)((double)this.scale * 0.9);
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 119) {
            this.wire = !this.wire;
            System.out.println("wireframe " + this.wire);
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 100) {
            this.depthcue = !this.depthcue;
            System.out.println("Depth cueing is " + this.depthcue);
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 109) {
            this.bymolecule = !this.bymolecule;
            System.out.println("Bymolecule is " + this.bymolecule);
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 122) {
            this.zbuffer = !this.zbuffer;
            System.out.println("Z buffering is " + this.zbuffer);
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 99) {
            this.bymolecule = false;
            this.pdb.setChainColours();
            System.out.println("Colouring by chain");
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 104) {
            this.bymolecule = false;
            this.pdb.setHydrophobicityColours();
            System.out.println("Colouring by hydrophobicity");
            this.redrawneeded = true;
            this.repaint();
        } else if (key == 113) {
            this.bymolecule = false;
            this.pdb.setChargeColours();
            System.out.println("Colouring charges and cysteines");
            this.redrawneeded = true;
            this.repaint();
        } else {
            super.keyDown(evt, key);
        }
        return true;
    }

    public boolean mouseDrag(Event e, int x, int y) {
        this.mx = x;
        this.my = y;
        Matrix objmat = new Matrix(3, 3);
        objmat.setIdentity();
        if ((e.modifiers & 4) != 0) {
            objmat.rotatez(this.mx - this.omx);
        } else {
            objmat.rotatex(this.my - this.omy);
            objmat.rotatey(this.omx - this.mx);
        }
        int ii = 0;
        while (ii < this.pdb.chains.size()) {
            Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
            int i = 0;
            while (i < bonds.size()) {
                Bond tmpBond = (Bond)bonds.elementAt(i);
                tmpBond.translate(-this.centre[0], -this.centre[1], -this.centre[2]);
                tmpBond.start = objmat.vectorMultiply(tmpBond.start);
                tmpBond.end = objmat.vectorMultiply(tmpBond.end);
                tmpBond.translate(this.centre[0], this.centre[1], this.centre[2]);
                ++i;
            }
            ++ii;
        }
        objmat = null;
        this.omx = this.mx;
        this.omy = this.my;
        this.redrawneeded = true;
        this.paint(this.getGraphics());
        this.dragging = true;
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (!this.dragging) {
            this.findAtom(x, y);
        }
        this.drawLabels();
        return true;
    }

    public void drawLabels() {
        this.redrawneeded = true;
        this.paint(this.getGraphics());
        int ii = 0;
        while (ii < this.pdb.chains.size()) {
            PDBChain chain = (PDBChain)this.pdb.chains.elementAt(ii);
            if (chain.isVisible) {
                Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
                int i = 0;
                while (i < bonds.size()) {
                    Bond tmpBond = (Bond)bonds.elementAt(i);
                    if (tmpBond.at1.isSelected) {
                        this.labelAtom(this.img.getGraphics(), tmpBond, 1);
                    }
                    if (tmpBond.at2.isSelected) {
                        this.labelAtom(this.img.getGraphics(), tmpBond, 2);
                    }
                    ++i;
                }
            }
            ++ii;
        }
        this.getGraphics().drawImage(this.img, 0, 0, this);
        this.dragging = false;
    }

    public void labelAtom(Graphics g, Bond b, int n) {
        int ystart;
        int xstart;
        g.setFont(this.font);
        if (n == 1) {
            xstart = (int)((b.start[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            ystart = (int)((b.start[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            g.setColor(Color.red);
            g.drawString(String.valueOf(b.at1.resName) + "-" + b.at1.resNumber, xstart, ystart);
        }
        if (n == 2) {
            xstart = (int)((b.end[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
            ystart = (int)((b.end[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2));
            g.setColor(Color.red);
            g.drawString(String.valueOf(b.at2.resName) + "-" + b.at2.resNumber, xstart, ystart);
        }
    }

    public boolean mouseDown(Event evt, int x, int y) {
        this.mx = x;
        this.my = y;
        this.omx = this.mx;
        this.omy = this.my;
        this.dragging = false;
        return true;
    }

    public myAtom findAtom(int x, int y) {
        myAtom fatom = null;
        int foundchain = -1;
        int ii = 0;
        while (ii < this.pdb.chains.size()) {
            PDBChain chain = (PDBChain)this.pdb.chains.elementAt(ii);
            if (chain.isVisible) {
                Vector bonds = ((PDBChain)this.pdb.chains.elementAt((int)ii)).bonds;
                int i = 0;
                while (i < bonds.size()) {
                    int truey;
                    Bond tmpBond = (Bond)bonds.elementAt(i);
                    int truex = (int)((tmpBond.start[0] - this.centre[0]) * this.scale + (float)(this.size().width / 2));
                    if (Math.abs(truex - x) <= 2 && Math.abs((truey = (int)((tmpBond.start[1] - this.centre[1]) * this.scale + (float)(this.size().height / 2))) - y) <= 2) {
                        System.out.println("Found match");
                        System.out.println(String.valueOf(x) + " " + y);
                        System.out.println(String.valueOf(truex) + " " + truey);
                        System.out.println(String.valueOf(tmpBond.start[0]) + " " + tmpBond.start[1]);
                        System.out.println("Atom 1 = " + tmpBond.at1.resName + " " + tmpBond.at1.resNumber + " " + tmpBond.at1.chain);
                        fatom = tmpBond.at1;
                        fatom.isSelected = !fatom.isSelected;
                        foundchain = ii;
                    }
                    ++i;
                }
            }
            if (fatom != null && chain.ds != null) {
                chain = (PDBChain)this.pdb.chains.elementAt(foundchain);
                int tmp = chain.ds.seqstart + fatom.resNumber - chain.offset;
                int pos = chain.ds.findIndex(tmp);
                System.out.println("Found seq " + chain.ds.name + " " + tmp + " " + pos);
            }
            ++ii;
        }
        return null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

