/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.AddOnManager;
import bilab.ArtemisViewer;
import bilab.DNA;
import bilab.HTMLViewer;
import bilab.ISourceExecutor;
import bilab.InterpretExecutor;
import bilab.JMolViewer;
import bilab.JalViewAlignmentViewer;
import bilab.MoleculeImpl;
import bilab.Notify;
import bilab.PictureViewer;
import bilab.RNA;
import bilab.ResourceManager;
import bilab.SeqStringViewer;
import bilab.TreeViewer;
import bilab.Util;
import bilab.alignment;
import bilab.molecule;
import bilab.picture;
import bilab.protein;
import bilab.seq;
import bilab.tree;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.python.util.PythonInterpreter;
import scigol.NamespaceScope;
import scigol.TypeSpec;

public class BilabPlugin
extends AbstractUIPlugin {
    private static BilabPlugin plugin = null;
    private ResourceManager resourceManager = null;
    public AddOnManager addOnManager = null;
    PythonInterpreter python;
    protected NamespaceScope globalScope;
    protected ISourceExecutor executor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;

    public static BilabPlugin getInstance() {
        if (plugin == null) {
            plugin = new BilabPlugin();
        }
        return plugin;
    }

    public static BilabPlugin getDefault() {
        return BilabPlugin.getInstance();
    }

    public BilabPlugin() {
        if (plugin != null) {
            Notify.devError((Object)this, "BilabPlugin is a singleton - it can only be instantiated once");
        }
        plugin = this;
        this.resourceManager = new ResourceManager((Plugin)this, "bilab.BilabPluginResources");
        this.globalScope = NamespaceScope.newGlobalNamespaceScope();
        this.executor = new InterpretExecutor(this.globalScope);
        this.addOnManager = new AddOnManager(this.resourceManager, this.executor);
    }

    public static ResourceManager getResourceManager() {
        return BilabPlugin.getInstance().resourceManager;
    }

    public static AddOnManager getAddOnManager() {
        return BilabPlugin.getInstance().addOnManager;
    }

    public static ISourceExecutor getExecutor() {
        return BilabPlugin.getInstance().executor;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Notify.logInfo((Object)this, "Loading libraries");
        this.loadLibrary("biojava-1.4pre1.jar");
        this.loadLibrary("jakarta-regexp-1.2.jar");
        this.loadLibrary("commons-collections-2.1.jar");
        this.loadLibrary("jobcontrol.jar");
        this.loadLibrary("Jmol.jar");
        this.loadLibrary("Ice.jar");
        NamespaceScope.registerLibraryClass("bilab", "seq");
        NamespaceScope.registerLibraryClass("bilab", "DNA");
        NamespaceScope.registerLibraryClass("bilab", "RNA");
        NamespaceScope.registerLibraryClass("bilab", "protein");
        NamespaceScope.registerLibraryClass("bilab", "alignment");
        NamespaceScope.registerLibraryClass("bilab", "molecule");
        NamespaceScope.registerLibraryClass("bilab", "seqdb");
        NamespaceScope.registerLibraryClass("bilab", "picture");
        NamespaceScope.registerLibraryClass("bilab", "tree");
        NamespaceScope.registerLibraryClass("bilab", "Notify");
        NamespaceScope.registerLibraryClass("bilab", "Doc");
        NamespaceScope.registerLibraryClass("bilab", "Summary");
        NamespaceScope.registerLibraryClass("bilab", "Sophistication");
        NamespaceScope.registerLibraryClass("bilab", "Util");
        NamespaceScope.registerLibraryClass("bilab", "Emboss");
        NamespaceScope.registerLibraryClass("bilab", "ExternalApps");
        NamespaceScope.registerLibraryClass("bilab", "INotifier");
        NamespaceScope.registerLibraryClass("bilab", "IAnnotated");
        this.globalScope.addUsingNamespace("bilab");
        ResourceManager rm = BilabPlugin.getResourceManager();
        Notify.logInfo((Object)this, "Registering typed viewers");
        rm.registerViewer(new TypeSpec((Type)((Object)DNA.class)), new TypeSpec((Type)((Object)ArtemisViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)RNA.class)), new TypeSpec((Type)((Object)ArtemisViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)protein.class)), new TypeSpec((Type)((Object)SeqStringViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)molecule.class)), new TypeSpec((Type)((Object)JMolViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)alignment.class)), new TypeSpec((Type)((Object)JalViewAlignmentViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)picture.class)), new TypeSpec((Type)((Object)PictureViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)URL.class)), new TypeSpec((Type)((Object)HTMLViewer.class)));
        rm.registerViewer(new TypeSpec((Type)((Object)tree.class)), new TypeSpec((Type)((Object)TreeViewer.class)));
        Notify.logInfo((Object)this, "Registering resource types");
        rm.registerResourceType("TEXT", "Unicode UTF-8 text", "txt");
        rm.registerResourceType("HTML", "Hyper-Text Markup Language document", "html", "htm");
        rm.registerResourceType("PNG", "Portable Network Graphics (PNG) bitmap", "png");
        rm.registerResourceType("JPG", "Joint Photographic Experts Group (JPEG) bitmap", "jpg", "jpeg");
        rm.registerResourceType("GIF", "Compuserve Graphics Interchange Format (GIF) bitmap", "gif");
        rm.registerResourceType("BMP", "Windows Bitmap image (BMP)", "bmp");
        rm.registerResourceType("Postscript", "Postscript program drawing", "ps", "eps");
        rm.registerResourceType("pdb", "Protein Data Bank", "pdb", "ent");
        rm.registerResourceType("mol", "Molecular Design Limited's (MDL) Mol file", "mol", "mdl");
        rm.registerResourceType("pqs", "PQS format", "pqs");
        rm.registerResourceType("sdf", "MDL ISIS SDF format", "sdf", "sd");
        rm.registerResourceType("xyz", "Minnesota Supercomputer Center's (MSC) XYZ (XMol) format", "xyz");
        rm.registerResourceType("EMBL", "EMBL Nucleotide Sequence Database (EMBL-Bank)", "embl");
        rm.registerResourceType("SwissProt", "European Bioinformatics Institute (EBI) Swiss-Prot protein database", "");
        rm.registerResourceType("GenBank", "GenBank NCBI/NIH nucleotide sequence databse", "gb");
        rm.registerResourceType("GenPept", "GenPept NCBI/NIH protein sequence database", "");
        rm.registerResourceType("CT", "naview RNA secondary structure format", "ct");
        rm.registerResourceType("ABI", "ABI automated chromatagraph sequencer trace format", "abi");
        rm.registerResourceType("FASTA", "Pearson/FASTA DNA/protein sequence", "fa", "fsa", "fasta", "fna");
        rm.registerResourceType("BLAST", "BLAST similarity search results", "blast");
        rm.registerResourceType("CLUSTALW", "CLUSTALW Multiple sequence alignment", "aln");
        rm.registerResourceType("MSF", "Pileup/GCG Multiple sequence alignment", "msf");
        rm.registerResourceType("PFAM", "PFAM multiple alignment", "");
        rm.registerResourceType("BLC", "AMPS multiple alignment", "");
        rm.registerResourceType("MEV", "TIGR MultiExperimentViewer Microarray data", "mev");
        rm.registerResourceType("Genepix", "Genepix Microarray data", "grp");
        rm.registerResourceType("Affymetrix", "Affymetrix Microarray data", "txt");
        rm.registerResourceType("Newick", "Newick generic tree format", "newick");
        rm.registerResourceType("list(Newick)", "a list of Newick format trees", "");
        rm.registerResourceType("PhylipMultiSeq", "sequence set in Phylip linear format", "");
        Notify.logInfo((Object)this, "Registering resource importers");
        rm.registerResourceIOProvider(new TypeSpec((Type)((Object)MoleculeImpl.class)));
        rm.registerResourceIOProvider(new TypeSpec((Type)((Object)seq.class)));
        rm.registerResourceIOProvider(new TypeSpec((Type)((Object)alignment.class)));
        rm.registerResourceIOProvider(new TypeSpec((Type)((Object)picture.class)));
        rm.registerResourceIOProvider(new TypeSpec((Type)((Object)tree.class)));
        this.initializePython();
        try {
            Notify.userInfo((Object)this, "executing bilab.sg library");
            InputStream srcStream = rm.findResource("libs/bilab.sg").openStream();
            this.executor.executeSource(srcStream, "bilab.sg");
            srcStream.close();
        }
        catch (Throwable e) {
            Notify.userWarning((Object)this, "error executing bilab.sg library:" + e);
        }
        this.globalScope.addUsingNamespace("bilab.lib");
        Notify.logInfo((Object)this, "Reading add-on configurations");
        String filename = null;
        try {
            filename = "emboss.xac";
            BilabPlugin.getAddOnManager().processConfiguration(rm.findResourceStream(filename));
            this.globalScope.addUsingNamespace("bilab.emboss");
            filename = "phylip.xac";
            BilabPlugin.getAddOnManager().processConfiguration(rm.findResourceStream(filename));
            this.globalScope.addUsingNamespace("bilab.phylip");
        }
        catch (Exception e) {
            Notify.devWarning((Object)this, "Error reading add-on config file '" + filename + "' - " + e.getMessage());
            e.printStackTrace();
        }
        try {
            Notify.userInfo((Object)this, "executing sample.sg");
            InputStream srcStream = rm.findResource("libs/sample.sg").openStream();
            this.executor.executeSource(srcStream, "sample.sg");
            srcStream.close();
        }
        catch (Throwable e) {
            Notify.userWarning((Object)this, "error executing sample.sg:" + e);
        }
    }

    protected void loadLibrary(String jarName) throws IOException {
        BilabPlugin.getResourceManager();
        NamespaceScope.loadLibrary(Util.toNativePathSeparator(ResourceManager.resourceURLToFilename(BilabPlugin.getResourceManager().findResource("libs/" + jarName))));
    }

    protected void initializePython() {
        try {
            ResourceManager rm = BilabPlugin.getResourceManager();
            Notify.devInfo((Object)this, "Instantiating Python interpreter [Jython]");
            String pythonHome = ResourceManager.resourceURLToFilename(rm.findResource("libs/jython"));
            Properties pythonProps = new Properties();
            pythonProps.setProperty("python.home", pythonHome);
            pythonProps.setProperty("python.path", pythonHome);
            pythonProps.setProperty("python.cachedir", "cachedir");
            PythonInterpreter.initialize((Properties)System.getProperties(), (Properties)pythonProps, (String[])new String[0]);
            this.python = new PythonInterpreter();
        }
        catch (IOException iOException) {
            Notify.logError((Object)this, "unable to instantiate python interpreter");
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.python.cleanup();
        super.stop(context);
        plugin = null;
    }

    public NamespaceScope getGlobalScope() {
        return this.globalScope;
    }
}

