/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.BilabPlugin;
import bilab.HTMLViewer;
import java.io.IOException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;

public class BrowserView
extends ViewPart {
    Composite top;
    Composite area;
    Composite addressBar;
    Text address;
    HTMLViewer viewer;
    ToolItem back;
    ToolItem forward;
    ToolItem stop;
    ToolItem reload;
    ToolItem home;

    public void createPartControl(Composite parent) {
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)new FillLayout());
        this.area = new Composite(this.top, 2048);
        FormLayout vlayout = new FormLayout();
        this.area.setLayout((Layout)vlayout);
        this.addressBar = new Composite(this.area, 0);
        FormData addressBarData = new FormData();
        addressBarData.left = new FormAttachment(0, 0);
        addressBarData.top = new FormAttachment(0, 0);
        addressBarData.right = new FormAttachment(100, 0);
        this.addressBar.setLayoutData((Object)addressBarData);
        RowLayout hlayout = new RowLayout();
        hlayout.type = 256;
        hlayout.fill = false;
        hlayout.justify = false;
        hlayout.wrap = true;
        this.addressBar.setLayout((Layout)hlayout);
        ToolBar toolBar = new ToolBar(this.addressBar, 0x800000);
        this.back = new ToolItem(toolBar, 0);
        this.setImage(this.back, "icons/left_small", "Back");
        this.forward = new ToolItem(toolBar, 0x800000);
        this.setImage(this.forward, "icons/right_small", "Forward");
        this.stop = new ToolItem(toolBar, 0x800000);
        this.setImage(this.stop, "icons/stop_small", "Stop");
        this.reload = new ToolItem(toolBar, 0x800000);
        this.setImage(this.reload, "icons/reload_small", "Reload");
        this.home = new ToolItem(toolBar, 0x800000);
        this.setImage(this.home, "icons/home_small", "Home");
        this.address = new Text(this.addressBar, 2048);
        this.address.addKeyListener((KeyListener)new InputListener(this));
        this.viewer = new HTMLViewer(this.area);
        FormData viewerData = new FormData();
        viewerData.top = new FormAttachment((Control)this.addressBar);
        viewerData.bottom = new FormAttachment(100, 0);
        viewerData.left = new FormAttachment(0, 0);
        viewerData.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)viewerData);
        this.setUrl("http://modpod.csm.ornl.gov/syn/");
    }

    protected void setImage(ToolItem b, String resourceNamePrefix, String toolTip) {
        try {
            b.setImage(new Image((Device)Display.getCurrent(), BilabPlugin.getResourceManager().findResourceStream(String.valueOf(resourceNamePrefix) + ".gif")));
            b.setDisabledImage(new Image((Device)Display.getCurrent(), BilabPlugin.getResourceManager().findResourceStream(String.valueOf(resourceNamePrefix) + "_disabled.png")));
            b.setToolTipText(toolTip);
        }
        catch (IOException iOException) {
            b.setText(toolTip);
        }
    }

    public void setFocus() {
        this.address.setFocus();
        this.address.selectAll();
    }

    public void setUrl(String url) {
        this.address.setText(url);
        this.viewer.setInput(url);
    }

    protected void handleInputKeyEvent(KeyEvent e) {
        if (e.stateMask == 0 && e.keyCode == 13) {
            this.setUrl(this.address.getText());
            this.viewer.getControl().setFocus();
        }
    }

    protected class InputListener
    implements KeyListener {
        BrowserView view;

        public InputListener(BrowserView v) {
            this.view = v;
        }

        public void keyPressed(KeyEvent e) {
            this.view.handleInputKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

