/*
 * Decompiled with CFR 0.152.
 */
package bilab;

import bilab.Notify;
import bilab.SizedComposite;
import bilab.ViewerBase;
import bilab.picture;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPart;

public class PictureViewer
extends ViewerBase {
    picture input;
    SizedComposite pictureComposite;
    PaintListener paintListener;

    public PictureViewer(Composite parent) {
        Display display = Display.getCurrent();
        this.input = null;
        this.pictureComposite = new SizedComposite(parent, 262144);
        this.pictureComposite.setPreferedSize(10, 10);
        this.pictureComposite.setMaximumSize(10, 10);
        this.pictureComposite.setMinimumSize(10, 10);
        this.pictureComposite.setSize(10, 10);
        this.pictureComposite.setBackground(display.getSystemColor(1));
        this.paintListener = new PaintListener();
        this.paintListener.input = this.input;
        this.pictureComposite.addListener(9, this.paintListener);
    }

    public Point preferedSize() {
        return this.pictureComposite.computeSize(-1, -1);
    }

    public Point maximumSize() {
        return this.pictureComposite.computeSize(-1, -1);
    }

    public String get_title() {
        return this.input != null ? this.input.get_ShortText() : "<no picture>";
    }

    public String get_description() {
        return this.get_title();
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.pictureComposite;
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        this.pictureComposite.redraw();
    }

    public void setInput(Object input) {
        if (input == null) {
            this.input = null;
        } else if (input instanceof picture) {
            this.input = (picture)input;
            if (this.input.get_PictureType() == picture.PictureType.Image) {
                Rectangle rect = this.input.get_Image().getBounds();
                this.pictureComposite.setPreferedSize(rect.width, rect.height);
                this.pictureComposite.setMaximumSize(rect.width, rect.height);
                this.pictureComposite.setMinimumSize(10, 10);
                this.pictureComposite.setSize(rect.width, rect.height);
            } else {
                Notify.unimplemented((Object)this);
            }
        } else {
            this.input = null;
        }
        this.paintListener.input = this.input;
        this.refresh();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public class PaintListener
    implements Listener {
        public picture input = null;

        public void handleEvent(Event e) {
            if (this.input == null) {
                return;
            }
            if (this.input.get_PictureType() == picture.PictureType.Image) {
                int marginHeight;
                Image image = this.input.get_Image();
                GC gc = e.gc;
                gc.drawImage(image, 0, 0);
                Rectangle rect = image.getBounds();
                Rectangle client = PictureViewer.this.pictureComposite.getClientArea();
                int marginWidth = client.width - rect.width;
                if (marginWidth > 0) {
                    gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                }
                if ((marginHeight = client.height - rect.height) > 0) {
                    gc.fillRectangle(0, rect.height, client.width, marginHeight);
                }
            } else {
                Notify.unimplemented(this);
                GC gc = e.gc;
                gc.fillRectangle(0, 0, 10, 10);
            }
        }
    }
}

