/*
 * Decompiled with CFR 0.152.
 */
package bilab.notebook.model.commands;

import bilab.notebook.model.Connection;
import bilab.notebook.model.Graphic;
import bilab.notebook.model.GraphicsDiagram;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class GraphicDeleteCommand
extends Command {
    private final Graphic child;
    private final GraphicsDiagram parent;
    private List sourceConnections;
    private List targetConnections;
    private boolean wasRemoved;

    public GraphicDeleteCommand(GraphicsDiagram parent, Graphic child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("shape deletion");
        this.parent = parent;
        this.child = child;
    }

    private void addConnections(List connections) {
        for (Connection conn : connections) {
            conn.reconnect();
        }
    }

    public boolean canUndo() {
        return this.wasRemoved;
    }

    public void execute() {
        this.sourceConnections = this.child.getSourceConnections();
        this.targetConnections = this.child.getTargetConnections();
        this.redo();
    }

    public void redo() {
        this.wasRemoved = this.parent.removeChild(this.child);
        if (this.wasRemoved) {
            this.removeConnections(this.sourceConnections);
            this.removeConnections(this.targetConnections);
        }
    }

    private void removeConnections(List connections) {
        for (Connection conn : connections) {
            conn.disconnect();
        }
    }

    public void undo() {
        if (this.parent.addChild(this.child)) {
            this.addConnections(this.sourceConnections);
            this.addConnections(this.targetConnections);
        }
    }
}

