/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignmentPanel;
import jalview.DrawableSequence;
import jalview.ScorePanel;
import jalview.ScoreSequence;
import jalview.Sequence;
import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;

public class BigPanel
extends AlignmentPanel {
    Object parent;
    public ScorePanel scorePanel;
    Scrollbar hscroll;
    int maxoffx;
    int maxoffy;
    int offx;
    int offy;
    int width;
    int height;
    Panel p;

    public BigPanel(Component p, DrawableSequence[] s1) {
        super(p, s1);
        this.scorePanel = null;
        this.componentInit();
    }

    public BigPanel(Component p, DrawableSequence[] s1, ScoreSequence[] s2) {
        super(p, s1);
        this.scorePanel = new ScorePanel(p, s2);
        this.scorePanel = null;
        this.componentInit();
        System.out.println("Loaded BigPanel");
    }

    public void componentInit() {
        super.componentInit();
        this.hscroll = new Scrollbar(0);
        this.add(this.hscroll);
        this.setScrollValues(0, 0);
        if (this.scorePanel != null) {
            this.add(this.scorePanel);
            this.scorePanel.seqPanel.remove(this.scorePanel.seqPanel.hscroll);
        }
        this.seqPanel.remove(this.seqPanel.hscroll);
        System.out.println("Finished BigPanel.componentInit");
    }

    public ScoreSequence[] findScores(Sequence[] s) {
        Vector<ScoreSequence> score = new Vector<ScoreSequence>();
        int i = 0;
        while (i < s.length && s[i] != null) {
            int l = 0;
            while (l < s[i].score.length && s[i].score[l] != null) {
                if (s[i].score[l].size() > 0) {
                    score.addElement(new ScoreSequence(s[i], l));
                }
                ++l;
            }
            ++i;
        }
        ScoreSequence[] out = new ScoreSequence[score.size()];
        i = 0;
        while (i < score.size()) {
            out[i] = (ScoreSequence)score.elementAt(i);
            ++i;
        }
        return out;
    }

    public void setScorePanel(ScorePanel sp) {
        this.scorePanel = sp;
        sp.seqPanel.remove(sp.seqPanel.hscroll);
        this.add(this.scorePanel);
    }

    public void reshape(int x, int y, int width, int height) {
        super.oldreshape(x, y, width, height);
        int scrh = 20;
        int idw = this.idPanel.idCanvas.idWidth;
        int h = height - scrh;
        if (this.scorePanel != null) {
            this.scorePanel.idPanel.idCanvas.idWidth = idw;
            int sph = this.scorePanel.seqPanel.align.getHeight(0, this.scorePanel.seqPanel.align.size() - 1) + this.scorePanel.seqPanel.align.ds[this.scorePanel.seqPanel.align.size() - 1].charHeight + 20;
            int sqh = (this.seqPanel.align.size() + 1) * this.seqPanel.seqCanvas.charHeight;
            h = sph < (height - scrh) / 2 ? height - scrh - sph : (height - scrh) * sqh / (sph + sqh);
            if (this.scaleheight + (this.seqPanel.align.size() + 1) * this.seqPanel.seqCanvas.charHeight < h) {
                h = (this.seqPanel.align.size() + 1) * this.seqPanel.seqCanvas.charHeight + this.scaleheight;
            }
            this.scorePanel.reshape(0, h, width, height - h - scrh);
        }
        this.scalePanel.reshape(0, 0, width, this.scaleheight);
        this.idPanel.reshape(0, this.scaleheight, idw, h - this.scaleheight);
        this.seqPanel.reshape(idw, this.scaleheight, width - idw, h - this.scaleheight);
        this.hscroll.reshape(0, height - scrh, width, scrh);
        this.setScrollValues(this.offx, 0);
    }

    public void setScrollValues(int offx, int offy) {
        this.seqPanel.invalidate();
        this.invalidate();
        this.validate();
        if (this.seqPanel.seqCanvas.size().width > 0) {
            this.width = this.seqPanel.seqCanvas.size().width;
            this.height = this.seqPanel.seqCanvas.size().height;
        } else {
            this.width = 700;
            this.height = 500;
        }
        if (this.maxoffx != this.seqPanel.align.maxLength() + 1) {
            this.maxoffx = this.seqPanel.align.maxLength() + 1;
        }
        this.hscroll.setValues(offx, this.width / this.seqPanel.seqCanvas.charWidth, 0, this.maxoffx);
        this.hscroll.setLineIncrement(1);
        if (this.seqPanel.seqCanvas.endx > 0) {
            this.hscroll.setPageIncrement((this.seqPanel.seqCanvas.endx - this.seqPanel.seqCanvas.startx) / 2);
        }
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (evt.target != this.hscroll) break;
                this.seqPanel.offx = this.offx = this.hscroll.getValue();
                this.scalePanel.scaleCanvas.paintFlag = true;
                this.seqPanel.seqCanvas.repaint();
                this.scalePanel.scaleCanvas.repaint();
                if (this.scorePanel != null) {
                    this.scorePanel.seqPanel.offx = this.offx;
                    this.scorePanel.scalePanel.scaleCanvas.paintFlag = true;
                    this.scorePanel.seqPanel.seqCanvas.repaint();
                    this.scorePanel.scalePanel.scaleCanvas.repaint();
                }
                return true;
            }
        }
        return super.handleEvent(evt);
    }
}

