/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.Alignment;
import jalview.ColourScheme;
import jalview.DrawableSequence;
import jalview.FileParse;
import jalview.ScoreSequence;
import jalview.Sequence;
import jalview.SequenceGroup;
import jalview.SequenceNode;
import jalview.SwissprotFile;
import jalview.TreeFile;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.io.IOException;
import java.util.Vector;

public class DrawableAlignment
extends Alignment {
    DrawableSequence[] ds;
    public ScoreSequence qualityScore;
    boolean autoConsensus = false;

    public DrawableAlignment(DrawableSequence[] ds) {
        super(ds);
        this.ds = ds;
    }

    public void getFeatures(String fids, TextArea ta, String server, String database) {
        try {
            ta.setText("Querying srs server " + server + " and database " + database);
            FileParse fp = new FileParse("http://" + server + "wgetz?-e+[" + database + "-id:" + fids + "]", "URL");
            fp.readLines();
            int ii = 0;
            while (ii < fp.lineArray.size()) {
                String tmp = "";
                while (ii < fp.lineArray.size() && ((String)fp.lineArray.elementAt(ii)).indexOf("//") != 0) {
                    tmp = String.valueOf(tmp) + (String)fp.lineArray.elementAt(ii) + "\n";
                    ++ii;
                }
                tmp = String.valueOf(tmp) + "//";
                ta.setText("Reading features");
                SwissprotFile sp = new SwissprotFile(tmp);
                if (!sp.id.equals("")) {
                    ta.setText("Read features for " + sp.id);
                    int j = 0;
                    while (j < this.ds.length && this.ds[j] != null) {
                        if (this.ds[j].name.equals(sp.id)) {
                            ta.setText("Attaching features to sequence " + this.ds[j].name);
                            String ungap = AlignSeq.extractChars(". -", this.ds[j].sequence);
                            System.out.println(ungap);
                            System.out.println(sp.sequence.sequence);
                            System.out.println(String.valueOf(this.ds[j].start) + " " + this.ds[j].end);
                            System.out.println(sp.sequence.sequence.indexOf(ungap));
                            if (sp.sequence.sequence.indexOf(ungap) == -1) {
                                System.out.println("ERROR: id " + sp.id + "sequence doesn't match alignment sequence");
                            } else if (sp.sequence.sequence.indexOf(ungap) != this.ds[j].start - 1) {
                                System.out.println("Adjusting start end positions for " + sp.id);
                                this.ds[j].start = sp.sequence.sequence.indexOf(ungap) + 1;
                                this.ds[j].end = this.ds[j].start + this.ds[j].sequence.length() - 1;
                            }
                            this.ds[j].features = sp.features;
                            this.ds[j].pdbcode = sp.pdbcode;
                        }
                        ++j;
                    }
                }
                ++ii;
            }
        }
        catch (IOException e) {
            System.out.println("Exception in fetching features " + e);
            ta.setText("ERROR: Exception in fetching features from " + server + " : " + e);
        }
    }

    public Vector getPDBCodes() {
        int i = 0;
        Vector codes = new Vector();
        while (i < this.ds.length && this.ds[i] != null) {
            if (this.ds[i].pdbcode != null && this.ds[i].pdbcode.size() != 0) {
                int j = 0;
                while (j < this.ds[i].pdbcode.size()) {
                    codes.addElement(this.ds[i].pdbcode.elementAt(j));
                    ++j;
                }
            }
            ++i;
        }
        return codes;
    }

    public void getFeatures(TextArea ta, String server, String database) {
        int i = 0;
        String fids = "";
        while (i < this.sequences.length && this.sequences[i] != null) {
            if (this.ds[i].features == null) {
                String id = this.ds[i].name;
                if (id.indexOf("/") > 0) {
                    id = id.substring(0, id.indexOf("/"));
                }
                if (i % 20 == 0) {
                    if ((fids = String.valueOf(fids) + id).substring(fids.length() - 1).equals("|")) {
                        fids = fids.substring(0, fids.length() - 1);
                    }
                    this.getFeatures(fids, ta, server, database);
                    fids = "";
                } else {
                    fids = String.valueOf(fids) + id + "|";
                }
            }
            ++i;
        }
        if (!fids.equals("")) {
            if (fids.substring(fids.length() - 1).equals("|")) {
                fids = fids.substring(0, fids.length() - 1);
            }
            this.getFeatures(fids, ta, server, database);
        }
        ta.setText("done");
    }

    public void getFeatures(TextArea ta, Vector sel, String server, String database) {
        int i = 0;
        while (i < sel.size()) {
            if (sel.elementAt(i) instanceof Sequence && ((Sequence)sel.elementAt((int)i)).features == null) {
                ((Sequence)sel.elementAt(i)).getFeatures(server, database);
                ta.setText("Fetched features for " + this.ds[i].name + " (" + (i + 1) + "/" + sel.size() + ")");
            }
            ++i;
        }
    }

    public void getFeatures(Vector sel, String server, String database) {
        int i = 0;
        while (i < sel.size()) {
            if (sel.elementAt(i) instanceof Sequence && ((Sequence)sel.elementAt((int)i)).features == null) {
                ((Sequence)sel.elementAt(i)).getFeatures(server, database);
            }
            ++i;
        }
    }

    public void getFeatures(String server, String database) {
        int i = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            if (this.ds[i].features == null) {
                this.ds[i].getFeatures(server, database);
            }
            ++i;
        }
    }

    public int getHeight() {
        int i = 0;
        int h = 0;
        while (i < this.ds.length && this.ds[i] != null) {
            h += this.ds[i].charHeight;
            ++i;
        }
        return h;
    }

    public int getHeight(int i, int j) {
        int h = 0;
        while (i < j) {
            h += this.ds[i].charHeight;
            ++i;
        }
        return h;
    }

    public int getHeight(int i) {
        int j = 0;
        int h = 0;
        while (j < i && j < this.ds.length && this.ds[j] != null) {
            if (j > 0) {
                h += this.ds[j - 1].charHeight;
            }
            ++j;
        }
        return h;
    }

    public void findQuality() {
        super.findQuality();
        System.out.println("Done quality");
        if (this.quality != null) {
            ScoreSequence tmp3;
            String tmp2 = new String(this.sequences[0].sequence);
            DrawableSequence tmp = new DrawableSequence("Quality", tmp2, 1, this.maxLength);
            tmp.score[0] = this.quality;
            this.qualityScore = tmp3 = new ScoreSequence(tmp, 0, (int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        }
    }

    public int getHeight(DrawableSequence s) {
        int i = 0;
        int h = 0;
        while (i < this.ds.length && this.ds[i] != null) {
            if (this.ds[i] != s) {
                h += this.ds[i].charHeight;
            }
            ++i;
        }
        return h;
    }

    public void addSequence(DrawableSequence[] s) {
        int oldlen = this.ds.length;
        DrawableSequence[] newds = new DrawableSequence[this.ds.length + s.length];
        int i = 0;
        while (i < oldlen && this.ds[i] != null) {
            newds[i] = this.ds[i];
            ++i;
        }
        oldlen = i;
        System.out.println(String.valueOf(oldlen) + " " + i + " " + s.length);
        while (i < newds.length && i - oldlen < s.length && s[i - oldlen] != null) {
            System.out.println(String.valueOf(oldlen) + " " + i + " " + s.length);
            newds[i] = s[i - oldlen];
            ++i;
        }
        this.ds = newds;
        this.sequences = newds;
        this.size = this.size();
    }

    public void addSequence(DrawableSequence news) {
        DrawableSequence[] newds = new DrawableSequence[this.ds.length + 1];
        int i = 0;
        while (i < this.ds.length && this.ds[i] != null) {
            newds[i] = this.ds[i];
            ++i;
        }
        newds[i] = news;
        this.ds = newds;
        this.sequences = newds;
        this.size = this.size();
    }

    public void sortByTree(TreeFile tf) {
        DrawableSequence[] newds = new DrawableSequence[this.ds.length];
        Vector tmp = new Vector();
        tmp = this._sortByTree(tf.top, tmp);
        int i = 0;
        while (i < tmp.size()) {
            newds[i] = (DrawableSequence)tmp.elementAt(i);
            ++i;
        }
        this.sequences = newds;
        this.ds = newds;
    }

    public Vector _sortByTree(SequenceNode node, Vector tmp) {
        if (node == null) {
            return tmp;
        }
        if (node.left == null && node.right == null) {
            if (node.element instanceof DrawableSequence) {
                tmp.addElement((DrawableSequence)node.element);
                return tmp;
            }
        } else {
            this._sortByTree((SequenceNode)node.left, tmp);
            this._sortByTree((SequenceNode)node.right, tmp);
        }
        return tmp;
    }

    public void sortByGroup() {
        DrawableSequence[] newds = new DrawableSequence[this.ds.length];
        int count = 0;
        int i = 0;
        while (i < this.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.groups.elementAt(i);
            int j = 0;
            while (j < sg.sequences.size()) {
                newds[count] = (DrawableSequence)sg.sequences.elementAt(j);
                ++count;
                ++j;
            }
            ++i;
        }
        this.ds = newds;
        this.sequences = newds;
    }

    public void trimLeft(int i) {
        super.trimLeft(i);
        int j = 0;
        while (j < this.size) {
            int k = 0;
            while (k < i) {
                if (this.ds[j].textColour.size() > k) {
                    this.ds[j].textColour.removeElementAt(0);
                }
                if (this.ds[j].boxColour.size() > k) {
                    this.ds[j].boxColour.removeElementAt(0);
                }
                int l = 0;
                while (l < this.ds[j].score.length && this.ds[j].score[l] != null) {
                    if (this.ds[j].score[l].size() > k) {
                        this.ds[j].score[l].removeElementAt(0);
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
    }

    public void deleteSequence(Sequence s) {
        int i = 0;
        while (i < this.size) {
            if (this.ds[i] == s) {
                this.deleteSequence(i);
            }
            ++i;
        }
    }

    public void deleteSequence(int i) {
        int k = 0;
        while (k < this.groups.size()) {
            if (((SequenceGroup)this.groups.elementAt((int)k)).sequences.contains(this.sequences[i])) {
                ((SequenceGroup)this.groups.elementAt((int)k)).sequences.removeElement(this.sequences[i]);
            }
            ++k;
        }
        int j = i + 1;
        while (j < this.size()) {
            this.sequences[j - 1] = this.sequences[j];
            this.ds[j - 1] = this.ds[j];
            ++j;
        }
        this.ds[this.size - 1] = null;
        this.sequences[this.size - 1] = null;
        this.size = this.size();
    }

    public void removeGappedColumns() {
        Vector<String> v = new Vector<String>(this.maxLength());
        int i = 0;
        while (i < this.maxLength()) {
            boolean gap = true;
            int j = 0;
            while (j < this.ds.length) {
                String tmp;
                if (!(this.ds[j] == null || (tmp = this.ds[j].sequence.substring(i, i + 1)).equals("-") || tmp.equals(".") || tmp.equals(" "))) {
                    gap = false;
                    break;
                }
                ++j;
            }
            if (gap) {
                v.addElement("0");
            } else {
                v.addElement("1");
            }
            ++i;
        }
        int j = 0;
        while (j < v.size()) {
            if ((String)v.elementAt(j) == "0") {
                this.deleteColumns(j, j);
                v.removeElementAt(j);
                --j;
            }
            ++j;
        }
    }

    public void deleteColumns(int start, int end) {
        super.deleteColumns(start, end);
        int i = 0;
        System.out.println("*********** in deletreColumns ***********");
        while (i < this.ds.length && this.ds[i] != null) {
            int j = start;
            while (j <= end) {
                int l = 0;
                while (this.ds[i].score != null && l < this.ds[i].score.length && this.ds[i].score[l] != null) {
                    if (this.ds[i].score[l].size() > start) {
                        this.ds[i].score[l].removeElementAt(start);
                    }
                    ++l;
                }
                ++j;
            }
            ++i;
        }
    }

    public void colourText(SequenceGroup sg) {
        int j = 0;
        while (j < sg.sequences.size()) {
            DrawableSequence s = (DrawableSequence)sg.sequences.elementAt(j);
            s.colourText = sg.colourText;
            ++j;
        }
    }

    public void displayText(SequenceGroup sg) {
        int j = 0;
        while (j < sg.sequences.size()) {
            DrawableSequence s = (DrawableSequence)sg.sequences.elementAt(j);
            s.displayText = sg.displayText;
            ++j;
        }
    }

    public void displayBoxes(SequenceGroup sg) {
        int j = 0;
        while (j < sg.sequences.size()) {
            DrawableSequence s = (DrawableSequence)sg.sequences.elementAt(j);
            s.displayBoxes = sg.displayBoxes;
            ++j;
        }
    }

    public void setColourScheme(SequenceGroup sg) {
        sg.colourScheme.setColours(sg);
    }

    public void setColourScheme(ColourScheme colourScheme) {
        int i = 0;
        while (i < this.groups.size()) {
            SequenceGroup sg = (SequenceGroup)this.groups.elementAt(i);
            sg.colourScheme = colourScheme;
            System.out.println("Setting colour scheme for " + i);
            sg.colourScheme.setColours(sg);
            ++i;
        }
    }

    public int maxIdLength(FontMetrics fm) {
        int i = 0;
        int max = 0;
        while (i < this.sequences.length && this.sequences[i] != null) {
            Sequence s = this.sequences[i];
            String tmp = String.valueOf(s.getName()) + "/" + s.start + "-" + s.end;
            if (fm.stringWidth(tmp) > max) {
                max = fm.stringWidth(tmp);
            }
            ++i;
        }
        return max;
    }

    public void trimRight(int i) {
        super.trimRight(i);
        int j = 0;
        while (j < this.size) {
            int k = i + 1;
            while (k < this.ds[j].sequence.length()) {
                if (this.ds[j].textColour.size() > i + 1) {
                    this.ds[j].textColour.removeElementAt(i + 1);
                }
                if (this.ds[j].boxColour.size() > i + 1) {
                    this.ds[j].boxColour.removeElementAt(i + 1);
                }
                int l = 0;
                while (l < this.ds[j].score.length && this.ds[j].score[l] != null) {
                    if (this.ds[j].score[l].size() > i + 1) {
                        this.ds[j].score[l].removeElementAt(i + 1);
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
    }
}

