/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignSeq;
import jalview.FastaFile;
import jalview.Format;
import jalview.ResidueProperties;
import jalview.Sequence;

public class EstAlign
extends AlignSeq {
    int[] donor = this.findDonors();
    int[] acceptor = this.findAcceptors();
    int[][] G;
    int intronExon = 500;
    int splice = 100;

    public EstAlign(Sequence s1, Sequence s2, String type) {
        super(s1, s2, type);
    }

    public int[] findDonors() {
        int[] donor = new int[this.s1str.length()];
        int i = 0;
        while (i < this.s1str.length() - 1) {
            donor[i] = this.s1str.substring(i, i + 2).equals("GT") ? 0 : 1;
            ++i;
        }
        donor[this.seq1.length - 1] = 1;
        return donor;
    }

    public int[] findAcceptors() {
        int[] acceptor = new int[this.s1str.length()];
        acceptor[0] = 1;
        int i = 1;
        while (i < this.s1str.length()) {
            acceptor[i] = this.s1str.substring(i - 1, i + 1).equals("AG") ? 0 : 1;
            ++i;
        }
        return acceptor;
    }

    public void calcScoreMatrix() {
        int n = this.seq1.length;
        int m = this.seq2.length;
        this.G = new int[n][m];
        this.score[0][0] = this.lookup[this.seq1[0]][this.seq2[0]] * 10;
        this.E[0][0] = 0;
        this.F[0][0] = 0;
        this.G[0][0] = 0;
        int j = 1;
        while (j < m) {
            this.E[0][j] = this.max(this.score[0][j - 1] - this.gapOpen, this.E[0][j - 1] - this.gapExtend);
            this.F[0][j] = 0;
            this.G[0][j] = 0;
            this.score[0][j] = this.max(this.lookup[this.seq1[0]][this.seq2[j]] * 10, -this.gapOpen, -this.gapExtend);
            ++j;
        }
        int i = 1;
        while (i < n) {
            this.E[i][0] = 0;
            this.F[i][0] = this.max(this.score[i - 1][0] - this.gapOpen, this.F[i - 1][0] - this.gapExtend);
            this.G[i][0] = this.max(this.score[i - 1][0] - this.donor[i] * this.intronExon - this.splice, this.G[i - 1][0], this.G[i - 1][0] - this.acceptor[i] * this.intronExon - this.splice + this.lookup[this.seq1[i]][this.seq2[0]] * 10);
            this.score[i][0] = this.max(this.lookup[this.seq1[i]][this.seq2[0]] * 10, this.E[i][0], this.F[i][0], this.G[i][0]);
            ++i;
        }
        i = 1;
        while (i < n) {
            int j2 = 1;
            while (j2 < m) {
                this.E[i][j2] = this.max(this.score[i][j2 - 1] - this.gapOpen, this.E[i][j2 - 1] - this.gapExtend);
                this.F[i][j2] = this.max(this.score[i - 1][j2] - this.gapOpen, this.F[i - 1][j2] - this.gapExtend);
                this.G[i][j2] = this.max(this.score[i - 1][j2] - this.donor[i] * this.intronExon - this.splice, this.G[i - 1][j2], this.G[i - 1][j2] - this.acceptor[i] * this.intronExon - this.splice + this.lookup[this.seq1[i]][this.seq2[j2]] * 10);
                this.score[i][j2] = this.max(this.score[i - 1][j2 - 1] + this.lookup[this.seq1[i]][this.seq2[j2]] * 10, this.E[i][j2], this.F[i][j2], this.G[i][j2]);
                ++j2;
            }
            ++i;
        }
    }

    public void traceAlignment() {
        int max = -9999;
        int i = 0;
        while (i < this.seq1.length) {
            if (this.score[i][this.seq2.length - 1] > max) {
                max = this.score[i][this.seq2.length - 1];
                this.maxi = i;
                this.maxj = this.seq2.length - 1;
            }
            ++i;
        }
        int j = 0;
        while (j < this.seq2.length) {
            if (this.score[this.seq1.length - 1][j] > max) {
                max = this.score[this.seq1.length - 1][j];
                this.maxi = this.seq1.length - 1;
                this.maxj = j;
            }
            ++j;
        }
        i = this.maxi;
        int j2 = this.maxj;
        this.maxscore = this.score[i][j2] / 10;
        this.seq1end = this.maxi + 1;
        this.seq2end = this.maxj + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        this.count = this.seq1.length + this.seq2.length - 1;
        while (i > 0 && j2 > 0) {
            int trace;
            if (this.aseq1[this.count] != this.defInt && i >= 0) {
                this.aseq1[this.count] = this.seq1[i];
                this.astr1 = String.valueOf(this.intToStr[this.seq1[i]]) + this.astr1;
            }
            if (this.aseq2[this.count] != this.defInt && j2 > 0) {
                this.aseq2[this.count] = this.seq2[j2];
                this.astr2 = String.valueOf(this.intToStr[this.seq2[j2]]) + this.astr2;
            }
            if ((trace = this.findTrace(i, j2)) == 0) {
                --i;
                --j2;
            } else if (trace == 1) {
                --j2;
                this.aseq1[this.count] = this.defInt;
                this.astr1 = "*" + this.astr1.substring(1);
            } else if (trace == -1 || trace == -2) {
                --i;
                this.aseq2[this.count] = this.defInt;
                this.astr2 = trace == -1 ? "." + this.astr2.substring(1) : "^" + this.astr2.substring(1);
            }
            --this.count;
        }
        this.seq1start = i + 1;
        this.seq2start = j2 + 1;
        if (this.aseq1[this.count] != this.defInt) {
            this.aseq1[this.count] = this.seq1[i];
            this.astr1 = String.valueOf(this.intToStr[this.seq1[i]]) + this.astr1;
        }
        if (this.aseq2[this.count] != this.defInt) {
            this.aseq2[this.count] = this.seq2[j2];
            this.astr2 = String.valueOf(this.intToStr[this.seq2[j2]]) + this.astr2;
        }
    }

    public int findTrace(int i, int j) {
        int t = 0;
        int max = this.score[i - 1][j - 1] + this.lookup[this.seq1[i]][this.seq2[j]] * 10;
        if (this.G[i][j] > max) {
            max = this.G[i][j];
            t = -2;
            this.prev = -2;
        } else if (this.G[i][j] == max && this.prev == -2) {
            max = this.G[i][j];
            t = -2;
            this.prev = -2;
        }
        if (this.F[i][j] > max) {
            max = this.F[i][j];
            t = -1;
            this.prev = -1;
        } else if (this.F[i][j] == max && this.prev == -1) {
            max = this.F[i][j];
            t = -1;
            this.prev = -1;
        }
        if (this.E[i][j] >= max) {
            max = this.E[i][j];
            t = 1;
            this.prev = 1;
        } else if (this.E[i][j] == max && this.prev == 1) {
            max = this.E[i][j];
            t = 1;
            this.prev = 1;
        }
        return t;
    }

    public void printAlignment() {
        int maxid = this.s1.getName().length();
        if (this.s2.getName().length() > maxid) {
            maxid = this.s2.getName().length();
        }
        int len = 72 - maxid - 1;
        int nochunks = (this.aseq1.length - this.count) / len + 1;
        this.pid = 0.0f;
        this.output = String.valueOf(this.output) + "Score = " + this.score[this.maxi][this.maxj] + "\n";
        this.output = String.valueOf(this.output) + "Length of alignment = " + (this.aseq1.length - this.count) + "\n";
        this.output = String.valueOf(this.output) + "Sequence ";
        this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s1.getName());
        this.output = String.valueOf(this.output) + " :  " + this.seq1start + " - " + this.seq1end + " (Sequence length = " + this.s1str.length() + ")\n";
        this.output = String.valueOf(this.output) + "Sequence ";
        this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s2.getName());
        this.output = String.valueOf(this.output) + " :  " + this.seq2start + " - " + this.seq2end + " (Sequence length = " + this.s2str.length() + ")\n\n";
        int j = 0;
        while (j < nochunks) {
            this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s1.getName()) + " ";
            int i = 0;
            while (i < len) {
                if (this.count + i + j * len < this.aseq1.length) {
                    this.output = String.valueOf(this.output) + new Format("%s").form(this.intToStr[this.aseq1[this.count + i + j * len]]);
                }
                ++i;
            }
            this.output = String.valueOf(this.output) + "\n";
            this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(" ") + " ";
            i = 0;
            while (i < len) {
                if (this.count + i + j * len < this.aseq1.length) {
                    if (this.intToStr[this.aseq1[this.count + i + j * len]].equals(this.intToStr[this.aseq2[this.count + i + j * len]]) && !this.intToStr[this.aseq1[this.count + i + j * len]].equals("-")) {
                        this.pid += 1.0f;
                        this.output = String.valueOf(this.output) + "|";
                    } else {
                        this.output = this.type.equals("pep") ? (ResidueProperties.getPAM250(this.intToStr[this.aseq1[this.count + i + j * len]], this.intToStr[this.aseq2[this.count + i + j * len]]) > 0 ? String.valueOf(this.output) + "." : String.valueOf(this.output) + " ") : String.valueOf(this.output) + " ";
                    }
                }
                ++i;
            }
            this.output = String.valueOf(this.output) + "\n";
            this.output = String.valueOf(this.output) + new Format("%" + maxid + "s").form(this.s2.getName()) + " ";
            i = 0;
            while (i < len) {
                this.aseq1.getClass();
                ++i;
            }
            this.output = (j + 1) * len < this.astr2.length() ? String.valueOf(this.output) + this.astr2.substring(j * len, (j + 1) * len) : String.valueOf(this.output) + this.astr2.substring(j * len);
            this.output = String.valueOf(this.output) + "\n\n";
            ++j;
        }
        this.pid = this.pid / (float)(this.aseq1.length - this.count) * 100.0f;
        this.output = String.valueOf(this.output) + new Format("Percentage ID = %2.2f\n\n").form(this.pid);
    }

    public int max(int i1, int i2, int i3, int i4) {
        int max = i1;
        if (i2 > i1) {
            max = i2;
        }
        if (i3 > max) {
            max = i3;
        }
        if (i4 > max) {
            return i4;
        }
        return max;
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("args: <dnafile1> <dnafile2> ");
                System.exit(0);
            }
            Sequence[] s = new Sequence[2];
            FastaFile fa = new FastaFile(args[0], "File");
            s[0] = (Sequence)fa.seqs.elementAt(0);
            FastaFile fa2 = new FastaFile(args[1], "File");
            s[1] = (Sequence)fa2.seqs.elementAt(0);
            EstAlign as = new EstAlign(s[0], s[1], "dna");
            as.gapExtend = 50;
            as.gapOpen = 100;
            as.calcScoreMatrix();
            as.traceAlignment();
            as.printAlignment();
            s[0] = new Sequence(as.s1.getName(), as.astr1, 0, 0);
            s[1] = new Sequence(as.s2.getName(), as.astr2, 0, 0);
            System.out.println(String.valueOf(as.output) + "\nScore = " + as.maxscore);
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }
}

