/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.DrawableAlignment;
import jalview.IdPanel;
import jalview.ScoreSequence;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class IdCanvas
extends Canvas {
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    Font f;
    int charWidth;
    int charHeight;
    int idWidth = 120;
    protected IdPanel idPanel;
    boolean paintFlag = false;
    public boolean showScores = true;
    DrawableAlignment da;
    int starty;
    int endy;

    public IdCanvas(IdPanel idPanel) {
        this.idPanel = idPanel;
    }

    public boolean keyDown(Event evt, int key) {
        this.requestFocus();
        return false;
    }

    public void paint(Graphics g) {
        if (this.img == null || this.imgWidth != this.size().width || this.imgHeight != this.size().height || this.paintFlag) {
            this.da = this.idPanel.alignPanel.seqPanel.align;
            this.imgWidth = this.size().width;
            this.idWidth = this.size().width;
            FontMetrics fm = g.getFontMetrics(this.idPanel.alignPanel.seqPanel.seqCanvas.f);
            this.idWidth = this.idPanel.alignPanel.seqPanel.align.maxIdLength(fm) + 2;
            this.imgHeight = this.size().height;
            if (this.imgWidth < 0) {
                this.imgWidth = 700;
            }
            if (this.imgHeight < 0) {
                this.imgHeight = 500;
            }
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setColor(Color.white);
            this.gg.fillRect(0, 0, this.imgWidth, this.imgHeight);
            this.f = this.idPanel.alignPanel.seqPanel.seqCanvas.f;
            this.gg.setFont(this.f);
            fm = this.gg.getFontMetrics(this.f);
            this.charWidth = fm.charWidth('W');
            this.charHeight = this.setCharHeight(fm, this.showScores);
            this.paintFlag = false;
        }
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.imgWidth, this.imgHeight);
        this.gg.setColor(Color.black);
        this.starty = this.idPanel.alignPanel.seqPanel.offy;
        this.endy = this.getEndy();
        if (this.starty < 0) {
            this.starty = 0;
        }
        int i = this.starty;
        while (i < this.endy) {
            if (this.idPanel.alignPanel.sel.contains(this.idPanel.alignPanel.seqPanel.align.ds[i])) {
                this.gg.setColor(Color.gray);
                this.gg.fillRect(0, this.da.getHeight(this.starty, i), this.size().width, this.da.ds[i].charHeight);
                this.gg.setColor(Color.white);
            } else {
                this.gg.setColor(this.idPanel.alignPanel.seqPanel.align.ds[i].getColor());
                this.gg.fillRect(0, this.da.getHeight(this.starty, i), this.size().width, this.da.ds[i].charHeight);
                this.gg.setColor(Color.black);
            }
            String string = String.valueOf(this.idPanel.alignPanel.seqPanel.align.ds[i].getName()) + "/" + this.idPanel.alignPanel.seqPanel.align.ds[i].start + "-" + this.idPanel.alignPanel.seqPanel.align.ds[i].end;
            if (this.showScores) {
                this.gg.drawString(string, 0, this.da.getHeight(this.starty, i) + this.da.ds[i].charHeight / 2 - 2);
            } else {
                this.gg.drawString(string, 0, this.da.getHeight(this.starty, i) + this.da.ds[i].charHeight - 2);
            }
            ++i;
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public int setCharHeight(FontMetrics fm, boolean showScores) {
        int height = fm.getHeight();
        if (this.idPanel.alignPanel.seqPanel.align instanceof DrawableAlignment) {
            this.da = this.idPanel.alignPanel.seqPanel.align;
            int i = 0;
            while (i < this.da.ds.length && this.da.ds[i] != null) {
                this.da.ds[i].charHeight = this.da.ds[i] instanceof ScoreSequence ? height * 3 : (showScores ? height * 2 : height);
                ++i;
            }
        }
        if (showScores) {
            return fm.getHeight() * 2;
        }
        return fm.getHeight();
    }

    public int getEndy() {
        int out = this.idPanel.alignPanel.seqPanel.seqCanvas.getEndy();
        this.starty = this.idPanel.alignPanel.seqPanel.seqCanvas.starty;
        return out;
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public int maxIdLength() {
        DrawableAlignment al = this.idPanel.alignPanel.seqPanel.align;
        int max = 0;
        int i = 0;
        while (i < al.ds.length && al.ds[i] != null) {
            if (al.ds[i].getName().length() > max) {
                max = al.ds[i].getName().length();
            }
            ++i;
        }
        return max;
    }
}

