/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.PCA;
import jalview.RotatableCanvas;
import jalview.Sequence;
import jalview.SequencePoint;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Vector;

public class PCAPanel
extends Panel {
    PCA pca;
    Object parent;
    int top;
    RotatableCanvas rc;
    Choice cx;
    Choice cy;
    Choice cz;
    Button b;

    public PCAPanel(Object parent, PCA pca) {
        this(parent, pca, null);
    }

    public PCAPanel(Object parent, PCA pca, Sequence[] s) {
        this.parent = parent;
        this.pca = pca;
        Panel p1 = new Panel();
        Panel p2 = new Panel();
        Panel p3 = new Panel();
        Panel p4 = new Panel();
        Label l1 = new Label("x = ");
        Label l2 = new Label("y = ");
        Label l3 = new Label("z = ");
        this.b = new Button("Close");
        this.cx = new Choice();
        this.cy = new Choice();
        this.cz = new Choice();
        this.addItems(this.cx);
        this.addItems(this.cy);
        this.addItems(this.cz);
        this.cx.select(1);
        this.cy.select(2);
        this.cz.select(3);
        this.top = pca.m.rows - 1;
        Vector<SequencePoint> points = new Vector<SequencePoint>();
        float[][] scores = pca.getComponents(this.top - 1, this.top - 2, this.top - 3, 100.0f);
        int i = 0;
        while (i < pca.m.rows) {
            SequencePoint sp = new SequencePoint(s[i], scores[i]);
            points.addElement(sp);
            ++i;
        }
        this.rc = new RotatableCanvas(parent, points, pca.m.rows);
        this.rc.printPoints();
        p1.setLayout(new BorderLayout());
        p1.add("Center", this.rc);
        p2.setLayout(new FlowLayout());
        p2.add(l1);
        p2.add(this.cx);
        p2.add(l2);
        p2.add(this.cy);
        p2.add(l3);
        p2.add(this.cz);
        p3.add(this.b);
        p4.setLayout(new GridLayout(2, 1));
        p4.add(p2);
        p4.add(p3);
        this.setLayout(new BorderLayout());
        this.add("Center", p1);
        this.add("South", p4);
    }

    public boolean action(Event evt, Object arg) {
        boolean newdim = false;
        if (evt.target.equals(this.cx)) {
            newdim = true;
        } else if (evt.target.equals(this.cy)) {
            newdim = true;
        } else if (evt.target.equals(this.cz)) {
            newdim = true;
        } else if (evt.target.equals(this.b)) {
            this.hide();
            if (this.getParent() instanceof Frame) {
                ((Frame)this.getParent()).dispose();
            }
        }
        if (newdim) {
            int dim1 = this.top - this.cx.getSelectedIndex();
            int dim2 = this.top - this.cy.getSelectedIndex();
            int dim3 = this.top - this.cz.getSelectedIndex();
            float[][] scores = this.pca.getComponents(dim1, dim2, dim3, 100.0f);
            int i = 0;
            while (i < this.pca.m.rows) {
                ((SequencePoint)this.rc.points.elementAt((int)i)).coord = scores[i];
                ++i;
            }
            this.rc.img = null;
            this.rc.rotmat.setIdentity();
            this.rc.initAxes();
            this.rc.paint(this.rc.getGraphics());
            return true;
        }
        return false;
    }

    public boolean keyDown(Event evt, int key) {
        if (key == 1004 || key == 1005) {
            return this.rc.keyDown(evt, key);
        }
        if (key == 115) {
            return this.rc.keyDown(evt, key);
        }
        return super.keyDown(evt, key);
    }

    public void addItems(Choice c) {
        c.addItem("dim 1");
        c.addItem("dim 2");
        c.addItem("dim 3");
        c.addItem("dim 4");
        c.addItem("dim 5");
        c.addItem("dim 6");
        c.addItem("dim 7");
    }
}

