/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableSequence;
import jalview.PCA;
import jalview.PCAFrame;
import jalview.PCAPanel;
import java.awt.BorderLayout;

public class PCAThread
extends Thread {
    DrawableSequence[] s;
    Object parent;
    PCA pca;
    PCAPanel p;
    boolean calculated = false;

    public PCAThread(Object parent, DrawableSequence[] s) {
        this.s = s;
        this.parent = parent;
    }

    public void run() {
        this.pca = new PCA(this.s);
        this.pca.run();
        this.calculated = true;
        if (this.parent instanceof AlignFrame) {
            ((AlignFrame)this.parent).status.setText("Finished PCA calculation");
            ((AlignFrame)this.parent).status.validate();
        }
        int ii = 0;
        while (ii < this.s.length && this.s[ii] != null) {
            ++ii;
        }
        double[][] comps = new double[ii][ii];
        int i = 0;
        while (i < ii) {
            if (this.pca.eigenvector.d[i] > 1.0E-4) {
                comps[i] = this.pca.component(i);
            }
            ++i;
        }
        PCAFrame f = new PCAFrame("PCA results", this.parent);
        f.setLayout(new BorderLayout());
        this.p = new PCAPanel(this.parent, this.pca, this.s);
        f.add("Center", this.p);
        f.resize(400, 400);
        f.show();
    }
}

