/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.CGI;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.PIDColourScheme;
import jalview.PfamFile;
import jalview.Sequence;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;

public class PostalCGI
extends CGI {
    Sequence[] sequence;

    public PostalCGI(String server, int port, String location, Sequence[] sequence, PrintStream statout) {
        super(server, port, location, statout);
        this.sequence = sequence;
        this.variables = this.makeVariables();
    }

    public Hashtable makeVariables() {
        String seq2 = PfamFile.print(this.sequence);
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("sequence", seq2);
        return h;
    }

    public void readInput(DataInputStream in) {
        String aln = "";
        String outstr = "";
        try {
            while ((aln = in.readLine()) != null) {
                outstr = String.valueOf(outstr) + aln + "\n";
                this.statout.println(aln);
            }
            this.statout.print(outstr);
            DrawableSequence[] ds = FormatAdapter.toDrawableSequence(FormatAdapter.read("POSTAL", outstr));
            AlignFrame af = new AlignFrame((Object)"Null", ds);
            af.scores.setState(true);
            af.ap.seqPanel.seqCanvas.showScores = true;
            af.ap.idPanel.idCanvas.showScores = true;
            af.ap.seqPanel.align.percentIdentity();
            af.cons = af.ap.seqPanel.align.cons;
            af.resize(700, 500);
            af.ap.setSequenceColor(new PIDColourScheme(af.cons));
            af.show();
            af.updateFont();
            af.updateFont();
        }
        catch (IOException ioex) {
            System.out.println("Exception " + ioex);
        }
    }

    public static void main(String[] args) {
        Sequence[] seqs = FormatAdapter.toDrawableSequence(FormatAdapter.read(args[0], "File", args[1]));
        PostalCGI cwcgi = new PostalCGI("circinus.ebi.ac.uk", 6543, "/cgi-bin/runpostal", seqs, System.out);
        cwcgi.run();
    }
}

