/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.DrawableAlignment;
import jalview.Format;
import jalview.PostscriptProperties;
import jalview.ResidueProperties;
import jalview.SequenceGroup;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;

public class Postscript {
    AlignFrame af;
    DrawableAlignment al;
    int noseqs;
    float boxsize;
    float yspace;
    int ygap;
    int maxseqlen;
    int maxidlen;
    StringBuffer out;
    BufferedWriter sw;
    PrintStream ps;
    Color lightBlue = new Color(175, 175, 255);
    Color midBlue = new Color(110, 110, 255);
    float xorig;
    float xtext;
    float ytext;
    float seqstart;
    int orient;
    int fontsize;
    int xmargin;
    int ymargin;
    int paperwidth;
    int paperheight;
    String font;
    boolean makeString;

    public Postscript(AlignFrame af, BufferedWriter sw) {
        this.af = af;
        this.al = af.ap.seqPanel.align;
        this.orient = af.pp.orientation;
        this.font = af.pp.font;
        this.fontsize = af.pp.fsize;
        this.xmargin = af.pp.xoffset;
        this.ymargin = af.pp.yoffset;
        this.ygap = 30;
        this.sw = sw;
    }

    public Postscript(AlignFrame af, PrintStream ps) {
        this.af = af;
        this.al = af.ap.seqPanel.align;
        this.orient = af.pp.orientation;
        this.out = new StringBuffer();
        this.font = af.pp.font;
        this.fontsize = af.pp.fsize;
        this.xmargin = af.pp.xoffset;
        this.ymargin = af.pp.yoffset;
        this.ygap = 30;
        this.ps = ps;
    }

    public Postscript(AlignFrame af, boolean buffer) {
        if (buffer) {
            this.makeString = true;
            this.af = af;
            this.al = af.ap.seqPanel.align;
            this.orient = af.pp.orientation;
            this.out = new StringBuffer();
            this.font = af.pp.font;
            this.fontsize = af.pp.fsize;
            this.xmargin = af.pp.xoffset;
            this.ymargin = af.pp.yoffset;
            this.ygap = 30;
        }
    }

    public void print(String s) throws IOException {
        if (this.sw != null) {
            this.sw.write(s);
        }
        if (this.ps != null) {
            this.ps.print(s);
        }
        if (this.makeString) {
            this.out.append(s);
        }
    }

    public void generate() {
        this.af.getClass();
        if (this.orient == PostscriptProperties.PORTRAIT) {
            this.af.getClass();
            this.paperwidth = PostscriptProperties.SHORTSIDE;
            this.af.getClass();
            this.paperheight = PostscriptProperties.LONGSIDE;
        } else {
            this.af.getClass();
            this.paperwidth = PostscriptProperties.LONGSIDE;
            this.af.getClass();
            this.paperheight = PostscriptProperties.SHORTSIDE;
        }
        this.noseqs = this.al.size();
        int seqlen = this.al.maxLength();
        this.maxidlen = this.al.maxIdLength();
        this.boxsize = (float)((double)this.fontsize * 1.1);
        this.yspace = this.af.ap.seqPanel.seqCanvas.showScores ? this.boxsize * 2.0f : this.boxsize;
        this.seqstart = (float)((double)(this.boxsize * (float)this.maxidlen) * 0.7 + (double)this.xmargin);
        int nocharx = (int)(((float)this.paperwidth - this.seqstart - (float)(2 * this.xmargin)) / this.boxsize);
        int cfr_ignored_0 = (int)((float)(this.paperheight - 2 * this.ymargin) / this.yspace);
        float aligny = 2.0f * this.boxsize + (float)this.noseqs * this.yspace;
        int noalign = (int)((float)(this.paperheight - this.ymargin) / (aligny + (float)this.ymargin));
        this.printinit();
        int page = 1;
        float yoffset = 0.0f;
        int aligncount = 0;
        try {
            int i = 0;
            while (i < seqlen) {
                float yorig;
                if (i % nocharx == 0) {
                    if (noalign > 1 && aligncount < noalign && aligncount != 0) {
                        yoffset = (float)aligncount * (aligny + 30.0f);
                        ++aligncount;
                    } else {
                        yoffset = 0.0f;
                        aligncount = 1;
                        if (page > 1) {
                            this.print("\nshowpage\n");
                        }
                        this.print("\n%%Page: ? " + page + "\n");
                        if (this.paperwidth > this.paperheight) {
                            this.af.getClass();
                            this.print(String.valueOf(PostscriptProperties.SHORTSIDE) + " 0 translate\n90 rotate\n");
                        }
                        this.print("gsave\n");
                        this.print("/Times-Roman findfont\n");
                        this.print("8 scalefont\n");
                        this.print(String.valueOf(this.xmargin) + " " + this.ymargin + " moveto\n");
                        this.print("(Jalview Michele Clamp 1998) show\n");
                        this.print("grestore\n");
                        ++page;
                        if (this.sw != null) {
                            this.sw.flush();
                        }
                    }
                    this.print("black setrgbcolor\n");
                    int k = 0;
                    while (k < this.noseqs) {
                        String id = this.al.sequences[k].getName();
                        yorig = (float)(this.paperheight - this.ymargin) - this.boxsize - (float)k * this.yspace - yoffset;
                        this.ytext = this.af.ap.seqPanel.seqCanvas.showScores ? (float)((double)(yorig + this.yspace / 2.0f) + 0.2 * (double)this.boxsize) : (float)((double)yorig + 0.2 * (double)this.boxsize);
                        this.print("(" + id + ") " + this.xmargin + " " + this.ytext + " moveto show\n");
                        ++k;
                    }
                }
                int ii = i % nocharx;
                this.xorig = (float)ii * this.boxsize + this.seqstart;
                this.xtext = (float)((double)this.xorig + 0.12 * (double)this.boxsize);
                if (i % 10 == 9 && i != 0) {
                    float ylabel1 = (float)((double)(this.paperheight - this.ymargin) + 0.2 * (double)this.boxsize - (double)yoffset);
                    float ylabel2 = (float)((double)(this.paperheight - this.ymargin) + 1.2 * (double)this.boxsize - (double)yoffset);
                    float x1 = (float)((double)this.xorig + 0.4 * (double)this.boxsize);
                    int num = i + 1;
                    this.print("black setrgbcolor\n");
                    this.print("(|) " + x1 + " " + ylabel1 + " moveto show\n");
                    this.print("(" + num + ") " + this.xtext + " " + ylabel2 + " moveto show\n");
                }
                int j = 0;
                while (j < this.noseqs) {
                    int score;
                    this.al.sequences[j].getName();
                    yorig = (float)(this.paperheight - this.ymargin) - this.boxsize - (float)j * this.yspace - yoffset;
                    this.ytext = this.af.ap.seqPanel.seqCanvas.showScores ? (float)((double)(yorig + this.yspace / 2.0f) + 0.2 * (double)this.boxsize) : (float)((double)yorig + 0.2 * (double)this.boxsize);
                    String s = " ";
                    if (i < this.al.sequences[j].getSequence().length()) {
                        s = this.al.sequences[j].getSequence().substring(i, i + 1);
                    } else if (i == this.al.sequences[j].getSequence().length()) {
                        s = this.al.sequences[j].getSequence().substring(i);
                    }
                    try {
                        ((Integer)ResidueProperties.aaHash.get(s)).intValue();
                    }
                    catch (Exception exception) {}
                    SequenceGroup sg = this.al.findGroup(j);
                    Color c = Color.white;
                    if (sg.displayBoxes) {
                        c = this.findBoxColor(i, j, s);
                    }
                    Format ff = new Format("%6.3f");
                    String red = ff.form((float)((double)c.getRed() / 256.0));
                    String green = ff.form((float)((double)c.getGreen() / 256.0));
                    String blue = ff.form((float)((double)c.getBlue() / 256.0));
                    if (!sg.displayText) {
                        s = " ";
                    }
                    if (sg.colourText) {
                        Color tcolor = this.findTextColor(i, j, s);
                        String tred = ff.form((float)((double)tcolor.getRed() / 256.0));
                        String tgreen = ff.form((float)((double)tcolor.getGreen() / 256.0));
                        String tblue = ff.form((float)((double)tcolor.getBlue() / 256.0));
                        if (this.af.ap.seqPanel.seqCanvas.showScores) {
                            this.print("(" + s + ") " + this.xtext + " " + this.ytext + " " + tred + " " + tgreen + " " + tblue + " " + red + " " + green + " " + blue + " " + this.xorig + " " + (yorig + this.boxsize) + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                        } else {
                            this.print("(" + s + ") " + this.xtext + " " + this.ytext + " " + tred + " " + tgreen + " " + tblue + " " + red + " " + green + " " + blue + " " + this.xorig + " " + yorig + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                        }
                    } else if (this.af.ap.seqPanel.seqCanvas.showScores) {
                        this.print("(" + s + ") " + this.xtext + " " + this.ytext + " black " + red + " " + green + " " + blue + " " + this.xorig + " " + (yorig + this.boxsize) + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                    } else {
                        this.print("(" + s + ") " + this.xtext + " " + this.ytext + " black " + red + " " + green + " " + blue + " " + this.xorig + " " + yorig + " -" + this.boxsize + " " + this.boxsize + " boxtext\n");
                    }
                    if (this.af.ap.seqPanel.seqCanvas.showScores && this.al.sequences[j].score[0] != null && this.al.sequences[j].score[0].size() > i && (score = ((Double)this.al.sequences[j].score[0].elementAt(i)).intValue()) >= 0 && score < 10) {
                        Color cc = (Color)ResidueProperties.scaleColours.elementAt(((Double)this.al.sequences[j].score[0].elementAt(i)).intValue());
                        String sred = ff.form((float)((double)cc.getRed() / 256.0));
                        String sgreen = ff.form((float)((double)cc.getGreen() / 256.0));
                        String sblue = ff.form((float)((double)cc.getBlue() / 256.0));
                        this.print("( ) " + this.xtext + " " + this.ytext + " black " + sred + " " + sgreen + " " + sblue + " " + this.xorig + " " + (yorig + this.boxsize - this.yspace / 4.0f) + " -" + this.boxsize / 2.0f + " " + this.boxsize / 2.0f + " " + this.boxsize + " recttext\n");
                    }
                    ++j;
                }
                ++i;
            }
            this.print("showpage\n");
            if (this.sw != null) {
                this.sw.flush();
            }
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
    }

    public Color findBoxColor(int i, int j, String s) {
        return (Color)this.af.ap.seqPanel.align.ds[j].boxColour.elementAt(i);
    }

    public Color findTextColor(int i, int j, String s) {
        return ((Color)this.af.ap.seqPanel.align.ds[j].boxColour.elementAt(i)).darker();
    }

    public void printinit() {
        try {
            this.print("%!\n");
            this.print("/white {1.000000 1.000000 1.000000 } def\n");
            this.print("/black {0.000000 0.000000 0.000000 } def\n");
            this.print("/gray  {0.350000 0.350000 0.350000 } def\n");
            this.print("/red  {1.00000 0.350000 0.350000 } def\n");
            this.print("/green  {0.350000 1.000000 0.350000 } def\n");
            this.print("/blue  {0.350000 0.350000 1.00000 } def\n");
            this.print("/boxtext {\n");
            this.print("/boxsize exch def\n");
            this.print("/negsize exch def\n");
            this.print("newpath\nmoveto\n\n");
            this.print("0 boxsize rlineto\n");
            this.print("boxsize 0 rlineto\n");
            this.print("0 negsize  rlineto\n");
            this.print("closepath\n");
            this.print("setrgbcolor fill setrgbcolor\n");
            this.print("moveto show\n");
            this.print("} def\n");
            this.print("/recttext {\n");
            this.print("/boxx exch def\n");
            this.print("/boxy exch def\n");
            this.print("/negy exch def\n");
            this.print("newpath\nmoveto\n\n");
            this.print("0 boxy rlineto\n");
            this.print("boxx 0 rlineto\n");
            this.print("0 negy  rlineto\n");
            this.print("closepath\n");
            this.print("setrgbcolor fill setrgbcolor\n");
            this.print("moveto show\n");
            this.print("} def\n");
            this.print("/" + this.font + " findfont\n");
            this.print(String.valueOf(this.fontsize) + " scalefont\n");
            this.print("setfont\n");
        }
        catch (Exception e) {
            System.out.println("Exception " + e);
        }
    }
}

