/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import MCview.PDBChain;
import jalview.ColourScheme;
import jalview.DrawableSequence;
import jalview.ResidueProperties;
import jalview.SequenceGroup;
import java.awt.Color;
import java.util.Hashtable;

public class ResidueColourScheme
implements ColourScheme {
    Color[] colors;
    int colourThreshold = 0;
    Hashtable[] cons;

    public ResidueColourScheme() {
    }

    public ResidueColourScheme(Color[] colors, int t) {
        this(colors, t, null);
    }

    public ResidueColourScheme(Color[] colors, int t, Hashtable[] cons) {
        this.colors = colors;
        this.colourThreshold = t;
        this.cons = cons;
    }

    public Color findColour(DrawableSequence seq2, String s, int j) {
        return this.colors[(Integer)ResidueProperties.aaHash.get(s)];
    }

    public void setColours(DrawableSequence seq2, int j) {
        Color c = Color.white;
        String s = seq2.getSequence().substring(j, j + 1);
        try {
            if (this.colourThreshold > 0 && this.cons != null) {
                if (this.aboveThreshold(seq2, j, this.colourThreshold)) {
                    c = this.findColour(seq2, s, j);
                }
            } else {
                c = this.findColour(seq2, s, j);
            }
            seq2.setResidueBoxColour(j, c);
        }
        catch (Exception exception) {
            seq2.setResidueBoxColour(j, Color.white);
        }
    }

    public void setColours(DrawableSequence s) {
        if (s.pdb != null) {
            ((PDBChain)s.pdb.chains.elementAt(s.maxchain)).colourBySequence();
        }
        int j = 0;
        while (j < s.sequence.length()) {
            this.setColours(s, j);
            ++j;
        }
    }

    public void setColours(SequenceGroup sg) {
        int j = 0;
        while (j < sg.sequences.size()) {
            DrawableSequence s = (DrawableSequence)sg.sequences.elementAt(j);
            int i = 0;
            while (i < s.getSequence().length()) {
                this.setColours(s, i);
                ++i;
            }
            if (s.pdb != null) {
                ((PDBChain)s.pdb.chains.elementAt(s.maxchain)).colourBySequence();
            }
            ++j;
        }
    }

    public boolean aboveThreshold(DrawableSequence seq2, int j, int threshold) {
        String s = seq2.getSequence().substring(j, j + 1);
        if (this.cons != null && j < this.cons.length) {
            String cfr_ignored_0 = (String)this.cons[j].get("max");
            double sc = 0.0;
            if (this.cons[j].contains(s)) {
                sc = ((Double)this.cons[j].get(s)).floatValue();
                if (!s.equals("-") && !s.equals(".") && !s.equals(" ") && sc >= (double)threshold) {
                    return true;
                }
            }
        }
        return false;
    }
}

