/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;

public class ThresholdPanel
extends Panel {
    int low;
    int high;
    Scrollbar sb;
    Label label;
    TextField tf;
    GridBagLayout gb;
    GridBagConstraints gbc;

    public ThresholdPanel(Frame parent, String label, int low, int high, int value) {
        this.low = low;
        this.high = high;
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 0;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.setLayout(this.gb);
        this.sb = new Scrollbar(0, value, (low - high) / 100, low, high + 1);
        this.label = new Label(label);
        this.tf = new TextField(new Integer(value).toString(), 3);
        this.add(this.label, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 1, 1);
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbc.fill = 2;
        this.add(this.sb, this.gb, this.gbc, 0, 1, 2, 1);
    }

    public boolean action(Event e, Object arg) {
        if (e.target == this.tf) {
            this.sb.setValue(Integer.valueOf(this.tf.getText()));
            return false;
        }
        return super.action(e, arg);
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == this.sb) {
            this.tf.setText(new Integer(this.sb.getValue()).toString());
            return super.handleEvent(evt);
        }
        return super.handleEvent(evt);
    }

    public Dimension minimumSize() {
        return new Dimension(250, 150);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void add(Component c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        this.add(c);
    }

    public static void main(String[] args) {
        Frame f = new Frame("ThresholdPanel");
        f.setSize(250, 150);
        ThresholdPanel tp = new ThresholdPanel(f, "Percent Identity", 0, 100, 80);
        f.add(tp);
        f.show();
    }
}

