/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.FormatAdapter;
import jalview.FormatProperties;
import jalview.Popup;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;

public class URLPopup
extends Popup {
    TextField tf = new TextField(40);
    Label tfLabel = new Label("URL address : ");
    Label format = new Label("Alignment format");
    Choice f = new Choice();

    public URLPopup(Frame parent, String title) {
        super(parent, title);
        int i = 0;
        while (i < FormatProperties.formats.size()) {
            this.f.addItem((String)FormatProperties.formats.elementAt(i));
            ++i;
        }
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tfLabel, this.gb, this.gbc, 0, 0, 1, 1);
        this.add(this.tf, this.gb, this.gbc, 1, 0, 4, 1);
        this.add(this.format, this.gb, this.gbc, 0, 1, 1, 1);
        this.add(this.f, this.gb, this.gbc, 1, 1, 1, 1);
        this.add(this.status, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 3, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 3, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this.apply && e.id == 1001) {
            String urlStr = this.tf.getText();
            DrawableSequence[] s = null;
            if (FormatProperties.contains(this.f.getSelectedItem())) {
                s = FormatAdapter.toDrawableSequence(FormatAdapter.read(this.f.getSelectedItem(), urlStr));
            } else {
                System.out.println("Format not supported");
            }
            if (s != null) {
                AlignFrame af = new AlignFrame(this.parent.getParent(), s);
                if (this.parent instanceof AlignFrame) {
                    AlignFrame af2 = (AlignFrame)this.parent;
                    Font f = af2.getAlignFont();
                    af.setAlignFont(f.getName(), f.getStyle(), f.getSize());
                }
                af.resize(700, 500);
                af.show();
                ConsThread ct = new ConsThread(af);
                ct.start();
                this.hide();
                this.dispose();
            } else {
                this.status.setText("Can't open URL or wrong format");
            }
            return true;
        }
        return super.handleEvent(e);
    }
}

