/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import net.sf.jazzlib.DeflaterPending;

class DeflaterHuffman {
    private static final int BUFSIZE = 16384;
    private static final int LITERAL_NUM = 286;
    private static final int DIST_NUM = 30;
    private static final int BITLEN_NUM = 19;
    private static final int REP_3_6 = 16;
    private static final int REP_3_10 = 17;
    private static final int REP_11_138 = 18;
    private static final int EOF_SYMBOL = 256;
    private static final int[] BL_ORDER;
    private static final String bit4Reverse = "\u0000\b\u0004\f\u0002\n\u0006\u000e\u0001\t\u0005\r\u0003\u000b\u0007\u000f";
    DeflaterPending pending;
    private Tree literalTree;
    private Tree distTree;
    private Tree blTree;
    private short[] d_buf;
    private byte[] l_buf;
    private int last_lit;
    private int extra_bits;
    private static short[] staticLCodes;
    private static byte[] staticLLength;
    private static short[] staticDCodes;
    private static byte[] staticDLength;

    static {
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        BL_ORDER = nArray;
        staticLCodes = new short[286];
        staticLLength = new byte[286];
        int i = 0;
        while (i < 144) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(48 + i << 8);
            DeflaterHuffman.staticLLength[i++] = 8;
        }
        while (i < 256) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(256 + i << 7);
            DeflaterHuffman.staticLLength[i++] = 9;
        }
        while (i < 280) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(-256 + i << 9);
            DeflaterHuffman.staticLLength[i++] = 7;
        }
        while (i < 286) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(-88 + i << 8);
            DeflaterHuffman.staticLLength[i++] = 8;
        }
        staticDCodes = new short[30];
        staticDLength = new byte[30];
        i = 0;
        while (i < 30) {
            DeflaterHuffman.staticDCodes[i] = DeflaterHuffman.bitReverse(i << 11);
            DeflaterHuffman.staticDLength[i] = 5;
            ++i;
        }
    }

    static short bitReverse(int value) {
        return (short)(bit4Reverse.charAt(value & 0xF) << 12 | bit4Reverse.charAt(value >> 4 & 0xF) << 8 | bit4Reverse.charAt(value >> 8 & 0xF) << 4 | bit4Reverse.charAt(value >> 12));
    }

    public DeflaterHuffman(DeflaterPending pending) {
        this.pending = pending;
        this.literalTree = new Tree(286, 257, 15);
        this.distTree = new Tree(30, 1, 15);
        this.blTree = new Tree(19, 4, 7);
        this.d_buf = new short[16384];
        this.l_buf = new byte[16384];
    }

    public final void reset() {
        this.last_lit = 0;
        this.extra_bits = 0;
        this.literalTree.reset();
        this.distTree.reset();
        this.blTree.reset();
    }

    private final int l_code(int len) {
        if (len == 255) {
            return 285;
        }
        int code = 257;
        while (len >= 8) {
            code += 4;
            len >>= 1;
        }
        return code + len;
    }

    private final int d_code(int distance) {
        int code = 0;
        while (distance >= 4) {
            code += 2;
            distance >>= 1;
        }
        return code + distance;
    }

    public void sendAllTrees(int blTreeCodes) {
        this.blTree.buildCodes();
        this.literalTree.buildCodes();
        this.distTree.buildCodes();
        this.pending.writeBits(this.literalTree.numCodes - 257, 5);
        this.pending.writeBits(this.distTree.numCodes - 1, 5);
        this.pending.writeBits(blTreeCodes - 4, 4);
        int rank = 0;
        while (rank < blTreeCodes) {
            this.pending.writeBits(this.blTree.length[BL_ORDER[rank]], 3);
            ++rank;
        }
        this.literalTree.writeTree(this.blTree);
        this.distTree.writeTree(this.blTree);
    }

    public void compressBlock() {
        int i = 0;
        while (i < this.last_lit) {
            int litlen = this.l_buf[i] & 0xFF;
            int dist = this.d_buf[i];
            if (dist-- != 0) {
                int lc = this.l_code(litlen);
                this.literalTree.writeSymbol(lc);
                int bits = (lc - 261) / 4;
                if (bits > 0 && bits <= 5) {
                    this.pending.writeBits(litlen & (1 << bits) - 1, bits);
                }
                int dc = this.d_code(dist);
                this.distTree.writeSymbol(dc);
                bits = dc / 2 - 1;
                if (bits > 0) {
                    this.pending.writeBits(dist & (1 << bits) - 1, bits);
                }
            } else {
                this.literalTree.writeSymbol(litlen);
            }
            ++i;
        }
        this.literalTree.writeSymbol(256);
    }

    public void flushStoredBlock(byte[] stored, int stored_offset, int stored_len, boolean lastBlock) {
        this.pending.writeBits(0 + (lastBlock ? 1 : 0), 3);
        this.pending.alignToByte();
        this.pending.writeShort(stored_len);
        this.pending.writeShort(~stored_len);
        this.pending.writeBlock(stored, stored_offset, stored_len);
        this.reset();
    }

    public void flushBlock(byte[] stored, int stored_offset, int stored_len, boolean lastBlock) {
        this.literalTree.freqs[256] = (short)(this.literalTree.freqs[256] + 1);
        this.literalTree.buildTree();
        this.distTree.buildTree();
        this.literalTree.calcBLFreq(this.blTree);
        this.distTree.calcBLFreq(this.blTree);
        this.blTree.buildTree();
        int blTreeCodes = 4;
        int i = 18;
        while (i > blTreeCodes) {
            if (this.blTree.length[BL_ORDER[i]] > 0) {
                blTreeCodes = i + 1;
            }
            --i;
        }
        int opt_len = 14 + blTreeCodes * 3 + this.blTree.getEncodedLength() + this.literalTree.getEncodedLength() + this.distTree.getEncodedLength() + this.extra_bits;
        int static_len = this.extra_bits;
        int i2 = 0;
        while (i2 < 286) {
            static_len += this.literalTree.freqs[i2] * staticLLength[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 30) {
            static_len += this.distTree.freqs[i2] * staticDLength[i2];
            ++i2;
        }
        if (opt_len >= static_len) {
            opt_len = static_len;
        }
        if (stored_offset >= 0 && stored_len + 4 < opt_len >> 3) {
            this.flushStoredBlock(stored, stored_offset, stored_len, lastBlock);
        } else if (opt_len == static_len) {
            this.pending.writeBits(2 + (lastBlock ? 1 : 0), 3);
            this.literalTree.setStaticCodes(staticLCodes, staticLLength);
            this.distTree.setStaticCodes(staticDCodes, staticDLength);
            this.compressBlock();
            this.reset();
        } else {
            this.pending.writeBits(4 + (lastBlock ? 1 : 0), 3);
            this.sendAllTrees(blTreeCodes);
            this.compressBlock();
            this.reset();
        }
    }

    public final boolean isFull() {
        return this.last_lit == 16384;
    }

    public final boolean tallyLit(int lit) {
        this.d_buf[this.last_lit] = 0;
        this.l_buf[this.last_lit++] = (byte)lit;
        int n = lit;
        this.literalTree.freqs[n] = (short)(this.literalTree.freqs[n] + 1);
        return this.last_lit == 16384;
    }

    public final boolean tallyDist(int dist, int len) {
        int dc;
        int lc;
        this.d_buf[this.last_lit] = (short)dist;
        this.l_buf[this.last_lit++] = (byte)(len - 3);
        int n = lc = this.l_code(len - 3);
        this.literalTree.freqs[n] = (short)(this.literalTree.freqs[n] + 1);
        if (lc >= 265 && lc < 285) {
            this.extra_bits += (lc - 261) / 4;
        }
        int n2 = dc = this.d_code(dist - 1);
        this.distTree.freqs[n2] = (short)(this.distTree.freqs[n2] + 1);
        if (dc >= 4) {
            this.extra_bits += dc / 2 - 1;
        }
        return this.last_lit == 16384;
    }

    class Tree {
        short[] freqs;
        short[] codes;
        byte[] length;
        int[] bl_counts;
        int minNumCodes;
        int numCodes;
        int maxLength;

        Tree(int elems, int minCodes, int maxLength) {
            this.minNumCodes = minCodes;
            this.maxLength = maxLength;
            this.freqs = new short[elems];
            this.bl_counts = new int[maxLength];
        }

        void reset() {
            int i = 0;
            while (i < this.freqs.length) {
                this.freqs[i] = 0;
                ++i;
            }
            this.codes = null;
            this.length = null;
        }

        final void writeSymbol(int code) {
            DeflaterHuffman.this.pending.writeBits(this.codes[code] & 0xFFFF, this.length[code]);
        }

        final void checkEmpty() {
            boolean empty = true;
            int i = 0;
            while (i < this.freqs.length) {
                if (this.freqs[i] != 0) {
                    System.err.println("freqs[" + i + "] == " + this.freqs[i]);
                    empty = false;
                }
                ++i;
            }
            if (!empty) {
                throw new InternalError();
            }
            System.err.println("checkEmpty suceeded!");
        }

        void setStaticCodes(short[] stCodes, byte[] stLength) {
            this.codes = stCodes;
            this.length = stLength;
        }

        public void buildCodes() {
            int[] nextCode = new int[this.maxLength];
            int code = 0;
            this.codes = new short[this.freqs.length];
            int bits = 0;
            while (bits < this.maxLength) {
                nextCode[bits] = code;
                code += this.bl_counts[bits] << 15 - bits;
                ++bits;
            }
            int i = 0;
            while (i < this.numCodes) {
                byte bits2 = this.length[i];
                if (bits2 > 0) {
                    this.codes[i] = DeflaterHuffman.bitReverse(nextCode[bits2 - 1]);
                    int n = bits2 - 1;
                    nextCode[n] = nextCode[n] + (1 << 16 - bits2);
                }
                ++i;
            }
        }

        private void buildLength(int[] childs) {
            this.length = new byte[this.freqs.length];
            int numNodes = childs.length / 2;
            int numLeafs = (numNodes + 1) / 2;
            int overflow = 0;
            int i = 0;
            while (i < this.maxLength) {
                this.bl_counts[i] = 0;
                ++i;
            }
            int[] lengths = new int[numNodes];
            lengths[numNodes - 1] = 0;
            int i2 = numNodes - 1;
            while (i2 >= 0) {
                int bitLength;
                if (childs[2 * i2 + 1] != -1) {
                    bitLength = lengths[i2] + 1;
                    if (bitLength > this.maxLength) {
                        bitLength = this.maxLength;
                        ++overflow;
                    }
                    int n = bitLength;
                    lengths[childs[2 * i2 + 1]] = n;
                    lengths[childs[2 * i2]] = n;
                } else {
                    bitLength = lengths[i2];
                    int n = bitLength - 1;
                    this.bl_counts[n] = this.bl_counts[n] + 1;
                    this.length[childs[2 * i2]] = (byte)lengths[i2];
                }
                --i2;
            }
            if (overflow == 0) {
                return;
            }
            int incrBitLen = this.maxLength - 1;
            while (true) {
                if (this.bl_counts[--incrBitLen] == 0) {
                    continue;
                }
                do {
                    int n = incrBitLen++;
                    this.bl_counts[n] = this.bl_counts[n] - 1;
                    int n2 = incrBitLen;
                    this.bl_counts[n2] = this.bl_counts[n2] + 1;
                } while ((overflow -= 1 << this.maxLength - 1 - incrBitLen) > 0 && incrBitLen < this.maxLength - 1);
                if (overflow <= 0) break;
            }
            int n = this.maxLength - 1;
            this.bl_counts[n] = this.bl_counts[n] + overflow;
            int n3 = this.maxLength - 2;
            this.bl_counts[n3] = this.bl_counts[n3] - overflow;
            int nodePtr = 2 * numLeafs;
            int bits = this.maxLength;
            while (bits != 0) {
                int n4 = this.bl_counts[bits - 1];
                while (n4 > 0) {
                    int childPtr;
                    if (childs[(childPtr = 2 * childs[nodePtr++]) + 1] != -1) continue;
                    this.length[childs[childPtr]] = (byte)bits;
                    --n4;
                }
                --bits;
            }
        }

        void buildTree() {
            int numSymbols = this.freqs.length;
            int[] heap = new int[numSymbols];
            int heapLen = 0;
            int maxCode = 0;
            int n = 0;
            while (n < numSymbols) {
                short freq = this.freqs[n];
                if (freq != 0) {
                    int ppos;
                    int pos = heapLen++;
                    while (pos > 0 && this.freqs[heap[ppos = (pos - 1) / 2]] > freq) {
                        heap[pos] = heap[ppos];
                        pos = ppos;
                    }
                    heap[pos] = n;
                    maxCode = n;
                }
                ++n;
            }
            while (heapLen < 2) {
                int node = maxCode < 2 ? ++maxCode : 0;
                heap[heapLen++] = node;
            }
            this.numCodes = Math.max(maxCode + 1, this.minNumCodes);
            int numLeafs = heapLen;
            int[] childs = new int[4 * heapLen - 2];
            int[] values = new int[2 * heapLen - 1];
            int numNodes = numLeafs;
            int i = 0;
            while (i < heapLen) {
                int node;
                childs[2 * i] = node = heap[i];
                childs[2 * i + 1] = -1;
                values[i] = this.freqs[node] << 8;
                heap[i] = i;
                ++i;
            }
            do {
                int first = heap[0];
                int last = heap[--heapLen];
                int ppos = 0;
                int path = 1;
                while (path < heapLen) {
                    if (path + 1 < heapLen && values[heap[path]] > values[heap[path + 1]]) {
                        ++path;
                    }
                    heap[ppos] = heap[path];
                    ppos = path;
                    path = path * 2 + 1;
                }
                int lastVal = values[last];
                while ((path = ppos) > 0 && values[heap[ppos = (path - 1) / 2]] > lastVal) {
                    heap[path] = heap[ppos];
                }
                heap[path] = last;
                int second = heap[0];
                last = numNodes++;
                childs[2 * last] = first;
                childs[2 * last + 1] = second;
                int mindepth = Math.min(values[first] & 0xFF, values[second] & 0xFF);
                values[last] = lastVal = values[first] + values[second] - mindepth + 1;
                ppos = 0;
                path = 1;
                while (path < heapLen) {
                    if (path + 1 < heapLen && values[heap[path]] > values[heap[path + 1]]) {
                        ++path;
                    }
                    heap[ppos] = heap[path];
                    ppos = path;
                    path = ppos * 2 + 1;
                }
                while ((path = ppos) > 0 && values[heap[ppos = (path - 1) / 2]] > lastVal) {
                    heap[path] = heap[ppos];
                }
                heap[path] = last;
            } while (heapLen > 1);
            if (heap[0] != childs.length / 2 - 1) {
                throw new RuntimeException("Weird!");
            }
            this.buildLength(childs);
        }

        int getEncodedLength() {
            int len = 0;
            int i = 0;
            while (i < this.freqs.length) {
                len += this.freqs[i] * this.length[i];
                ++i;
            }
            return len;
        }

        void calcBLFreq(Tree blTree) {
            byte curlen = -1;
            int i = 0;
            while (i < this.numCodes) {
                int min_count;
                int max_count;
                int count = 1;
                byte nextlen = this.length[i];
                if (nextlen == 0) {
                    max_count = 138;
                    min_count = 3;
                } else {
                    max_count = 6;
                    min_count = 3;
                    if (curlen != nextlen) {
                        byte by = nextlen;
                        blTree.freqs[by] = (short)(blTree.freqs[by] + 1);
                        count = 0;
                    }
                }
                curlen = nextlen;
                ++i;
                while (i < this.numCodes && curlen == this.length[i]) {
                    ++i;
                    if (++count >= max_count) break;
                }
                if (count < min_count) {
                    byte by = curlen;
                    blTree.freqs[by] = (short)(blTree.freqs[by] + count);
                    continue;
                }
                if (curlen != 0) {
                    blTree.freqs[16] = (short)(blTree.freqs[16] + 1);
                    continue;
                }
                if (count <= 10) {
                    blTree.freqs[17] = (short)(blTree.freqs[17] + 1);
                    continue;
                }
                blTree.freqs[18] = (short)(blTree.freqs[18] + 1);
            }
        }

        void writeTree(Tree blTree) {
            byte curlen = -1;
            int i = 0;
            while (i < this.numCodes) {
                int min_count;
                int max_count;
                int count = 1;
                byte nextlen = this.length[i];
                if (nextlen == 0) {
                    max_count = 138;
                    min_count = 3;
                } else {
                    max_count = 6;
                    min_count = 3;
                    if (curlen != nextlen) {
                        blTree.writeSymbol(nextlen);
                        count = 0;
                    }
                }
                curlen = nextlen;
                ++i;
                while (i < this.numCodes && curlen == this.length[i]) {
                    ++i;
                    if (++count >= max_count) break;
                }
                if (count < min_count) {
                    while (count-- > 0) {
                        blTree.writeSymbol(curlen);
                    }
                    continue;
                }
                if (curlen != 0) {
                    blTree.writeSymbol(16);
                    DeflaterHuffman.this.pending.writeBits(count - 3, 2);
                    continue;
                }
                if (count <= 10) {
                    blTree.writeSymbol(17);
                    DeflaterHuffman.this.pending.writeBits(count - 3, 3);
                    continue;
                }
                blTree.writeSymbol(18);
                DeflaterHuffman.this.pending.writeBits(count - 11, 7);
            }
        }
    }
}

