/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.io.IOException;
import java.io.Reader;
import uk.ac.sanger.artemis.BlastM8ComparisonData;
import uk.ac.sanger.artemis.ComparisonData;
import uk.ac.sanger.artemis.MSPcrunchComparisonData;
import uk.ac.sanger.artemis.MegaBlastComparisonData;
import uk.ac.sanger.artemis.SSAHAComparisonData;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public class ComparisonDataFactory {
    public static ComparisonData readComparisonData(Document data_document) throws IOException {
        Reader in_file = data_document.getReader();
        LinePushBackReader pushback_reader = new LinePushBackReader(in_file);
        String line = pushback_reader.readLine();
        if (line == null) {
            throw new IOException("End of file while reading from: " + data_document);
        }
        pushback_reader.pushBack(line);
        if (MSPcrunchComparisonData.formatCorrect(line)) {
            return new MSPcrunchComparisonData(pushback_reader);
        }
        if (SSAHAComparisonData.formatCorrect(line)) {
            return new SSAHAComparisonData(pushback_reader);
        }
        if (BlastM8ComparisonData.formatCorrect(line)) {
            return new BlastM8ComparisonData(pushback_reader);
        }
        if (MegaBlastComparisonData.formatCorrect(line)) {
            return new MegaBlastComparisonData(pushback_reader);
        }
        throw new IOException("cannot understand the comparison file format");
    }
}

