/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.plaf.FontUIResource;
import uk.ac.sanger.artemis.ExternalProgram;
import uk.ac.sanger.artemis.ExternalProgramVector;
import uk.ac.sanger.artemis.OptionChangeEvent;
import uk.ac.sanger.artemis.OptionChangeListener;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.KeyVector;
import uk.ac.sanger.artemis.io.QualifierInfo;
import uk.ac.sanger.artemis.io.QualifierInfoException;
import uk.ac.sanger.artemis.io.QualifierInfoVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.StringVector;

public class Options
extends Properties {
    private static Options options = new Options();
    private static final String direct_edit_string = "direct_edit";
    private static final String eukaryotic_mode_string = "organism_type";
    private static final String highlight_active_entry_string = "highlight_active_entry";
    private static StringVector display_gene_qualifier_names = null;
    private static StringVector systematic_gene_qualifier_names = null;
    private static StringVector all_gene_qualifier_names = null;
    private static Boolean read_succeeded = null;
    private static EntryInformation extended_entry_information;
    private static EntryInformation db_entry_information;
    private Font font = null;
    private Vector colour_map = null;
    private ExternalProgramVector external_programs = null;
    private Hashtable option_listener_hash = new Hashtable();
    private StringVector invisible_qualifiers = null;
    static /* synthetic */ Class class$0;

    static {
        try {
            db_entry_information = Options.makeEntryInformation();
            extended_entry_information = Options.makeArtemisEntryInformation(db_entry_information);
        }
        catch (QualifierInfoException e) {
            System.err.println("could not initialise the embl package: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("could not initialise the embl package: " + e.getMessage());
            System.exit(1);
        }
    }

    public Options() {
        try {
            ((Hashtable)this).put("font_size", "14");
            this.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private boolean getPropertyTruthValueInternal(String value) {
        if (value == null) {
            return false;
        }
        String lowercase_value = value.toLowerCase();
        return !lowercase_value.equals("false") && !lowercase_value.equals("f") && !lowercase_value.equals("no") && !lowercase_value.equals("n");
    }

    public boolean getPropertyTruthValue(String name) {
        return this.getPropertyTruthValueInternal(this.getProperty(name));
    }

    public StringVector getDisplayQualifierNames() {
        if (display_gene_qualifier_names == null) {
            String name_string = this.getProperty("display_name_qualifiers");
            if (name_string == null) {
                display_gene_qualifier_names = new StringVector();
                display_gene_qualifier_names.add("gene");
            } else {
                display_gene_qualifier_names = StringVector.getStrings(name_string);
            }
        }
        return display_gene_qualifier_names;
    }

    public StringVector getSystematicQualifierNames() {
        if (systematic_gene_qualifier_names == null) {
            String name_string = this.getProperty("systematic_name_qualifiers");
            if (name_string == null) {
                systematic_gene_qualifier_names = new StringVector();
                systematic_gene_qualifier_names.add("gene");
            } else {
                systematic_gene_qualifier_names = StringVector.getStrings(name_string);
            }
        }
        return systematic_gene_qualifier_names;
    }

    public StringVector getAllGeneNames() {
        if (all_gene_qualifier_names == null) {
            all_gene_qualifier_names = this.getSystematicQualifierNames().copy();
            all_gene_qualifier_names.add(this.getDisplayQualifierNames());
        }
        return all_gene_qualifier_names;
    }

    private void readOptions() {
        try {
            InputStream options_input_stream = Options.class.getResourceAsStream("/etc/options");
            if (options_input_stream == null) {
                return;
            }
            this.load(options_input_stream);
            boolean run_quietly = this.getPropertyTruthValueInternal(System.getProperty("run_quietly"));
            if (Options.readWritePossible()) {
                String extra_options_prop;
                String[] standard_option_file_names;
                String user_home = System.getProperty("user.home");
                String[] option_file_names = standard_option_file_names = new String[]{"Diana.ini", "options", "options.txt", "options.text", String.valueOf(user_home) + File.separator + ".artemis_options"};
                Properties system_properties = System.getProperties();
                if (system_properties != null && (extra_options_prop = system_properties.getProperty("extra_options")) != null) {
                    StringVector extra_option_file_names = StringVector.getStrings(extra_options_prop, ":");
                    option_file_names = new String[option_file_names.length + extra_option_file_names.size()];
                    int i = 0;
                    while (i < extra_option_file_names.size()) {
                        String extra_option_file_name = extra_option_file_names.elementAt(i);
                        if (new File(extra_option_file_name).canRead()) {
                            option_file_names[i] = extra_option_file_name;
                        } else {
                            System.err.println("warning: could not read options from \"" + extra_option_file_name + "\"");
                            option_file_names[i] = null;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < standard_option_file_names.length) {
                        option_file_names[i + extra_option_file_names.size()] = standard_option_file_names[i];
                        ++i;
                    }
                }
                int i = 0;
                while (i < option_file_names.length) {
                    FileDocument options_document;
                    String this_options_file = option_file_names[i];
                    if (this_options_file != null && ((Document)(options_document = new FileDocument(new File(this_options_file)))).readable()) {
                        InputStream options_document_stream = ((Document)options_document).getInputStream();
                        if (!run_quietly) {
                            System.err.println("reading options from \"" + this_options_file + "\"");
                        }
                        this.load(options_document_stream);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            System.err.println("could not read an options file : " + e);
        }
        Enumeration<?> _enum = this.propertyNames();
        while (_enum.hasMoreElements()) {
            String property_name = (String)_enum.nextElement();
            this.fireChangeEvent(property_name);
        }
    }

    public void reset() {
        ((Hashtable)this).clear();
        this.setDefaultFeatureColours();
        this.setDefaultColourMap();
        this.readOptions();
        this.readSystemOptions();
        this.resetCachedValues();
    }

    public void load(InputStream in_stream) throws IOException {
        super.load(in_stream);
        this.resetCachedValues();
    }

    public static Options getOptions() {
        return options;
    }

    public static boolean isUnixHost() {
        return System.getProperty("artemis.environment") != null && System.getProperty("artemis.environment").equals("UNIX");
    }

    public static boolean isNoddyMode() {
        return !Options.isBlackBeltMode();
    }

    public static boolean isBlackBeltMode() {
        return Options.getOptions().getPropertyTruthValue("black_belt_mode");
    }

    public static boolean readWritePossible() {
        if (read_succeeded == null) {
            try {
                File.createTempFile("dummy", "dummy");
                read_succeeded = new Boolean(true);
            }
            catch (Throwable throwable) {
                read_succeeded = new Boolean(false);
            }
        }
        return read_succeeded;
    }

    public StringVector getOptionValues(String option) {
        return Options.getPropertyValues(this, option);
    }

    public static StringVector getPropertyValues(Properties properties, String option) {
        String option_value = properties.getProperty(option);
        if (option_value == null) {
            return null;
        }
        return StringVector.getStrings(option_value);
    }

    public QualifierInfoVector getExtraQualifiers() {
        QualifierInfoVector return_vector = new QualifierInfoVector();
        StringVector extra_qualifiers_strings = this.getOptionValues("extra_qualifiers");
        int i = 0;
        while (i < extra_qualifiers_strings.size() / 2) {
            String name = extra_qualifiers_strings.elementAt(i * 2);
            String type_string = extra_qualifiers_strings.elementAt(i * 2 + 1);
            int type = QualifierInfo.getQualifierTypeID(type_string);
            return_vector.add(new QualifierInfo(name, type, null, null, false));
            ++i;
        }
        return return_vector;
    }

    public StringVector getInvisibleQualifiers() {
        if (this.invisible_qualifiers == null) {
            this.invisible_qualifiers = this.getOptionValues("invisible_qualifiers");
            if (this.invisible_qualifiers == null) {
                this.invisible_qualifiers = new StringVector();
            }
        }
        return this.invisible_qualifiers;
    }

    public String getDefaultSequenceFileName() {
        String property_string = this.getProperty("SEQUENCE_FILE");
        if (property_string == null) {
            return null;
        }
        if (property_string.length() == 0) {
            return null;
        }
        if (property_string.startsWith("'") && property_string.endsWith("'") && property_string.length() > 2) {
            return property_string.substring(1, property_string.length() - 1);
        }
        return property_string;
    }

    public String getDefaultFeatureFileName() {
        String property_string = this.getProperty("FEATURE_FILE");
        if (property_string == null) {
            return null;
        }
        if (property_string.length() == 0) {
            return null;
        }
        if (property_string.startsWith("'") && property_string.endsWith("'") && property_string.length() > 2) {
            return property_string.substring(1, property_string.length() - 1);
        }
        return property_string;
    }

    public int getMinimumORFSize() {
        Integer minimum_orf_size = this.getIntegerProperty("minimum_orf_size");
        if (minimum_orf_size == null) {
            return 100;
        }
        return minimum_orf_size;
    }

    public Color getDefaultFeatureColour(Key key) {
        Integer colour_integer = this.getIntegerProperty("colour_of_" + key);
        if (colour_integer == null) {
            return null;
        }
        return this.getColorFromColourNumber(colour_integer);
    }

    public Color getColorFromColourNumber(int colour_number) {
        if (colour_number < 0) {
            return null;
        }
        if (colour_number >= this.colour_map.size() || this.colour_map.elementAt(colour_number) == null) {
            return null;
        }
        return (Color)this.colour_map.elementAt(colour_number);
    }

    private Color parseColour(String colour_string) {
        try {
            StringVector value_strings = StringVector.getStrings(colour_string.trim());
            int first_int = Integer.valueOf(value_strings.elementAt(0));
            int second_int = Integer.valueOf(value_strings.elementAt(1));
            int third_int = Integer.valueOf(value_strings.elementAt(2));
            return new Color(first_int, second_int, third_int);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void setDefaultColourMap() {
        ((Hashtable)this).put("colour_0", "255 255 255");
        ((Hashtable)this).put("colour_1", "100 100 100");
        ((Hashtable)this).put("colour_2", "255 0 0");
        ((Hashtable)this).put("colour_3", "0 255 0");
        ((Hashtable)this).put("colour_4", "0 0 255");
        ((Hashtable)this).put("colour_5", "0 255 255");
        ((Hashtable)this).put("colour_6", "255 0 255");
        ((Hashtable)this).put("colour_7", "255 255 0");
        ((Hashtable)this).put("colour_8", "152 251 152");
        ((Hashtable)this).put("colour_9", "135 206 250");
        ((Hashtable)this).put("colour_10", "255 165 0");
        ((Hashtable)this).put("colour_11", "200 150 100");
        ((Hashtable)this).put("colour_12", "255 200 200");
    }

    public ExternalProgramVector getExternalPrograms() {
        if (this.external_programs == null) {
            StringVector application_value_strings;
            ExternalProgram program;
            StringVector dna_value_strings;
            this.external_programs = new ExternalProgramVector();
            StringVector protein_value_strings = this.getOptionValues("feature_protein_programs");
            if (protein_value_strings != null) {
                int i = 0;
                while (i < protein_value_strings.size() / 2) {
                    String program_name = protein_value_strings.elementAt(i * 2);
                    String program_options = protein_value_strings.elementAt(i * 2 + 1);
                    ExternalProgram program2 = new ExternalProgram(program_name, program_options, 0);
                    this.external_programs.add(program2);
                    ++i;
                }
            }
            if ((dna_value_strings = this.getOptionValues("feature_dna_programs")) != null) {
                int i = 0;
                while (i < dna_value_strings.size() / 2) {
                    String program_name = dna_value_strings.elementAt(i * 2);
                    String program_options = dna_value_strings.elementAt(i * 2 + 1);
                    program = new ExternalProgram(program_name, program_options, 1);
                    this.external_programs.add(program);
                    ++i;
                }
            }
            if ((application_value_strings = this.getOptionValues("application_programs")) != null) {
                int i = 0;
                while (i < application_value_strings.size()) {
                    String program_name = application_value_strings.elementAt(i);
                    program = new ExternalProgram(program_name, null, 2);
                    this.external_programs.add(program);
                    ++i;
                }
            }
        }
        return this.external_programs;
    }

    public StringVector getProkaryoticStartCodons() {
        StringVector option_values = this.getOptionValues("prokaryotic_start_codons");
        int i = 0;
        while (i < option_values.size()) {
            String new_value = option_values.elementAt(i).toLowerCase();
            option_values.setElementAt(new_value, i);
            ++i;
        }
        return option_values;
    }

    public StringVector getEukaryoticStartCodons() {
        StringVector option_values = this.getOptionValues("eukaryotic_start_codons");
        int i = 0;
        while (i < option_values.size()) {
            String new_value = option_values.elementAt(i).toLowerCase();
            option_values.setElementAt(new_value, i);
            ++i;
        }
        return option_values;
    }

    public Font getFont() {
        return this.font;
    }

    public FontUIResource getFontUIResource() {
        return new FontUIResource(this.getFont());
    }

    public void addOptionChangeListener(OptionChangeListener l) {
        this.option_listener_hash.put(l, this);
    }

    public void removeOptionChangeListener(OptionChangeListener l) {
        this.option_listener_hash.remove(l);
    }

    private void readSystemOptions() {
        Properties system_properties;
        if (Options.readWritePossible() && (system_properties = System.getProperties()) != null) {
            Enumeration enumeration = ((Hashtable)system_properties).keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = system_properties.getProperty(key);
                ((Hashtable)this).put(key, value);
            }
        }
    }

    private void setDefaultFeatureColours() {
        Object[] key_colour_map = new Object[]{"CDS", "5", "cds?", "7", "BLASTCDS", "2", "BLASTN_HIT", "6", "source", "0", "prim_tran", "0", "stem_loop", "2", "misc_feature", "3", "delta", "3", "repeat_region", "9", "repeat_unit", "9", "terminator", "3", "promoter", "3", "intron", "1", "exon", "7", "mRNA", "1", "tRNA", "8", "TATA", "3", "bldA", "2"};
        int i = 0;
        while (i < key_colour_map.length / 2) {
            ((Hashtable)this).put("colour_of_" + key_colour_map[i * 2], key_colour_map[i * 2 + 1]);
            ++i;
        }
    }

    private void resetCachedValues() {
        String colour_value_string;
        int font_size;
        try {
            Integer font_size_integer = this.getIntegerProperty("font_size");
            font_size = font_size_integer == null ? 12 : font_size_integer;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("error in options file - font_size should be an integer");
            font_size = 14;
            ((Hashtable)this).put("font_size", String.valueOf(font_size));
        }
        if (this.getProperty("font_name") == null) {
            ((Hashtable)this).put("font_name", "Monospaced");
        }
        this.font = new Font(this.getProperty("font_name"), 0, font_size);
        this.colour_map = new Vector(25);
        int colour_number = 0;
        while ((colour_value_string = this.getProperty("colour_" + colour_number)) != null) {
            Color new_colour = this.parseColour(colour_value_string);
            if (new_colour == null) {
                System.err.println("error in options file could not understand this number: " + colour_value_string);
            } else {
                if (colour_number >= this.colour_map.size()) {
                    this.colour_map.setSize(colour_number + 50);
                }
                this.colour_map.setElementAt(new_colour, colour_number);
            }
            ++colour_number;
        }
        this.invisible_qualifiers = null;
        display_gene_qualifier_names = null;
        systematic_gene_qualifier_names = null;
        all_gene_qualifier_names = null;
    }

    public Integer getIntegerProperty(String property_name) {
        String property_string = this.getProperty(property_name);
        if (property_string == null) {
            return null;
        }
        return Integer.valueOf(property_string);
    }

    public int getUndoLevels() {
        Integer undo_integer = this.getIntegerProperty("undo_levels");
        if (undo_integer == null) {
            return 0;
        }
        if (undo_integer < 0) {
            return 0;
        }
        return undo_integer;
    }

    public void setDirectEdit(boolean direct_edit) {
        if (direct_edit) {
            if (!this.canDirectEdit()) {
                ((Hashtable)this).put(direct_edit_string, "true");
                this.fireChangeEvent(direct_edit_string);
            }
        } else if (this.canDirectEdit()) {
            ((Hashtable)this).put(direct_edit_string, "false");
            this.fireChangeEvent(direct_edit_string);
        }
    }

    public boolean canDirectEdit() {
        return this.getPropertyTruthValue(direct_edit_string);
    }

    public void setEukaryoticMode(boolean eukaryotic_mode) {
        if (eukaryotic_mode) {
            if (!this.isEukaryoticMode()) {
                ((Hashtable)this).put(eukaryotic_mode_string, "eukaryotic");
                this.fireChangeEvent(eukaryotic_mode_string);
            }
        } else if (this.isEukaryoticMode()) {
            ((Hashtable)this).put(eukaryotic_mode_string, "prokaryotic");
            this.fireChangeEvent(eukaryotic_mode_string);
        }
    }

    public boolean isEukaryoticMode() {
        String organism_type_prop = this.getProperty(eukaryotic_mode_string);
        return organism_type_prop == null || organism_type_prop.equals("eukaryotic") || organism_type_prop.equals("eukaryote") || organism_type_prop.equals("euk");
    }

    public void setHighlightActiveEntryFlag(boolean highlight_active) {
        if (highlight_active) {
            if (!this.highlightActiveEntryFlag()) {
                ((Hashtable)this).put(highlight_active_entry_string, "true");
                this.fireChangeEvent(highlight_active_entry_string);
            }
        } else if (this.highlightActiveEntryFlag()) {
            ((Hashtable)this).put(highlight_active_entry_string, "false");
            this.fireChangeEvent(highlight_active_entry_string);
        }
    }

    public boolean highlightActiveEntryFlag() {
        return this.getPropertyTruthValue(highlight_active_entry_string);
    }

    public boolean isBuggyLinuxVM() {
        if (!Options.readWritePossible()) {
            return false;
        }
        String os_name = (String)((Hashtable)System.getProperties()).get("os.name");
        if (os_name.equals("Linux")) {
            String java_version = (String)((Hashtable)System.getProperties()).get("java.version");
            return !java_version.startsWith("1.1.");
        }
        return false;
    }

    public static EntryInformation getDBEntryInformation() {
        return db_entry_information;
    }

    public static EntryInformation getArtemisEntryInformation() {
        return extended_entry_information;
    }

    private static EntryInformation makeEntryInformation() throws IOException, QualifierInfoException {
        InputStream feature_keys_stream = Options.class.getResourceAsStream("/etc/feature_keys");
        InputStream qualifier_types_stream = Options.class.getResourceAsStream("/etc/qualifier_types");
        QualifierInfoVector qualifier_info_vector = Options.readQualifierInfo(qualifier_types_stream, feature_keys_stream);
        SimpleEntryInformation entry_information = new SimpleEntryInformation();
        int i = 0;
        while (i < qualifier_info_vector.size()) {
            QualifierInfo qualifier_info = qualifier_info_vector.elementAt(i);
            entry_information.addQualifierInfo(qualifier_info);
            ++i;
        }
        entry_information.setEMBLFormat(true);
        return entry_information;
    }

    private static EntryInformation makeArtemisEntryInformation(EntryInformation standard_entry_info) throws QualifierInfoException {
        StringVector extra_keys = Options.getOptions().getOptionValues("extra_keys");
        QualifierInfoVector extra_qualifiers = Options.getOptions().getExtraQualifiers();
        SimpleEntryInformation return_entry_information = new SimpleEntryInformation(standard_entry_info);
        int i = 0;
        while (i < extra_keys.size()) {
            Key new_key = new Key(extra_keys.elementAt(i));
            return_entry_information.addKey(new_key);
            ++i;
        }
        i = 0;
        while (i < extra_qualifiers.size()) {
            QualifierInfo new_qualifier_info = extra_qualifiers.elementAt(i);
            return_entry_information.addQualifierInfo(new_qualifier_info);
            ++i;
        }
        ExternalProgramVector external_programs = Options.getOptions().getExternalPrograms();
        int i2 = 0;
        while (i2 < external_programs.size()) {
            ExternalProgram external_program = external_programs.elementAt(i2);
            if (external_program.getType() == 0 || external_program.getType() == 1) {
                QualifierInfo new_qualifier_info = new QualifierInfo(String.valueOf(external_program.getName()) + "_file", 1, null, null, true);
                return_entry_information.addQualifierInfo(new_qualifier_info);
            }
            ++i2;
        }
        return_entry_information.setEMBLFormat(false);
        return return_entry_information;
    }

    private static QualifierInfoVector readQualifierInfo(InputStream qualifier_types_stream, InputStream feature_keys_stream) throws IOException {
        QualifierInfoVector return_vector = new QualifierInfoVector();
        Properties feature_properties = new Properties();
        Properties qualifier_properties = new Properties();
        feature_properties.load(feature_keys_stream);
        qualifier_properties.load(qualifier_types_stream);
        Properties new_feature_properties = new Properties();
        Enumeration<?> feature_enum = feature_properties.propertyNames();
        while (feature_enum.hasMoreElements()) {
            String current_feature_name = (String)feature_enum.nextElement();
            StringVector property_values = Options.getPropertyValues(feature_properties, current_feature_name);
            ((Hashtable)new_feature_properties).put(current_feature_name, property_values);
        }
        feature_properties = new_feature_properties;
        Enumeration<?> qualifier_enum = qualifier_properties.propertyNames();
        while (qualifier_enum.hasMoreElements()) {
            String current_qualifier_name = (String)qualifier_enum.nextElement();
            StringVector current_qualifier_values = Options.getPropertyValues(qualifier_properties, current_qualifier_name);
            boolean once_only = current_qualifier_values.elementAt(0).equals("yes");
            String type_string = current_qualifier_values.elementAt(1);
            KeyVector valid_keys = new KeyVector();
            KeyVector required_keys = new KeyVector();
            Enumeration<?> features_enum = feature_properties.propertyNames();
            while (features_enum.hasMoreElements()) {
                String current_key_string = (String)features_enum.nextElement();
                Key current_key = new Key(current_key_string);
                StringVector current_feature_qualifiers = (StringVector)((Hashtable)feature_properties).get(current_key_string);
                if (current_feature_qualifiers.contains(current_qualifier_name)) {
                    valid_keys.add(current_key);
                    continue;
                }
                if (!current_feature_qualifiers.contains("@" + current_qualifier_name)) continue;
                valid_keys.add(current_key);
                required_keys.add(current_key);
            }
            int type = QualifierInfo.getQualifierTypeID(type_string);
            QualifierInfo qualifier_info = new QualifierInfo(current_qualifier_name, type, valid_keys, required_keys, once_only);
            return_vector.add(qualifier_info);
        }
        return return_vector;
    }

    private void fireChangeEvent(String option_name) {
        Enumeration e = this.option_listener_hash.keys();
        while (e.hasMoreElements()) {
            OptionChangeEvent event = new OptionChangeEvent(this, option_name);
            OptionChangeListener target = (OptionChangeListener)e.nextElement();
            target.optionChanged(event);
        }
    }
}

