/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis;

import java.util.EventObject;
import java.util.Vector;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.GotoListener;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class SimpleGotoEventSource
implements GotoEventSource {
    private EntryGroup entry_group;
    private final Vector goto_listener_list = new Vector();

    public SimpleGotoEventSource(EntryGroup entry_group) {
        this.entry_group = entry_group;
    }

    public void gotoBase(Marker base_marker) {
        GotoEvent new_event = new GotoEvent(this, base_marker);
        this.sendGotoEvent(new_event);
    }

    public void gotoFirstBase() {
        this.gotoBase(1);
    }

    public void gotoLastBase() {
        this.gotoBase(this.getEntryGroup().getSequenceLength());
    }

    public MarkerRange gotoBase(int destination_base) {
        try {
            Strand forward_strand = this.getEntryGroup().getBases().getForwardStrand();
            Marker destination_marker = forward_strand.makeMarker(destination_base);
            this.gotoBase(destination_marker);
            return new MarkerRange(destination_marker.getStrand(), destination_base, destination_base);
        }
        catch (OutOfRangeException outOfRangeException) {
            return null;
        }
    }

    public void sendGotoEvent(GotoEvent goto_event) {
        if (goto_event.getMarker() != null) {
            this.fireAction(this.goto_listener_list, goto_event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(Vector listeners, EventObject event) {
        Vector targets;
        SimpleGotoEventSource simpleGotoEventSource = this;
        synchronized (simpleGotoEventSource) {
            targets = (Vector)listeners.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            GotoListener target = (GotoListener)targets.elementAt(i);
            if (!(event instanceof GotoEvent)) {
                throw new Error("EntryEdit.fireAction () - unknown event");
            }
            GotoListener goto_listener = target;
            goto_listener.performGoto((GotoEvent)event);
            ++i;
        }
    }

    public void addGotoListener(GotoListener l) {
        this.goto_listener_list.addElement(l);
    }

    public void removeGotoListener(GotoListener l) {
        this.goto_listener_list.removeElement(l);
    }

    public EntryGroup getEntryGroup() {
        return this.entry_group;
    }
}

