/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.AlignMatchVector;
import uk.ac.sanger.artemis.components.AlignmentViewer;

public class AlignMatchViewer
extends JFrame {
    private AlignmentViewer alignment_viewer = null;
    private AlignMatchVector matches = null;
    private JList list;
    private JCheckBoxMenuItem sort_by_score_menu_item = new JCheckBoxMenuItem("Sort by Score");
    private JCheckBoxMenuItem sort_by_percent_id_menu_item = new JCheckBoxMenuItem("Sort by Percent Identity");
    private JCheckBoxMenuItem sort_by_query_start = new JCheckBoxMenuItem("Sort by Hit Query Start");
    private JCheckBoxMenuItem sort_by_subject_start = new JCheckBoxMenuItem("Sort by Hit Subject start");

    public AlignMatchViewer(AlignmentViewer alignment_viewer, AlignMatchVector matches) {
        this.alignment_viewer = alignment_viewer;
        this.matches = matches;
        JMenuBar menu_bar = new JMenuBar();
        JMenu file_menu = new JMenu("File");
        JMenuItem close = new JMenuItem("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AlignMatchViewer.this.setVisible(false);
                AlignMatchViewer.this.dispose();
            }
        });
        file_menu.add(close);
        menu_bar.add(file_menu);
        JMenu sort_menu = new JMenu("Sort");
        sort_menu.add(this.sort_by_score_menu_item);
        this.sort_by_score_menu_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AlignMatchViewer.this.sort_by_score_menu_item.getState()) {
                    AlignMatchViewer.this.sort_by_percent_id_menu_item.setState(false);
                    AlignMatchViewer.this.sort_by_query_start.setState(false);
                    AlignMatchViewer.this.sort_by_subject_start.setState(false);
                }
                AlignMatchViewer.this.setList();
            }
        });
        sort_menu.add(this.sort_by_percent_id_menu_item);
        this.sort_by_percent_id_menu_item.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AlignMatchViewer.this.sort_by_percent_id_menu_item.getState()) {
                    AlignMatchViewer.this.sort_by_score_menu_item.setState(false);
                    AlignMatchViewer.this.sort_by_query_start.setState(false);
                    AlignMatchViewer.this.sort_by_subject_start.setState(false);
                }
                AlignMatchViewer.this.setList();
            }
        });
        sort_menu.add(this.sort_by_query_start);
        this.sort_by_query_start.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AlignMatchViewer.this.sort_by_query_start.getState()) {
                    AlignMatchViewer.this.sort_by_percent_id_menu_item.setState(false);
                    AlignMatchViewer.this.sort_by_score_menu_item.setState(false);
                    AlignMatchViewer.this.sort_by_subject_start.setState(false);
                }
                AlignMatchViewer.this.setList();
            }
        });
        sort_menu.add(this.sort_by_subject_start);
        this.sort_by_subject_start.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (AlignMatchViewer.this.sort_by_subject_start.getState()) {
                    AlignMatchViewer.this.sort_by_percent_id_menu_item.setState(false);
                    AlignMatchViewer.this.sort_by_score_menu_item.setState(false);
                    AlignMatchViewer.this.sort_by_query_start.setState(false);
                }
                AlignMatchViewer.this.setList();
            }
        });
        menu_bar.add(sort_menu);
        this.setJMenuBar(menu_bar);
        this.list = new JList();
        this.list.setBackground(Color.white);
        this.getContentPane().add((Component)this.list, "Center");
        JPanel panel = new JPanel();
        JButton close_button = new JButton("Close");
        panel.add(close_button);
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignMatchViewer.this.dispose();
            }
        });
        close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignMatchViewer.this.dispose();
            }
        });
        this.getContentPane().add((Component)panel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                AlignMatchViewer.this.dispose();
            }
        });
        this.pack();
        this.setList();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int screen_height = screen.height;
        int cfr_ignored_0 = screen.width;
        if (screen_height <= 600) {
            this.setSize(350, screen_height * 9 / 10);
        } else {
            this.setSize(350, screen_height - 200);
        }
        this.setLocation(new Point(screen.width - this.getSize().width - 5, (screen.height - this.getSize().height) / 2));
    }

    /*
     * WARNING - void declaration
     */
    private AlignMatchVector getSortedMatches() {
        void var2_2;
        Comparator comparator;
        AlignMatchVector matches_copy = (AlignMatchVector)this.matches.clone();
        if (this.sort_by_score_menu_item.getState()) {
            comparator = new Comparator(){

                public int compare(Object fst, Object snd) {
                    int snd_score;
                    int fst_score = ((AlignMatch)fst).getScore();
                    if (fst_score < (snd_score = ((AlignMatch)snd).getScore())) {
                        return 1;
                    }
                    if (fst_score > snd_score) {
                        return -1;
                    }
                    return 0;
                }
            };
        } else if (this.sort_by_percent_id_menu_item.getState()) {
            comparator = new Comparator(){

                public int compare(Object fst, Object snd) {
                    int snd_value;
                    int fst_value = ((AlignMatch)fst).getPercentID();
                    if (fst_value < (snd_value = ((AlignMatch)snd).getPercentID())) {
                        return 1;
                    }
                    if (fst_value > snd_value) {
                        return -1;
                    }
                    return 0;
                }
            };
        } else if (this.sort_by_query_start.getState()) {
            comparator = new Comparator(){

                public int compare(Object fst, Object snd) {
                    int snd_value;
                    int fst_value = ((AlignMatch)fst).getQuerySequenceStart();
                    if (fst_value > (snd_value = ((AlignMatch)snd).getQuerySequenceStart())) {
                        return 1;
                    }
                    if (fst_value < snd_value) {
                        return -1;
                    }
                    return 0;
                }
            };
        } else if (this.sort_by_subject_start.getState()) {
            comparator = new Comparator(){

                public int compare(Object fst, Object snd) {
                    int snd_value;
                    int fst_value = ((AlignMatch)fst).getSubjectSequenceStart();
                    if (fst_value > (snd_value = ((AlignMatch)snd).getSubjectSequenceStart())) {
                        return 1;
                    }
                    if (fst_value < snd_value) {
                        return -1;
                    }
                    return 0;
                }
            };
        } else {
            return this.matches;
        }
        matches_copy.sort((Comparator)var2_2);
        return matches_copy;
    }

    private void setList() {
        AlignMatchVector sorted_matches = this.getSortedMatches();
        this.list.setEnabled(false);
        this.list.setVisible(false);
        this.list.removeAll();
        String[] listItems = new String[sorted_matches.size()];
        int i = 0;
        while (i < sorted_matches.size()) {
            AlignMatch this_align_match = sorted_matches.elementAt(i);
            listItems[i] = new String(String.valueOf(this_align_match.getQuerySequenceStart()) + ".." + this_align_match.getQuerySequenceEnd() + " -> " + this_align_match.getSubjectSequenceStart() + ".." + this_align_match.getSubjectSequenceEnd() + " " + (this_align_match.isRevMatch() ? "rev " : "") + this_align_match.getPercentID() + "% id score " + this_align_match.getScore());
            ++i;
        }
        this.list.setListData(listItems);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int item_number = AlignMatchViewer.this.list.getSelectedIndex();
                AlignMatch selected_match = AlignMatchViewer.this.matches.elementAt(item_number);
                AlignMatchViewer.this.alignment_viewer.setSelection(selected_match);
                AlignMatchViewer.this.alignment_viewer.alignAt(selected_match);
            }
        });
        this.list.setEnabled(true);
        this.list.setVisible(true);
    }
}

