/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.swing.JFrame;
import nsdb.Embl;
import nsdb.EmblHelper;
import nsdb.EmblPackage.Superceded;
import nsdb.EmblSeq;
import nsdb.EmblSeqWriter;
import nsdb.EmblWriter;
import nsdb.EmblWriterHelper;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import type.NoResult;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntrySource;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.CorbaEntrySource;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.ProgressThread;
import uk.ac.sanger.artemis.components.TextDialog;
import uk.ac.sanger.artemis.io.CorbaEntry;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.InvalidKeyException;
import uk.ac.sanger.artemis.io.LocationParseException;
import uk.ac.sanger.artemis.io.RWCorbaEntry;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.NoSequenceException;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class EMBLCorbaEntrySource
extends CorbaEntrySource
implements EntrySource {
    public EMBLCorbaEntrySource(JFrame frame, String ior_url_string) throws MalformedURLException {
        super(frame, ior_url_string);
    }

    public Entry getEntry(Bases bases, ProgressThread progress_thread, boolean show_progress) throws OutOfRangeException, IOException {
        return this.makeCorbaDialog(bases, false);
    }

    public Entry getEntry(Bases bases, boolean show_progress) throws OutOfRangeException, IOException {
        return this.makeCorbaDialog(bases, false);
    }

    public Entry getEntry(boolean show_progress, ProgressThread progress_thread) throws OutOfRangeException, IOException {
        return this.makeCorbaDialog(null, false);
    }

    public Entry getEntry(boolean show_progress) throws OutOfRangeException, NoSequenceException, IOException {
        return this.makeCorbaDialog(null, false);
    }

    public String getSourceName() {
        return "EBI - CORBA";
    }

    public boolean isFullEntrySource() {
        return true;
    }

    protected Entry makeCorbaDialog(Bases bases, boolean read_only) throws OutOfRangeException, IOException {
        ORB.init((String[])new String[0], (Properties)new Properties());
        TextDialog text_dialog = new TextDialog(this.getFrame(), "Enter an accession number:", 10, "");
        String text = text_dialog.getText();
        if (text == null) {
            return null;
        }
        String corba_id = text.trim();
        if (corba_id.length() > 0) {
            MessageDialog message_frame = new MessageDialog(this.getFrame(), "reading entry - please wait", false);
            try {
                Entry entry = this.makeFromCorbaID(bases, corba_id, read_only);
                message_frame.dispose();
                return entry;
            }
            catch (Throwable throwable) {
                message_frame.dispose();
                throw throwable;
            }
        }
        return null;
    }

    protected Entry makeFromCorbaID(Bases bases, String corba_id, boolean read_only) throws OutOfRangeException, IOException {
        try {
            Bases real_bases;
            uk.ac.sanger.artemis.io.Entry new_embl_entry;
            Embl corba_handle = this.getServerHandle();
            EmblWriter embl_writer = EmblWriterHelper.narrow(corba_handle);
            SimpleEntryInformation entry_information = new SimpleEntryInformation(Options.getArtemisEntryInformation());
            if (read_only || embl_writer == null) {
                EmblSeq embl_seq = corba_handle.getEmblSeq(corba_id);
                new_embl_entry = new CorbaEntry(entry_information, embl_seq);
            } else {
                EmblSeqWriter embl_write_seq = embl_writer.getEmblSeqWriter(corba_id);
                new_embl_entry = new RWCorbaEntry(entry_information, embl_write_seq);
            }
            if (bases == null) {
                if (new_embl_entry.getSequence() == null) {
                    String message = "the entry contains no sequence: " + corba_id;
                    new MessageDialog(this.getFrame(), message);
                    return null;
                }
                real_bases = new Bases(new_embl_entry.getSequence());
            } else {
                real_bases = bases;
            }
            return new Entry(real_bases, new_embl_entry);
        }
        catch (NoResult noResult) {
            String message = "Database query failed (no result) while getting id: " + corba_id;
            new MessageDialog(this.getFrame(), message);
        }
        catch (Superceded superceded) {
            String message = "This accession number has been superceded: " + corba_id;
            new MessageDialog(this.getFrame(), message);
        }
        catch (LocationParseException e) {
            String message = "Unexpected error while accessing " + corba_id + ": " + e;
            new MessageDialog(this.getFrame(), message);
        }
        catch (InvalidKeyException e) {
            String message = "Unexpected error while accessing " + corba_id + ": " + e;
            new MessageDialog(this.getFrame(), message);
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            String message = "the object you requested (" + corba_id + ") does not exist";
            new MessageDialog(this.getFrame(), message);
        }
        catch (COMM_FAILURE e) {
            String message = "Failed to get an object from Corba: " + (java.lang.Object)((java.lang.Object)e);
            new MessageDialog(this.getFrame(), message);
        }
        catch (EntryInformationException e) {
            String message = "Failed to get an object from Corba: " + e;
            new MessageDialog(this.getFrame(), message);
        }
        return null;
    }

    protected Embl getServerHandle() throws COMM_FAILURE, IOException {
        ORB orb = ORB.init((String[])new String[0], (Properties)new Properties());
        Object obj = orb.string_to_object(this.getIOR());
        return EmblHelper.narrow(obj);
    }
}

