/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.PlotMouseListener;
import uk.ac.sanger.artemis.plot.Algorithm;

public abstract class Plot
extends JPanel {
    private JComponent canvas = null;
    private JScrollBar window_changer = null;
    private int font_height;
    private Image offscreen;
    private Algorithm algorithm;
    private boolean draw_scale;
    protected boolean recalculate_flag = true;
    private int cross_hair_position = -1;
    private int drag_start_position = -1;
    private final Vector listener_list = new Vector();
    final int SCROLL_NOB_SIZE = 10;
    private static final int MINIMUM_LABEL_SPACING = 50;

    public Plot(Algorithm algorithm, boolean draw_scale) {
        this.algorithm = algorithm;
        this.draw_scale = draw_scale;
        Font font = Options.getOptions().getFont();
        this.setFont(font);
        FontMetrics fm = this.getFontMetrics(font);
        this.font_height = fm.getHeight();
        this.setLayout(new BorderLayout());
        int MAX_WINDOW = this.getAlgorithm().getDefaultMaxWindowSize() != null ? this.getAlgorithm().getDefaultMaxWindowSize() : 500;
        int MIN_WINDOW = this.getAlgorithm().getDefaultMinWindowSize() != null ? this.getAlgorithm().getDefaultMinWindowSize() : 5;
        int START_WINDOW = this.getAlgorithm().getDefaultWindowSize() == null ? 10 : this.getAlgorithm().getDefaultWindowSize();
        this.window_changer = new JScrollBar(1);
        this.window_changer.setValues(START_WINDOW, 10, MIN_WINDOW, MAX_WINDOW + 10);
        if (MAX_WINDOW >= 50) {
            this.window_changer.setBlockIncrement(MAX_WINDOW / 50);
        } else {
            this.window_changer.setBlockIncrement(1);
        }
        this.window_changer.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Plot.this.recalculate_flag = true;
                Plot.this.repaintCanvas();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                Plot.this.recalculate_flag = true;
                Plot.this.repaintCanvas();
            }
        });
        this.add((Component)this.window_changer, "East");
        this.createCanvas();
        this.getCanvas().setBackground(Color.white);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getWindowSize() {
        return this.window_changer.getValue();
    }

    private void createCanvas() {
        this.canvas = new JComponent(){

            public void invalidate() {
                super.invalidate();
                Plot.this.offscreen = null;
            }

            public void update(Graphics g) {
                this.paint(g);
            }

            public void paint(Graphics g) {
                Plot.this.paintCanvas(g);
            }
        };
        MouseAdapter mouse_listener = new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger() || event.isMetaDown()) {
                    JComponent parent = (JComponent)event.getSource();
                    JPopupMenu popup = new JPopupMenu("Plot Options");
                    JCheckBoxMenuItem scaling_toggle = new JCheckBoxMenuItem("Scaling");
                    scaling_toggle.setState(Plot.this.getAlgorithm().scalingFlag());
                    scaling_toggle.addItemListener(new ItemListener(this, scaling_toggle){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ JCheckBoxMenuItem val$scaling_toggle;
                        {
                            this.this$1 = var1_1;
                            this.val$scaling_toggle = jCheckBoxMenuItem;
                        }

                        public void itemStateChanged(ItemEvent _) {
                            4.access$0(this.this$1).getAlgorithm().setScalingFlag(this.val$scaling_toggle.getState());
                            4.access$0(this.this$1).recalculate_flag = true;
                            4.access$0(this.this$1).repaintCanvas();
                        }
                    });
                    popup.add(scaling_toggle);
                    popup.addSeparator();
                    JMenuItem max_window_size = new JMenuItem("Maximum Window Size:");
                    popup.add(max_window_size);
                    int[] window_sizes = new int[]{100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000};
                    int i = 0;
                    while (i < window_sizes.length) {
                        int size = i;
                        JMenuItem window_size_item = new JMenuItem(" " + window_sizes[i]);
                        window_size_item.addActionListener(new ActionListener(this, window_sizes, size){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ int[] val$window_sizes;
                            private final /* synthetic */ int val$size;
                            {
                                this.this$1 = var1_1;
                                this.val$window_sizes = nArray;
                                this.val$size = n;
                            }

                            public void actionPerformed(ActionEvent _) {
                                int new_maximum = this.val$window_sizes[this.val$size];
                                if (new_maximum > Plot.access$2(4.access$0(this.this$1)).getMinimum()) {
                                    Plot.access$2(4.access$0(this.this$1)).setMaximum(new_maximum + 10);
                                    4.access$0(this.this$1).recalculate_flag = true;
                                    4.access$0(this.this$1).repaintCanvas();
                                }
                            }
                        });
                        popup.add(window_size_item);
                        ++i;
                    }
                    parent.add(popup);
                    popup.show(parent, event.getX(), event.getY());
                } else {
                    int point_x = event.getPoint().x;
                    int point_y = event.getPoint().y;
                    if (point_y > Plot.this.getLabelHeight()) {
                        Plot.this.cross_hair_position = point_x;
                        Plot.this.drag_start_position = point_x;
                    } else {
                        Plot.this.cancelCrossHairs();
                    }
                    if (event.getClickCount() == 2) {
                        Plot.this.fireDoubleClickEvent();
                    } else {
                        Plot.this.fireClickEvent();
                    }
                    Plot.this.repaintCanvas();
                }
            }

            static /* synthetic */ Plot access$0(4 var0) {
                return var0.Plot.this;
            }
        };
        this.canvas.addMouseListener(mouse_listener);
        MouseMotionAdapter mouse_motion_listener = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent event) {
                if (Plot.this.isMenuTrigger(event)) {
                    return;
                }
                int point_x = event.getPoint().x;
                int point_y = event.getPoint().y;
                if (point_y > Plot.this.getLabelHeight()) {
                    Plot.this.cross_hair_position = point_x;
                } else {
                    Plot.this.cancelCrossHairs();
                }
                Plot.this.fireDragEvent();
                Plot.this.repaintCanvas();
            }
        };
        this.canvas.addMouseMotionListener(mouse_motion_listener);
        this.add((Component)this.canvas, "Center");
    }

    private boolean isMenuTrigger(MouseEvent event) {
        return event.isPopupTrigger() || (event.getModifiers() & 4) != 0;
    }

    private void fireClickEvent() {
        int i = 0;
        while (i < this.listener_list.size()) {
            PlotMouseListener listener = (PlotMouseListener)this.listener_list.elementAt(i);
            listener.mouseClick(this.getPointPosition(this.cross_hair_position));
            ++i;
        }
    }

    private void fireDragEvent() {
        int i = 0;
        while (i < this.listener_list.size()) {
            PlotMouseListener listener = (PlotMouseListener)this.listener_list.elementAt(i);
            listener.mouseDrag(this.getPointPosition(this.drag_start_position), this.getPointPosition(this.cross_hair_position));
            ++i;
        }
    }

    private void fireDoubleClickEvent() {
        int i = 0;
        while (i < this.listener_list.size()) {
            PlotMouseListener listener = (PlotMouseListener)this.listener_list.elementAt(i);
            listener.mouseDoubleClick(this.getPointPosition(this.cross_hair_position));
            ++i;
        }
    }

    public void addPlotMouseListener(PlotMouseListener listener) {
        this.listener_list.addElement(listener);
    }

    public void removePlotMouseListener(PlotMouseListener listener) {
        this.listener_list.removeElement(listener);
    }

    private void paintCanvas(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        int canvas_width = this.canvas.getSize().width;
        int canvas_height = this.canvas.getSize().height;
        if (canvas_height <= 0 || canvas_width <= 0) {
            return;
        }
        if (this.offscreen == null) {
            this.offscreen = this.createImage(canvas_width, canvas_height);
        }
        Graphics og = this.offscreen.getGraphics();
        og.setClip(0, 0, canvas_width, canvas_height);
        og.setColor(new Color(240, 240, 240));
        og.fillRect(0, 0, this.canvas.getSize().width, this.canvas.getSize().height);
        this.drawMultiValueGraph(og);
        this.drawLabels(og);
        g.drawImage(this.offscreen, 0, 0, null);
        og.dispose();
    }

    protected int getCrossHairPosition() {
        if (this.cross_hair_position >= this.getCanvas().getSize().width) {
            return -1;
        }
        return this.cross_hair_position;
    }

    protected void cancelCrossHairs() {
        this.cross_hair_position = -1;
        this.drag_start_position = -1;
    }

    protected void drawScaleLine(Graphics g, int start, int end) {
        int cfr_ignored_0 = this.canvas.getSize().width;
        int canvas_height = this.canvas.getSize().height;
        int scale_number_y_pos = canvas_height - 1;
        int possible_index_of_first_label = start / 50;
        int index_of_first_label = possible_index_of_first_label == 0 ? 1 : possible_index_of_first_label;
        int index_of_last_label = end / 50;
        int i = index_of_first_label;
        while (i <= index_of_last_label) {
            String label_string = String.valueOf(i * 50);
            int scale_number_x_pos = (int)((float)(i * 50 - start) / 1.0f);
            g.drawString(label_string, scale_number_x_pos + 2, scale_number_y_pos);
            g.drawLine(scale_number_x_pos, canvas_height - this.getScaleHeight() / 2, scale_number_x_pos, canvas_height - this.getScaleHeight());
            ++i;
        }
    }

    protected void drawPoints(Graphics g, float min_value, float max_value, int step_size, int window_size, int total_unit_count, int start_position, float[] plot_values) {
        float residues_per_pixel = (float)total_unit_count / (float)this.canvas.getSize().width;
        int graph_height = this.canvas.getSize().height - this.getLabelHeight() - this.getScaleHeight() - 2;
        if (graph_height < 5) {
            return;
        }
        int number_of_values = plot_values.length;
        int i = 0;
        while (i < number_of_values - 1) {
            int start_residue = window_size / 2 + i * step_size + start_position;
            int end_residue = start_residue + step_size;
            int start_x = (int)((float)start_residue / residues_per_pixel);
            int end_x = (int)((float)end_residue / residues_per_pixel);
            float scaled_start_value = (plot_values[i] - min_value) / (max_value - min_value);
            int start_y = graph_height - (int)(scaled_start_value * (float)graph_height) + this.getLabelHeight() + 1;
            float scaled_end_value = (plot_values[i + 1] - min_value) / (max_value - min_value);
            int end_y = graph_height - (int)(scaled_end_value * (float)graph_height) + this.getLabelHeight() + 1;
            g.drawLine(start_x, start_y, end_x, end_y);
            ++i;
        }
    }

    protected abstract void drawMultiValueGraph(Graphics var1);

    protected void drawGlobalAverage(Graphics g, float min_value, float max_value) {
        Float average = this.getAlgorithm().getAverage();
        if (average != null) {
            g.setColor(Color.gray);
            int graph_height = this.canvas.getSize().height - this.getFontHeight();
            float scaled_average = (average.floatValue() - min_value) / (max_value - min_value);
            int position = graph_height - (int)(scaled_average * (float)graph_height) + this.getFontHeight() + 1;
            g.drawLine(0, position, this.canvas.getSize().width, position);
            FontMetrics fm = g.getFontMetrics();
            int canvas_width = this.canvas.getSize().width;
            String average_string = String.valueOf((double)Math.round((double)average.floatValue() * 100.0) / 100.0);
            g.drawString(average_string, canvas_width - fm.stringWidth(average_string) - 1, position);
        }
    }

    private void drawLabels(Graphics g) {
        g.setColor(Color.black);
        g.drawString(String.valueOf(this.getAlgorithm().getAlgorithmName()) + "  Window size: " + String.valueOf(this.window_changer.getValue()), 2, this.font_height);
    }

    protected void drawMinMax(Graphics g, float min_value, float max_value) {
        g.setColor(Color.black);
        int canvas_width = this.canvas.getSize().width;
        int canvas_height = this.canvas.getSize().height;
        g.drawLine(0, canvas_height - this.getScaleHeight(), canvas_width, canvas_height - this.getScaleHeight());
        g.drawLine(0, this.getLabelHeight(), canvas_width, this.getLabelHeight());
        FontMetrics fm = g.getFontMetrics();
        String min_string = String.valueOf((double)((int)(min_value * 100.0f)) / 100.0);
        g.drawString(min_string, canvas_width - fm.stringWidth(min_string) - 1, canvas_height - 1 - this.getScaleHeight());
        String max_string = String.valueOf((double)((int)(max_value * 100.0f)) / 100.0);
        g.drawString(max_string, canvas_width - fm.stringWidth(max_string) - 1, 1 + this.getFontHeight() * 2);
    }

    protected void drawCrossHair(Graphics g, int x_position, String label, int label_pos) {
        if (x_position >= 0) {
            g.drawLine(x_position, this.getLabelHeight(), x_position, this.canvas.getSize().height);
            g.drawString(label, x_position + 2, this.getFontHeight() * (2 + label_pos) + 2);
        }
    }

    protected JComponent getCanvas() {
        return this.canvas;
    }

    protected void repaintCanvas() {
        this.canvas.repaint();
    }

    protected abstract void recalculateValues();

    protected abstract int getPointPosition(int var1);

    private int getScaleHeight() {
        if (this.draw_scale) {
            return this.getFontHeight() + 2;
        }
        return 0;
    }

    private int getLabelHeight() {
        return this.getFontHeight() + 2;
    }

    private int getFontHeight() {
        return this.font_height;
    }

    static /* synthetic */ JScrollBar access$2(Plot plot) {
        return plot.window_changer;
    }
}

