/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.components;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import uk.ac.sanger.artemis.EntrySourceVector;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.components.DbfetchEntrySource;
import uk.ac.sanger.artemis.components.EMBLCorbaEntrySource;
import uk.ac.sanger.artemis.components.FileDialogEntrySource;
import uk.ac.sanger.artemis.components.MessageDialog;
import uk.ac.sanger.artemis.components.WritableEMBLCorbaEntrySource;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;

public class Utilities {
    public static JFrame getComponentFrame(JComponent component) {
        if (component.getTopLevelAncestor() instanceof JFrame) {
            return (JFrame)component.getTopLevelAncestor();
        }
        return null;
    }

    public static void centreFrame(JFrame frame) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x_position = (screen.width - frame.getSize().width) / 2;
        int y_position = (screen.height - frame.getSize().height) / 2;
        if (y_position < 10) {
            y_position = 10;
        }
        frame.setLocation(new Point(x_position, y_position));
    }

    public static void centreOwningFrame(JComponent component) {
        JFrame frame = Utilities.getComponentFrame(component);
        Utilities.centreFrame(frame);
    }

    public static EntrySourceVector getEntrySources(JFrame frame, InputStreamProgressListener listener) {
        String db_ior_url;
        EntrySourceVector return_vector = new EntrySourceVector();
        return_vector.add(new FileDialogEntrySource(frame, listener));
        return_vector.add(new DbfetchEntrySource(frame));
        String embl_ior_url = Options.getOptions().getProperty("embl_ior_url");
        if (embl_ior_url != null) {
            try {
                return_vector.add(new EMBLCorbaEntrySource(frame, embl_ior_url));
            }
            catch (MalformedURLException e) {
                new MessageDialog(frame, "the url given for the embl database is badly formatted: " + e.getMessage());
            }
        }
        if ((db_ior_url = Options.getOptions().getProperty("db_ior_url")) != null) {
            try {
                return_vector.add(new WritableEMBLCorbaEntrySource(frame, db_ior_url));
            }
            catch (MalformedURLException e) {
                new MessageDialog(frame, "the url given for the embl database is badly formatted: " + e.getMessage());
            }
        }
        return return_vector;
    }
}

