/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import uk.ac.sanger.artemis.editor.BigPane;
import uk.ac.sanger.artemis.editor.BrowserControl;
import uk.ac.sanger.artemis.editor.CommonMenu;

public class Annotation
extends JEditorPane
implements HyperlinkListener {
    private int startRange;
    private int endRange;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private JDesktopPane desktop = null;
    private Vector back = new Vector();
    private JPopupMenu popup;
    private Vector qualifier = new Vector();

    public Annotation(JDesktopPane desktop) {
        this.desktop = desktop;
        this.setEditable(false);
        this.setContentType("text/html");
        this.setFont(BigPane.font);
        this.addHyperlinkListener(this);
    }

    public Annotation(URL url) throws IOException {
        super(url);
        this.setEditable(false);
        this.addHyperlinkListener(this);
        this.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        JMenuItem backMenu = new JMenuItem("Back");
        this.popup.add(backMenu);
        backMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Annotation.this.goBack();
            }
        });
        this.back.add(url);
    }

    protected void setAnnotation(String text) {
        String line = null;
        try {
            BufferedReader buffRead = new BufferedReader(new StringReader(text));
            while ((line = buffRead.readLine()) != null) {
                int ind = line.indexOf("=");
                if (ind <= -1) continue;
                this.qualifier.add(line.substring(0, ind + 1).toLowerCase());
            }
        }
        catch (IOException iOException) {}
        this.qualifier.add("/similarity=");
        this.qualifier.add("/gene=");
        text = this.getDatabaseHTML(text, "SWALL:");
        text = this.getDatabaseHTML(text, "UNIPROT:");
        text = this.getDatabaseHTML(text, "EMBL:");
        this.setText("<html><body>" + text + "</html></body>");
        this.startRange = this.getDocument().getLength();
    }

    protected void reportHTML() {
        try {
            String txt = ((HTMLDocument)this.getDocument()).getText(0, this.getDocument().getLength());
            System.out.println("TXT:\n" + txt);
            System.out.println("\nHTML:\n" + this.getText() + "\n\n");
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    protected String getFeatureText() {
        String txt = "";
        try {
            txt = ((HTMLDocument)this.getDocument()).getText(0, this.getDocument().getLength()).trim();
            StringBuffer buff = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(txt, "/");
            int ntok = 0;
            while (tok.hasMoreTokens()) {
                String tokTxt = "/" + tok.nextToken();
                int ind = tokTxt.indexOf("=");
                if (ntok != 0 && ind > -1 && this.qualifier.contains(tokTxt.substring(0, ind + 1))) {
                    buff.append("\n" + tokTxt);
                } else {
                    buff.append(tokTxt);
                }
                ++ntok;
            }
            txt = buff.toString();
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return txt;
    }

    protected void insert(String s, boolean ortholog) {
        s = this.getDatabaseHTML(s, "SWALL:");
        s = this.getDatabaseHTML(s, "UNIPROT:");
        s = this.getDatabaseHTML(s, "EMBL:");
        s.indexOf("/gene");
        Document doc = this.getDocument();
        int offset = doc.getLength();
        if (ortholog) {
            offset = this.startRange;
        }
        this.insert(s, offset);
    }

    protected void insert(String s, int offset) {
        try {
            HTMLEditorKit edKit = (HTMLEditorKit)this.getEditorKit();
            edKit.insertHTML((HTMLDocument)this.getDocument(), offset, "<BR>\n" + s, 0, 0, HTML.Tag.BR);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private String getDatabaseHTML(String s, String db) {
        int ind = s.indexOf(db);
        if (ind > -1) {
            String startStr = s.substring(0, ind);
            int ind2 = s.indexOf(" ", ind);
            int ind3 = s.indexOf(")", ind);
            if (ind3 > -1 && ind3 < ind2) {
                ind2 = ind3;
            }
            if ((ind3 = s.indexOf(";", ind)) > -1 && ind3 < ind2) {
                ind2 = ind3;
            }
            String midStr = s.substring(ind, ind2);
            String endStr = s.substring(ind2);
            String srscmd = "http://srs.sanger.ac.uk/srsbin/cgi-bin/wgetz?-e+[" + midStr + "]";
            s = String.valueOf(startStr) + "<a href=\"" + srscmd + "\">" + midStr + "</a>" + endStr;
        }
        return s;
    }

    private void replaceRange(String newStr, int start, int end) {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        try {
            doc.remove(start, end - start);
            this.insert(newStr, start);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.setDocument(doc);
    }

    protected void delete(String id, boolean ortholog) {
        String txt = this.getText();
        int indID = txt.indexOf("SWALL:" + id);
        if (indID == -1) {
            indID = txt.indexOf("UNIPROT:" + id);
        }
        int ind1 = 0;
        int ind2 = 0;
        while ((ind2 = txt.indexOf("<br>", ind1)) > -1) {
            if (ind2 >= indID) break;
            ind1 = ind2 + 1;
        }
        ind2 = txt.indexOf("<br>", indID);
        if (ortholog) {
            ind2 = txt.indexOf("<br>", ind2 + 4);
        }
        if (ind2 == -1) {
            ind2 = txt.length();
        }
        this.setText(String.valueOf(txt.substring(0, ind1 - 1)) + txt.substring(ind2));
    }

    protected void setUpSRSFrame(URL url, String search) throws IOException {
        if (BigPane.srsFrame == null) {
            BigPane.setUpSRSFrame(2 * this.desktop.getHeight() / 3, this.desktop);
            Border loweredbevel = BorderFactory.createLoweredBevelBorder();
            Border raisedbevel = BorderFactory.createRaisedBevelBorder();
            CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
            JTextField statusField = new JTextField();
            statusField.setBorder(compound);
            statusField.setEditable(false);
            BigPane.srsFrame.getContentPane().add((Component)statusField, "South");
        }
        Annotation edPane = new Annotation(url);
        JScrollPane jsp = new JScrollPane(edPane);
        JTabbedPane jtab = (JTabbedPane)BigPane.srsFrame.getContentPane().getComponent(0);
        jtab.insertTab(search, null, jsp, null, 0);
        BigPane.srsFrame.setVisible(true);
    }

    protected void goBack() {
        if (this.back.size() < 2) {
            return;
        }
        try {
            URL url = (URL)this.back.get(this.back.size() - 2);
            this.back.remove(this.back.size() - 1);
            this.setPage(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setCursor(this.cbusy);
            try {
                URL url = event.getURL();
                int ind1 = event.getDescription().indexOf("[");
                int ind2 = event.getDescription().lastIndexOf("]");
                String search = "";
                if (ind1 > -1 && ind2 > -1) {
                    search = event.getDescription().substring(ind1 + 1, ind2);
                }
                if (this.desktop != null) {
                    if (BigPane.srsTabPane.isSelected()) {
                        this.setUpSRSFrame(url, search);
                    }
                    if (BigPane.srsWin.isSelected()) {
                        int hgt = 2 * this.desktop.getHeight() / 3;
                        Annotation edPane = new Annotation(url);
                        JScrollPane jsp = new JScrollPane(edPane);
                        JInternalFrame jif = new JInternalFrame("SRS " + search, true, true, true, true);
                        JMenuBar menuBar = new JMenuBar();
                        menuBar.add(new CommonMenu(jif));
                        jif.setJMenuBar(menuBar);
                        jif.getContentPane().add(jsp);
                        jif.setLocation(0, 0);
                        jif.setSize(800, hgt);
                        jif.setVisible(true);
                        this.desktop.add(jif);
                    }
                    if (BigPane.srsBrowser.isSelected()) {
                        BrowserControl.displayURL(event.getDescription());
                    }
                } else {
                    this.setPage(url);
                    this.back.add(url);
                }
            }
            catch (IOException iOException) {
                String msg = event.getDescription();
                if (msg.length() > 50) {
                    msg = String.valueOf(msg.substring(0, 50)) + "....";
                }
                JOptionPane.showMessageDialog(this, "Cannot reach URL:\n" + msg, "Cannot Connect", 1);
            }
            this.setCursor(this.cdone);
        } else if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            try {
                JTextField statusField = (JTextField)BigPane.srsFrame.getContentPane().getComponent(1);
                statusField.setText(event.getDescription());
            }
            catch (Exception exception) {}
        } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
            try {
                JTextField statusField = (JTextField)BigPane.srsFrame.getContentPane().getComponent(1);
                statusField.setText("");
            }
            catch (Exception exception) {}
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && Annotation.this.back.size() > 1) {
                Annotation.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

