/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.utils.ChangeVetoException;
import uk.ac.sanger.artemis.io.BioJavaEntry;
import uk.ac.sanger.artemis.io.ComparableFeature;
import uk.ac.sanger.artemis.io.EMBLObject;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformationException;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.InvalidRelationException;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.util.OutOfRangeException;
import uk.ac.sanger.artemis.util.ReadOnlyException;
import uk.ac.sanger.artemis.util.StringVector;

public class BioJavaFeature
extends EMBLObject
implements ComparableFeature {
    org.biojava.bio.seq.Feature bioJavaFeature;
    private BioJavaEntry nativeEntry;
    private Key nativeKey;
    private Location nativeLocation;
    private QualifierVector nativeQualifiers;
    private static long id_counter = 0L;
    private final long id = id_counter++;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BioJavaFeature(org.biojava.bio.seq.Feature feature, BioJavaEntry nativeEntry) {
        this.bioJavaFeature = feature;
        this.nativeEntry = nativeEntry;
    }

    public void set(Key key, Location loc, QualifierVector qualifiers) throws EntryInformationException, ReadOnlyException, OutOfRangeException {
        this.setKey(key);
        this.setLocation(loc);
        this.setQualifiers(qualifiers);
    }

    public Key getKey() {
        return new Key(this.bioJavaFeature.getType());
    }

    public long getNumericID() {
        return this.id;
    }

    public Feature copy() {
        return new BioJavaFeature(this.bioJavaFeature, this.nativeEntry);
    }

    public Location getLocation() {
        return this.makeNativeLocation();
    }

    public Entry getEntry() {
        return this.nativeEntry;
    }

    org.biojava.bio.seq.Feature getBioJavaFeature() {
        return this.bioJavaFeature;
    }

    void setBioJavaEntry(BioJavaEntry entry) {
        this.nativeEntry = entry;
    }

    public int getFirstBase() {
        return this.getLocation().getFirstBase();
    }

    public int getLastBase() {
        return this.getLocation().getLastBase();
    }

    public Qualifier getQualifierByName(String name) throws InvalidRelationException {
        Annotation annotation = this.bioJavaFeature.getAnnotation();
        if (!annotation.containsProperty((Object)name)) {
            return null;
        }
        Object value = annotation.getProperty((Object)name);
        StringVector sv = new StringVector();
        if (Collection.class.isInstance(value)) {
            Iterator vi = ((Collection)value).iterator();
            while (vi.hasNext()) {
                sv.add(vi.next().toString());
            }
        } else {
            sv.add(value.toString());
        }
        return new Qualifier(name, sv);
    }

    public QualifierVector getQualifiers() {
        Annotation annotation = this.bioJavaFeature.getAnnotation();
        QualifierVector qualifiers = new QualifierVector();
        ArrayList keys = new ArrayList();
        keys.addAll(annotation.keys());
        Collections.sort(keys);
        for (Object key : keys) {
            Object value = annotation.getProperty(key);
            if (key.equals("internal_data")) continue;
            if (value instanceof Collection) {
                StringVector sv = new StringVector();
                Iterator vi = ((Collection)value).iterator();
                while (vi.hasNext()) {
                    sv.add(vi.next().toString());
                }
                qualifiers.addQualifierValues(new Qualifier(key.toString(), sv));
                continue;
            }
            if (value instanceof Boolean) {
                qualifiers.setQualifier(new Qualifier(key.toString()));
                continue;
            }
            if (!(value instanceof String)) continue;
            qualifiers.addQualifierValues(new Qualifier(key.toString(), value.toString()));
        }
        return qualifiers;
    }

    public void removeQualifierByName(String name) throws EntryInformationException, ReadOnlyException {
        if (this.getEntry() == null) {
            return;
        }
        BioJavaEntry saved_entry = this.nativeEntry;
        saved_entry.removeFromTable(this);
        try {
            try {
                this.bioJavaFeature.getAnnotation().removeProperty((Object)name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EntryInformationException("cannot remove qualifier: " + name);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new ReadOnlyException("cannot remove qualifier: " + name);
            }
        }
        finally {
            saved_entry.setDirtyFlag();
            saved_entry.addToTable(this);
        }
    }

    public void setKey(Key key) throws EntryInformationException, ReadOnlyException {
        if (key == null) {
            return;
        }
        if (this.getEntry() == null) {
            return;
        }
        BioJavaEntry saved_entry = this.nativeEntry;
        saved_entry.removeFromTable(this);
        try {
            try {
                this.bioJavaFeature.setType(key.toString());
            }
            catch (ChangeVetoException changeVetoException) {
                throw new ReadOnlyException("cannot set key");
            }
        }
        finally {
            saved_entry.setDirtyFlag();
            saved_entry.addToTable(this);
        }
    }

    public void setLocation(Location location) throws OutOfRangeException, ReadOnlyException {
        if (location == null || this.getEntry() == null) {
            return;
        }
        BioJavaEntry saved_entry = this.nativeEntry;
        saved_entry.removeFromTable(this);
        org.biojava.bio.symbol.Location bioJavaLocation = BioJavaFeature.makeBioJavaLocation(location);
        try {
            try {
                this.bioJavaFeature.setLocation(bioJavaLocation);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new ReadOnlyException("cannot set location");
            }
        }
        finally {
            saved_entry.setDirtyFlag();
            saved_entry.addToTable(this);
        }
    }

    static org.biojava.bio.symbol.Location makeBioJavaLocation(Location artemisLocation) {
        ArrayList<org.biojava.bio.symbol.Location> al = new ArrayList<org.biojava.bio.symbol.Location>();
        RangeVector ranges = artemisLocation.getRanges();
        int i = 0;
        while (i < ranges.size()) {
            Range range = ranges.elementAt(i);
            al.add(LocationTools.makeLocation((int)range.getStart(), (int)range.getEnd()));
            ++i;
        }
        return LocationTools.union(al);
    }

    public void setQualifier(Qualifier qualifier) throws EntryInformationException, ReadOnlyException {
        BioJavaEntry saved_entry = this.nativeEntry;
        if (this.getEntry() == null) {
            return;
        }
        saved_entry.removeFromTable(this);
        try {
            try {
                this.setQualifierInternal(qualifier);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EntryInformationException("cannot remove qualifier: " + qualifier.getName());
            }
            catch (ChangeVetoException changeVetoException) {
                throw new ReadOnlyException("cannot remove qualifier: " + qualifier.getName());
            }
        }
        finally {
            saved_entry.setDirtyFlag();
            saved_entry.addToTable(this);
        }
    }

    private void setQualifierInternal(Qualifier qualifier) throws IllegalArgumentException, ChangeVetoException {
        Annotation annotation = this.bioJavaFeature.getAnnotation();
        if (qualifier.getValues() == null) {
            annotation.setProperty((Object)qualifier.getName(), (Object)new Boolean(true));
        } else if (qualifier.getValues().size() == 1) {
            annotation.setProperty((Object)qualifier.getName(), (Object)qualifier.getValues().elementAt(0));
        } else {
            annotation.setProperty((Object)qualifier.getName(), (Object)qualifier.getValues().asCollection());
        }
    }

    private void clearAnnotation() throws ChangeVetoException {
        Annotation annotation = this.bioJavaFeature.getAnnotation();
        ArrayList keys = new ArrayList();
        keys.addAll(annotation.keys());
        for (Object key : keys) {
            if (key.equals("internal_data")) continue;
            annotation.removeProperty(key);
        }
    }

    public void setQualifiers(QualifierVector qualifiers) throws EntryInformationException, ReadOnlyException {
        if (qualifiers == null) {
            return;
        }
        if (this.getEntry() == null) {
            return;
        }
        BioJavaEntry saved_entry = this.nativeEntry;
        saved_entry.removeFromTable(this);
        try {
            try {
                this.clearAnnotation();
                int i = 0;
                while (i < qualifiers.size()) {
                    this.setQualifierInternal(qualifiers.elementAt(i));
                    ++i;
                }
            }
            catch (ChangeVetoException changeVetoException) {
                throw new ReadOnlyException("cannot set qualifiers");
            }
        }
        finally {
            saved_entry.setDirtyFlag();
            saved_entry.addToTable(this);
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    private Location makeNativeLocation() {
        org.biojava.bio.symbol.Location locs = this.bioJavaFeature.getLocation();
        boolean complement = false;
        if (StrandedFeature.class.isInstance(this.bioJavaFeature) && ((StrandedFeature)this.bioJavaFeature).getStrand().getValue() == -1) {
            complement = true;
        }
        RangeVector ranges = new RangeVector();
        Iterator li = locs.blockIterator();
        while (li.hasNext()) {
            org.biojava.bio.symbol.Location thisLoc = (org.biojava.bio.symbol.Location)li.next();
            int min = thisLoc.getMin() == Integer.MIN_VALUE ? 1 : thisLoc.getMin();
            int max = thisLoc.getMax() == Integer.MAX_VALUE ? this.getEntry().getSequence().length() : thisLoc.getMax();
            try {
                if (min != max) {
                    if (complement) {
                        ranges.insertElementAt(new Range(min, max), 0);
                        continue;
                    }
                    ranges.add(new Range(min, max));
                    continue;
                }
                if (complement) {
                    ranges.insertElementAt(new Range(min), 0);
                    continue;
                }
                ranges.add(new Range(min));
            }
            catch (OutOfRangeException ore) {
                System.err.println("Error converting BioJava range: " + ore.getMessage());
            }
        }
        return new Location(ranges, complement);
    }
}

