/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class GCDeviationAlgorithm
extends BaseAlgorithm {
    public GCDeviationAlgorithm(Strand strand) {
        super(strand, "GC Deviation (G-C)/(G+C)", "gc_deviation");
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        String sequence;
        try {
            sequence = this.getStrand().getSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        float g_count = 0.0f;
        float c_count = 0.0f;
        int i = 0;
        while (i < sequence.length()) {
            char this_char = sequence.charAt(i);
            if (this_char == 'g') {
                g_count += 1.0f;
            }
            if (this_char == 'c') {
                c_count += 1.0f;
            }
            ++i;
        }
        values[0] = c_count + g_count > 0.0f ? (g_count - c_count) / (g_count + c_count) : 0.0f;
    }

    public int getValueCount() {
        return 1;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(30);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(5000);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(10);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 10) {
            return new Integer(window_size / 10);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(1.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(-1.0f);
    }

    public Float getAverage() {
        float g_count = this.getStrand().getGCount();
        float c_count = this.getStrand().getCCount();
        float g_minus_c = g_count - c_count;
        float g_plus_c = g_count + c_count;
        if (g_plus_c > 0.0f) {
            return new Float(g_minus_c / g_plus_c);
        }
        return new Float(0.0);
    }
}

